/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.sdk.server.integrations;

import com.launchdarkly.sdk.server.BaseTest;
import com.launchdarkly.sdk.server.TestComponents;
import com.launchdarkly.sdk.server.subsystems.BigSegmentStore;
import com.launchdarkly.sdk.server.subsystems.BigSegmentStoreTypes;
import com.launchdarkly.sdk.server.subsystems.ClientContext;
import com.launchdarkly.sdk.server.subsystems.ComponentConfigurer;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.junit.Assert;
import org.junit.Test;

public abstract class BigSegmentStoreTestBase
extends BaseTest {
    private static final String prefix = "testprefix";
    private static final String fakeUserHash = "userhash";
    private static final String segmentRef1 = "key1";
    private static final String segmentRef2 = "key2";
    private static final String segmentRef3 = "key3";
    private static final String[] allSegmentRefs = new String[]{"key1", "key2", "key3"};

    private ClientContext makeClientContext() {
        return TestComponents.clientContext("", this.baseConfig().build());
    }

    private BigSegmentStore makeEmptyStore() throws Exception {
        BigSegmentStore store = (BigSegmentStore)this.makeStore(prefix).build(this.makeClientContext());
        try {
            this.clearData(prefix);
        }
        catch (RuntimeException ex) {
            store.close();
            throw ex;
        }
        return store;
    }

    @Test
    public void missingMetadata() throws Exception {
        try (BigSegmentStore store = this.makeEmptyStore();){
            Assert.assertNull((Object)store.getMetadata());
        }
    }

    @Test
    public void validMetadata() throws Exception {
        try (BigSegmentStore store = this.makeEmptyStore();){
            BigSegmentStoreTypes.StoreMetadata metadata = new BigSegmentStoreTypes.StoreMetadata(System.currentTimeMillis());
            this.setMetadata(prefix, metadata);
            BigSegmentStoreTypes.StoreMetadata result = store.getMetadata();
            Assert.assertNotNull((Object)result);
            Assert.assertEquals((long)metadata.getLastUpToDate(), (long)result.getLastUpToDate());
        }
    }

    @Test
    public void membershipNotFound() throws Exception {
        try (BigSegmentStore store = this.makeEmptyStore();){
            BigSegmentStoreTypes.Membership membership = store.getMembership(fakeUserHash);
            if (membership != null) {
                this.assertEqualMembership(BigSegmentStoreTypes.createMembershipFromSegmentRefs(null, null), membership);
            }
        }
    }

    @Test
    public void membershipFound() throws Exception {
        List<Memberships> membershipsList = Arrays.asList(new Memberships(Collections.singleton(segmentRef1), null), new Memberships(Arrays.asList(segmentRef1, segmentRef2), null), new Memberships(null, Collections.singleton(segmentRef1)), new Memberships(null, Arrays.asList(segmentRef1, segmentRef2)), new Memberships(Arrays.asList(segmentRef1, segmentRef2), Arrays.asList(segmentRef2, segmentRef3)));
        for (Memberships memberships : membershipsList) {
            BigSegmentStore store = this.makeEmptyStore();
            try {
                this.setSegments(prefix, fakeUserHash, memberships.inclusions, memberships.exclusions);
                BigSegmentStoreTypes.Membership membership = store.getMembership(fakeUserHash);
                this.assertEqualMembership(BigSegmentStoreTypes.createMembershipFromSegmentRefs(memberships.inclusions, memberships.exclusions), membership);
            }
            finally {
                if (store == null) continue;
                store.close();
            }
        }
    }

    private void assertEqualMembership(BigSegmentStoreTypes.Membership expected, BigSegmentStoreTypes.Membership actual) {
        if (actual.getClass().getCanonicalName().startsWith("com.launchdarkly.sdk.server.interfaces.BigSegmentStoreTypes.MembershipBuilder")) {
            Assert.assertEquals((Object)expected, (Object)actual);
        } else {
            for (String segmentRef : allSegmentRefs) {
                Boolean expectedMembership = expected.checkMembership(segmentRef);
                Boolean actualMembership = actual.checkMembership(segmentRef);
                if (Objects.equals(actualMembership, expectedMembership)) continue;
                Assert.fail((String)String.format("expected membership for %s to be %s but was %s", segmentRef, expectedMembership == null ? "null" : expectedMembership.toString(), actualMembership == null ? "null" : actualMembership.toString()));
            }
        }
    }

    protected abstract ComponentConfigurer<BigSegmentStore> makeStore(String var1);

    protected abstract void clearData(String var1);

    protected abstract void setMetadata(String var1, BigSegmentStoreTypes.StoreMetadata var2);

    protected abstract void setSegments(String var1, String var2, Iterable<String> var3, Iterable<String> var4);

    private static class Memberships {
        final Iterable<String> inclusions;
        final Iterable<String> exclusions;

        Memberships(Iterable<String> inclusions, Iterable<String> exclusions) {
            this.inclusions = inclusions == null ? Collections.emptyList() : inclusions;
            this.exclusions = exclusions == null ? Collections.emptyList() : exclusions;
        }
    }
}

