/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.sdk.server.integrations;

import com.launchdarkly.sdk.server.integrations.BigSegmentStoreTestBase;
import com.launchdarkly.sdk.server.subsystems.BigSegmentStore;
import com.launchdarkly.sdk.server.subsystems.BigSegmentStoreTypes;
import com.launchdarkly.sdk.server.subsystems.ClientContext;
import com.launchdarkly.sdk.server.subsystems.ComponentConfigurer;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class BigSegmentStoreTestBaseTest
extends BigSegmentStoreTestBase {
    private final Map<String, DataSet> allData = new HashMap<String, DataSet>();

    private DataSet getOrCreateDataSet(String prefix) {
        this.allData.putIfAbsent(prefix, new DataSet());
        return this.allData.get(prefix);
    }

    @Override
    protected ComponentConfigurer<BigSegmentStore> makeStore(String prefix) {
        return new MockStoreFactory(this.getOrCreateDataSet(prefix));
    }

    @Override
    protected void clearData(String prefix) {
        DataSet dataSet = this.getOrCreateDataSet(prefix);
        dataSet.metadata = null;
        dataSet.memberships.clear();
    }

    @Override
    protected void setMetadata(String prefix, BigSegmentStoreTypes.StoreMetadata metadata) {
        DataSet dataSet = this.getOrCreateDataSet(prefix);
        dataSet.metadata = metadata;
    }

    @Override
    protected void setSegments(String prefix, String userHashKey, Iterable<String> includedSegmentRefs, Iterable<String> excludedSegmentRefs) {
        DataSet dataSet = this.getOrCreateDataSet(prefix);
        dataSet.memberships.put(userHashKey, BigSegmentStoreTypes.createMembershipFromSegmentRefs(includedSegmentRefs, excludedSegmentRefs));
    }

    private static final class MockStore
    implements BigSegmentStore {
        private final DataSet data;

        private MockStore(DataSet data) {
            this.data = data;
        }

        public BigSegmentStoreTypes.Membership getMembership(String userHash) {
            return this.data.memberships.get(userHash);
        }

        public BigSegmentStoreTypes.StoreMetadata getMetadata() {
            return this.data.metadata;
        }

        public void close() throws IOException {
        }
    }

    private static final class MockStoreFactory
    implements ComponentConfigurer<BigSegmentStore> {
        private final DataSet data;

        private MockStoreFactory(DataSet data) {
            this.data = data;
        }

        public BigSegmentStore build(ClientContext context) {
            return new MockStore(this.data);
        }
    }

    private static class DataSet {
        BigSegmentStoreTypes.StoreMetadata metadata = null;
        Map<String, BigSegmentStoreTypes.Membership> memberships = new HashMap<String, BigSegmentStoreTypes.Membership>();

        private DataSet() {
        }
    }
}

