/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.sdk.server.integrations;

import com.launchdarkly.sdk.server.Components;
import com.launchdarkly.sdk.server.LDConfig;
import com.launchdarkly.sdk.server.TestComponents;
import com.launchdarkly.sdk.server.TestUtil;
import com.launchdarkly.sdk.server.integrations.BigSegmentsConfigurationBuilder;
import com.launchdarkly.sdk.server.interfaces.BigSegmentsConfiguration;
import com.launchdarkly.sdk.server.subsystems.BigSegmentStore;
import com.launchdarkly.sdk.server.subsystems.ClientContext;
import com.launchdarkly.sdk.server.subsystems.ComponentConfigurer;
import java.time.Duration;
import org.easymock.EasyMock;
import org.easymock.IMocksControl;
import org.junit.Assert;
import org.junit.Test;

public class BigSegmentsConfigurationBuilderTest {
    private final TestUtil.BuilderTestUtil<BigSegmentsConfigurationBuilder, BigSegmentsConfiguration> tester = new TestUtil.BuilderTestUtil<BigSegmentsConfigurationBuilder, BigSegmentsConfiguration>(() -> Components.bigSegments(null), b -> b.build(null));

    @Test
    public void storeFactory() {
        IMocksControl ctrl = EasyMock.createStrictControl();
        BigSegmentStore storeMock = (BigSegmentStore)ctrl.createMock(BigSegmentStore.class);
        ComponentConfigurer<BigSegmentStore> storeFactory = TestComponents.specificComponent(storeMock);
        BigSegmentsConfigurationBuilder b = Components.bigSegments(storeFactory);
        BigSegmentsConfiguration c = b.build((ClientContext)TestComponents.clientContext("", new LDConfig.Builder().build()));
        Assert.assertSame((Object)storeMock, (Object)c.getStore());
    }

    @Test
    public void userCacheSize() {
        TestUtil.BuilderPropertyTester<Integer> prop = this.tester.property(BigSegmentsConfiguration::getUserCacheSize, BigSegmentsConfigurationBuilder::userCacheSize);
        prop.assertDefault(1000);
        prop.assertCanSet(500);
        prop.assertCanSet(0);
        prop.assertSetIsChangedTo(-1, 0);
    }

    @Test
    public void userCacheTime() {
        TestUtil.BuilderPropertyTester<Duration> prop = this.tester.property(BigSegmentsConfiguration::getUserCacheTime, BigSegmentsConfigurationBuilder::userCacheTime);
        prop.assertDefault(BigSegmentsConfigurationBuilder.DEFAULT_USER_CACHE_TIME);
        prop.assertCanSet(Duration.ofSeconds(10L));
        prop.assertSetIsChangedTo(null, BigSegmentsConfigurationBuilder.DEFAULT_USER_CACHE_TIME);
        prop.assertSetIsChangedTo(Duration.ofSeconds(-1L), BigSegmentsConfigurationBuilder.DEFAULT_USER_CACHE_TIME);
    }

    @Test
    public void statusPollInterval() {
        TestUtil.BuilderPropertyTester<Duration> prop = this.tester.property(BigSegmentsConfiguration::getStatusPollInterval, BigSegmentsConfigurationBuilder::statusPollInterval);
        prop.assertDefault(BigSegmentsConfigurationBuilder.DEFAULT_STATUS_POLL_INTERVAL);
        prop.assertCanSet(Duration.ofSeconds(10L));
        prop.assertSetIsChangedTo(null, BigSegmentsConfigurationBuilder.DEFAULT_STATUS_POLL_INTERVAL);
        prop.assertSetIsChangedTo(Duration.ofSeconds(-1L), BigSegmentsConfigurationBuilder.DEFAULT_STATUS_POLL_INTERVAL);
    }

    @Test
    public void staleAfter() {
        TestUtil.BuilderPropertyTester<Duration> prop = this.tester.property(BigSegmentsConfiguration::getStaleAfter, BigSegmentsConfigurationBuilder::staleAfter);
        prop.assertDefault(BigSegmentsConfigurationBuilder.DEFAULT_STALE_AFTER);
        prop.assertCanSet(Duration.ofSeconds(10L));
        prop.assertSetIsChangedTo(null, BigSegmentsConfigurationBuilder.DEFAULT_STALE_AFTER);
        prop.assertSetIsChangedTo(Duration.ofSeconds(-1L), BigSegmentsConfigurationBuilder.DEFAULT_STALE_AFTER);
    }
}

