/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.sdk.server.integrations;

import com.google.common.collect.ImmutableSet;
import com.launchdarkly.sdk.AttributeRef;
import com.launchdarkly.sdk.server.Components;
import com.launchdarkly.sdk.server.integrations.EventProcessorBuilder;
import com.launchdarkly.sdk.server.subsystems.ComponentConfigurer;
import java.time.Duration;
import org.junit.Assert;
import org.junit.Test;

public class EventProcessorBuilderTest {
    @Test
    public void allAttributesPrivate() {
        Assert.assertEquals((Object)false, (Object)Components.sendEvents().allAttributesPrivate);
        Assert.assertEquals((Object)true, (Object)Components.sendEvents().allAttributesPrivate((boolean)true).allAttributesPrivate);
        Assert.assertEquals((Object)false, (Object)Components.sendEvents().allAttributesPrivate((boolean)true).allAttributesPrivate((boolean)false).allAttributesPrivate);
    }

    @Test
    public void capacity() {
        Assert.assertEquals((long)10000L, (long)Components.sendEvents().capacity);
        Assert.assertEquals((long)200L, (long)Components.sendEvents().capacity((int)200).capacity);
    }

    @Test
    public void diagnosticRecordingInterval() {
        EventProcessorBuilder builder1 = Components.sendEvents();
        Assert.assertEquals((Object)EventProcessorBuilder.DEFAULT_DIAGNOSTIC_RECORDING_INTERVAL, (Object)builder1.diagnosticRecordingInterval);
        EventProcessorBuilder builder2 = Components.sendEvents().diagnosticRecordingInterval(Duration.ofSeconds(120L));
        Assert.assertEquals((Object)Duration.ofSeconds(120L), (Object)builder2.diagnosticRecordingInterval);
        EventProcessorBuilder builder3 = Components.sendEvents().diagnosticRecordingInterval(Duration.ofSeconds(120L)).diagnosticRecordingInterval(null);
        Assert.assertEquals((Object)EventProcessorBuilder.DEFAULT_DIAGNOSTIC_RECORDING_INTERVAL, (Object)builder3.diagnosticRecordingInterval);
        EventProcessorBuilder builder4 = Components.sendEvents().diagnosticRecordingInterval(Duration.ofSeconds(10L));
        Assert.assertEquals((Object)EventProcessorBuilder.MIN_DIAGNOSTIC_RECORDING_INTERVAL, (Object)builder4.diagnosticRecordingInterval);
    }

    @Test
    public void eventSender() {
        Assert.assertNull((Object)Components.sendEvents().eventSenderConfigurer);
        ComponentConfigurer f = ctx -> null;
        Assert.assertSame((Object)f, (Object)Components.sendEvents().eventSender((ComponentConfigurer)f).eventSenderConfigurer);
        Assert.assertNull((Object)Components.sendEvents().eventSender((ComponentConfigurer)f).eventSender(null).eventSenderConfigurer);
    }

    @Test
    public void flushInterval() {
        EventProcessorBuilder builder1 = Components.sendEvents();
        Assert.assertEquals((Object)EventProcessorBuilder.DEFAULT_FLUSH_INTERVAL, (Object)builder1.flushInterval);
        EventProcessorBuilder builder2 = Components.sendEvents().flushInterval(Duration.ofSeconds(120L));
        Assert.assertEquals((Object)Duration.ofSeconds(120L), (Object)builder2.flushInterval);
        EventProcessorBuilder builder3 = Components.sendEvents().flushInterval(Duration.ofSeconds(120L)).flushInterval(null);
        Assert.assertEquals((Object)EventProcessorBuilder.DEFAULT_FLUSH_INTERVAL, (Object)builder3.flushInterval);
    }

    @Test
    public void privateAttributes() {
        Assert.assertNull((Object)Components.sendEvents().privateAttributes);
        Assert.assertEquals((Object)ImmutableSet.of((Object)AttributeRef.fromLiteral((String)"email"), (Object)AttributeRef.fromPath((String)"/address/street")), (Object)Components.sendEvents().privateAttributes((String[])new String[]{"email", "/address/street"}).privateAttributes);
    }

    @Test
    public void userKeysCapacity() {
        Assert.assertEquals((long)1000L, (long)Components.sendEvents().userKeysCapacity);
        Assert.assertEquals((long)44L, (long)Components.sendEvents().userKeysCapacity((int)44).userKeysCapacity);
    }

    @Test
    public void usrKeysFlushInterval() {
        EventProcessorBuilder builder1 = Components.sendEvents();
        Assert.assertEquals((Object)EventProcessorBuilder.DEFAULT_USER_KEYS_FLUSH_INTERVAL, (Object)builder1.userKeysFlushInterval);
        EventProcessorBuilder builder2 = Components.sendEvents().userKeysFlushInterval(Duration.ofSeconds(120L));
        Assert.assertEquals((Object)Duration.ofSeconds(120L), (Object)builder2.userKeysFlushInterval);
        EventProcessorBuilder builder3 = Components.sendEvents().userKeysFlushInterval(Duration.ofSeconds(120L)).userKeysFlushInterval(null);
        Assert.assertEquals((Object)EventProcessorBuilder.DEFAULT_USER_KEYS_FLUSH_INTERVAL, (Object)builder3.userKeysFlushInterval);
    }
}

