/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.sdk.server.integrations;

import com.launchdarkly.sdk.server.BaseTest;
import com.launchdarkly.sdk.server.DataModel;
import com.launchdarkly.sdk.server.DataStoreTestTypes;
import com.launchdarkly.sdk.server.LDConfig;
import com.launchdarkly.sdk.server.TestComponents;
import com.launchdarkly.sdk.server.TestUtil;
import com.launchdarkly.sdk.server.integrations.FileData;
import com.launchdarkly.sdk.server.integrations.FileDataSourceBuilder;
import com.launchdarkly.sdk.server.integrations.FileDataSourceTestData;
import com.launchdarkly.sdk.server.interfaces.DataSourceStatusProvider;
import com.launchdarkly.sdk.server.subsystems.ClientContext;
import com.launchdarkly.sdk.server.subsystems.DataSource;
import com.launchdarkly.sdk.server.subsystems.DataStore;
import com.launchdarkly.testhelpers.Assertions;
import com.launchdarkly.testhelpers.TempDir;
import com.launchdarkly.testhelpers.TempFile;
import java.nio.file.Path;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;

public class FileDataSourceAutoUpdateTest
extends BaseTest {
    private final DataStore store;
    private TestComponents.MockDataSourceUpdates dataSourceUpdates;
    private final LDConfig config = this.baseConfig().build();

    public FileDataSourceAutoUpdateTest() throws Exception {
        this.store = TestComponents.inMemoryDataStore();
        this.dataSourceUpdates = TestComponents.dataSourceUpdates(this.store);
    }

    private static FileDataSourceBuilder makeFactoryWithFile(Path path) {
        return FileData.dataSource().filePaths(new Path[]{path});
    }

    private DataSource makeDataSource(FileDataSourceBuilder builder) {
        return builder.build((ClientContext)TestComponents.clientContext("", this.config, this.dataSourceUpdates));
    }

    @Test
    public void modifiedFileIsNotReloadedIfAutoUpdateIsOff() throws Exception {
        try (TempDir dir = TempDir.create();
             TempFile file = dir.tempFile(".json");){
            file.setContents(FileDataSourceTestData.getResourceContents("flag-only.json"));
            FileDataSourceBuilder factory1 = FileDataSourceAutoUpdateTest.makeFactoryWithFile(file.getPath());
            try (DataSource fp = this.makeDataSource(factory1);){
                fp.start();
                file.setContents(FileDataSourceTestData.getResourceContents("segment-only.json"));
                Thread.sleep(400L);
                MatcherAssert.assertThat((Object)DataStoreTestTypes.toItemsMap(this.store.getAll(DataModel.FEATURES)).size(), (Matcher)Matchers.equalTo((Object)1));
                MatcherAssert.assertThat((Object)DataStoreTestTypes.toItemsMap(this.store.getAll(DataModel.SEGMENTS)).size(), (Matcher)Matchers.equalTo((Object)0));
            }
        }
    }

    @Test
    public void modifiedFileIsReloadedIfAutoUpdateIsOn() throws Exception {
        try (TempDir dir = TempDir.create();
             TempFile file = dir.tempFile(".json");){
            FileDataSourceBuilder factory1 = FileDataSourceAutoUpdateTest.makeFactoryWithFile(file.getPath()).autoUpdate(true);
            file.setContents(FileDataSourceTestData.getResourceContents("flag-only.json"));
            try (DataSource fp = this.makeDataSource(factory1);){
                fp.start();
                Thread.sleep(1000L);
                file.setContents(FileDataSourceTestData.getResourceContents("all-properties.json"));
                Assertions.assertPolledFunctionReturnsValue((long)10L, (TimeUnit)TimeUnit.SECONDS, (long)500L, (TimeUnit)TimeUnit.MILLISECONDS, () -> {
                    if (DataStoreTestTypes.toItemsMap(this.store.getAll(DataModel.FEATURES)).size() == FileDataSourceTestData.ALL_FLAG_KEYS.size()) {
                        return fp;
                    }
                    return null;
                });
            }
        }
    }

    @Test
    public void ifFilesAreBadAtStartTimeAutoUpdateCanStillLoadGoodDataLater() throws Exception {
        LinkedBlockingQueue statuses = new LinkedBlockingQueue();
        this.dataSourceUpdates.register(statuses::add);
        try (TempDir dir = TempDir.create();
             TempFile file = dir.tempFile(".json");){
            file.setContents("not valid");
            FileDataSourceBuilder factory1 = FileDataSourceAutoUpdateTest.makeFactoryWithFile(file.getPath()).autoUpdate(true);
            try (DataSource fp = this.makeDataSource(factory1);){
                fp.start();
                Thread.sleep(1000L);
                file.setContents(FileDataSourceTestData.getResourceContents("flag-only.json"));
                Assertions.assertPolledFunctionReturnsValue((long)10L, (TimeUnit)TimeUnit.SECONDS, (long)500L, (TimeUnit)TimeUnit.MILLISECONDS, () -> {
                    if (DataStoreTestTypes.toItemsMap(this.store.getAll(DataModel.FEATURES)).size() > 0) {
                        DataSourceStatusProvider.Status status = TestUtil.requireDataSourceStatusEventually(statuses, DataSourceStatusProvider.State.VALID, DataSourceStatusProvider.State.INITIALIZING);
                        Assert.assertNotNull((Object)status.getLastError());
                        Assert.assertEquals((Object)DataSourceStatusProvider.ErrorKind.INVALID_DATA, (Object)status.getLastError().getKind());
                        return status;
                    }
                    return null;
                });
            }
        }
    }

    @Test
    public void autoUpdateDoesNothingForClasspathResource() throws Exception {
        FileDataSourceBuilder factory = FileData.dataSource().classpathResources(new String[]{FileDataSourceTestData.resourceLocation("all-properties.json")}).autoUpdate(true);
        try (DataSource fp = this.makeDataSource(factory);){
            fp.start();
            Assert.assertTrue((boolean)fp.isInitialized());
        }
    }
}

