/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.sdk.server.integrations;

import com.launchdarkly.sdk.server.integrations.FileDataSourceParsing;
import com.launchdarkly.sdk.server.integrations.FileDataSourceTestData;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.net.URISyntaxException;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;

public abstract class FlagFileParserTestBase {
    private final FileDataSourceParsing.FlagFileParser parser;
    private final String fileExtension;

    protected FlagFileParserTestBase(FileDataSourceParsing.FlagFileParser parser, String fileExtension) {
        this.parser = parser;
        this.fileExtension = fileExtension;
    }

    @Test
    public void canParseFileWithAllProperties() throws Exception {
        try (FileInputStream input = this.openFile("all-properties");){
            FileDataSourceParsing.FlagFileRep data = this.parser.parse((InputStream)input);
            MatcherAssert.assertThat((Object)data.flags, (Matcher)Matchers.equalTo(FileDataSourceTestData.FULL_FLAGS));
            MatcherAssert.assertThat((Object)data.flagValues, (Matcher)Matchers.equalTo(FileDataSourceTestData.FLAG_VALUES));
            MatcherAssert.assertThat((Object)data.segments, (Matcher)Matchers.equalTo(FileDataSourceTestData.FULL_SEGMENTS));
        }
    }

    @Test
    public void canParseFileWithOnlyFullFlag() throws Exception {
        try (FileInputStream input = this.openFile("flag-only");){
            FileDataSourceParsing.FlagFileRep data = this.parser.parse((InputStream)input);
            MatcherAssert.assertThat((Object)data.flags, (Matcher)Matchers.equalTo(FileDataSourceTestData.FULL_FLAGS));
            MatcherAssert.assertThat((Object)data.flagValues, (Matcher)Matchers.nullValue());
            MatcherAssert.assertThat((Object)data.segments, (Matcher)Matchers.nullValue());
        }
    }

    @Test
    public void canParseFileWithOnlyFlagValue() throws Exception {
        try (FileInputStream input = this.openFile("value-only");){
            FileDataSourceParsing.FlagFileRep data = this.parser.parse((InputStream)input);
            MatcherAssert.assertThat((Object)data.flags, (Matcher)Matchers.nullValue());
            MatcherAssert.assertThat((Object)data.flagValues, (Matcher)Matchers.equalTo(FileDataSourceTestData.FLAG_VALUES));
            MatcherAssert.assertThat((Object)data.segments, (Matcher)Matchers.nullValue());
        }
    }

    @Test
    public void canParseFileWithOnlySegment() throws Exception {
        try (FileInputStream input = this.openFile("segment-only");){
            FileDataSourceParsing.FlagFileRep data = this.parser.parse((InputStream)input);
            MatcherAssert.assertThat((Object)data.flags, (Matcher)Matchers.nullValue());
            MatcherAssert.assertThat((Object)data.flagValues, (Matcher)Matchers.nullValue());
            MatcherAssert.assertThat((Object)data.segments, (Matcher)Matchers.equalTo(FileDataSourceTestData.FULL_SEGMENTS));
        }
    }

    @Test
    public void throwsExpectedErrorForBadFile() throws Exception {
        try (FileInputStream input = this.openFile("malformed");){
            try {
                this.parser.parse((InputStream)input);
                Assert.fail((String)"expected exception");
            }
            catch (FileDataSourceParsing.FileDataException e) {
                MatcherAssert.assertThat((Object)e.getDescription(), (Matcher)Matchers.not((Matcher)Matchers.nullValue()));
            }
        }
    }

    private FileInputStream openFile(String name) throws URISyntaxException, FileNotFoundException {
        return new FileInputStream(FileDataSourceTestData.resourceFilePath(name + this.fileExtension).toFile());
    }
}

