/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.sdk.server.integrations;

import com.launchdarkly.sdk.server.Components;
import com.launchdarkly.sdk.server.interfaces.ServiceEndpoints;
import java.net.URI;
import org.junit.Assert;
import org.junit.Test;

public class ServiceEndpointsBuilderTest {
    @Test
    public void usesAllDefaultUrisIfNoneAreOverridden() {
        ServiceEndpoints se = Components.serviceEndpoints().createServiceEndpoints();
        Assert.assertEquals((Object)URI.create("https://stream.launchdarkly.com"), (Object)se.getStreamingBaseUri());
        Assert.assertEquals((Object)URI.create("https://app.launchdarkly.com"), (Object)se.getPollingBaseUri());
        Assert.assertEquals((Object)URI.create("https://events.launchdarkly.com"), (Object)se.getEventsBaseUri());
    }

    @Test
    public void canSetAllUrisToCustomValues() {
        URI su = URI.create("https://my-streaming");
        URI pu = URI.create("https://my-polling");
        URI eu = URI.create("https://my-events");
        ServiceEndpoints se = Components.serviceEndpoints().streaming(su).polling(pu).events(eu).createServiceEndpoints();
        Assert.assertEquals((Object)su, (Object)se.getStreamingBaseUri());
        Assert.assertEquals((Object)pu, (Object)se.getPollingBaseUri());
        Assert.assertEquals((Object)eu, (Object)se.getEventsBaseUri());
    }

    @Test
    public void ifCustomUrisAreSetAnyUnsetOnesDefaultToNull() {
        URI su = URI.create("https://my-streaming");
        URI pu = URI.create("https://my-polling");
        URI eu = URI.create("https://my-events");
        ServiceEndpoints se1 = Components.serviceEndpoints().streaming(su).createServiceEndpoints();
        Assert.assertEquals((Object)su, (Object)se1.getStreamingBaseUri());
        Assert.assertNull((Object)se1.getPollingBaseUri());
        Assert.assertNull((Object)se1.getEventsBaseUri());
        ServiceEndpoints se2 = Components.serviceEndpoints().polling(pu).createServiceEndpoints();
        Assert.assertNull((Object)se2.getStreamingBaseUri());
        Assert.assertEquals((Object)pu, (Object)se2.getPollingBaseUri());
        Assert.assertNull((Object)se2.getEventsBaseUri());
        ServiceEndpoints se3 = Components.serviceEndpoints().events(eu).createServiceEndpoints();
        Assert.assertNull((Object)se3.getStreamingBaseUri());
        Assert.assertNull((Object)se3.getPollingBaseUri());
        Assert.assertEquals((Object)eu, (Object)se3.getEventsBaseUri());
    }

    @Test
    public void settingRelayProxyUriSetsAllUris() {
        URI customRelay = URI.create("http://my-relay");
        ServiceEndpoints se = Components.serviceEndpoints().relayProxy(customRelay).createServiceEndpoints();
        Assert.assertEquals((Object)customRelay, (Object)se.getStreamingBaseUri());
        Assert.assertEquals((Object)customRelay, (Object)se.getPollingBaseUri());
        Assert.assertEquals((Object)customRelay, (Object)se.getEventsBaseUri());
    }

    @Test
    public void stringSettersAreEquivalentToUriSetters() {
        String su = "https://my-streaming";
        String pu = "https://my-polling";
        String eu = "https://my-events";
        ServiceEndpoints se1 = Components.serviceEndpoints().streaming(su).polling(pu).events(eu).createServiceEndpoints();
        Assert.assertEquals((Object)URI.create(su), (Object)se1.getStreamingBaseUri());
        Assert.assertEquals((Object)URI.create(pu), (Object)se1.getPollingBaseUri());
        Assert.assertEquals((Object)URI.create(eu), (Object)se1.getEventsBaseUri());
        String ru = "http://my-relay";
        ServiceEndpoints se2 = Components.serviceEndpoints().relayProxy(ru).createServiceEndpoints();
        Assert.assertEquals((Object)URI.create(ru), (Object)se2.getStreamingBaseUri());
        Assert.assertEquals((Object)URI.create(ru), (Object)se2.getPollingBaseUri());
        Assert.assertEquals((Object)URI.create(ru), (Object)se2.getEventsBaseUri());
    }
}

