/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.sdk.server.integrations;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.launchdarkly.sdk.ContextKind;
import com.launchdarkly.sdk.LDValue;
import com.launchdarkly.sdk.server.DataModel;
import com.launchdarkly.sdk.server.LDConfig;
import com.launchdarkly.sdk.server.ModelBuilders;
import com.launchdarkly.sdk.server.TestComponents;
import com.launchdarkly.sdk.server.integrations.TestData;
import com.launchdarkly.sdk.server.interfaces.DataSourceStatusProvider;
import com.launchdarkly.sdk.server.interfaces.DataStoreStatusProvider;
import com.launchdarkly.sdk.server.subsystems.ClientContext;
import com.launchdarkly.sdk.server.subsystems.DataSource;
import com.launchdarkly.sdk.server.subsystems.DataSourceUpdateSink;
import com.launchdarkly.sdk.server.subsystems.DataStoreTypes;
import com.launchdarkly.testhelpers.JsonAssertions;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.function.Function;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Test;

public class TestDataTest {
    private static final LDValue[] THREE_STRING_VALUES = new LDValue[]{LDValue.of((String)"red"), LDValue.of((String)"green"), LDValue.of((String)"blue")};
    private CapturingDataSourceUpdates updates = new CapturingDataSourceUpdates();

    @Test
    public void initializesWithEmptyData() throws Exception {
        TestData td = TestData.dataSource();
        DataSource ds = td.build((ClientContext)TestComponents.clientContext("", new LDConfig.Builder().build(), this.updates));
        Future started = ds.start();
        MatcherAssert.assertThat((Object)started.isDone(), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)this.updates.valid, (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)this.updates.inits.size(), (Matcher)Matchers.equalTo((Object)1));
        DataStoreTypes.FullDataSet<DataStoreTypes.ItemDescriptor> data = this.updates.inits.take();
        MatcherAssert.assertThat((Object)data.getData(), (Matcher)Matchers.iterableWithSize((int)1));
        MatcherAssert.assertThat((Object)((DataStoreTypes.DataKind)((Map.Entry)Iterables.get((Iterable)data.getData(), (int)0)).getKey()), (Matcher)Matchers.equalTo((Object)DataModel.FEATURES));
        MatcherAssert.assertThat((Object)((DataStoreTypes.KeyedItems)((Map.Entry)Iterables.get((Iterable)data.getData(), (int)0)).getValue()).getItems(), (Matcher)Matchers.emptyIterable());
    }

    @Test
    public void initializesWithFlags() throws Exception {
        TestData td = TestData.dataSource();
        td.update(td.flag("flag1").on(true)).update(td.flag("flag2").on(false));
        DataSource ds = td.build((ClientContext)TestComponents.clientContext("", new LDConfig.Builder().build(), this.updates));
        Future started = ds.start();
        MatcherAssert.assertThat((Object)started.isDone(), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)this.updates.valid, (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)this.updates.inits.size(), (Matcher)Matchers.equalTo((Object)1));
        DataStoreTypes.FullDataSet<DataStoreTypes.ItemDescriptor> data = this.updates.inits.take();
        MatcherAssert.assertThat((Object)data.getData(), (Matcher)Matchers.iterableWithSize((int)1));
        MatcherAssert.assertThat((Object)((DataStoreTypes.DataKind)((Map.Entry)Iterables.get((Iterable)data.getData(), (int)0)).getKey()), (Matcher)Matchers.equalTo((Object)DataModel.FEATURES));
        MatcherAssert.assertThat((Object)((DataStoreTypes.KeyedItems)((Map.Entry)Iterables.get((Iterable)data.getData(), (int)0)).getValue()).getItems(), (Matcher)Matchers.iterableWithSize((int)2));
        ModelBuilders.FlagBuilder expectedFlag1 = ModelBuilders.flagBuilder("flag1").version(1).salt("").on(true).offVariation(1).fallthroughVariation(0).variations(true, false);
        ModelBuilders.FlagBuilder expectedFlag2 = ModelBuilders.flagBuilder("flag2").version(1).salt("").on(false).offVariation(1).fallthroughVariation(0).variations(true, false);
        ImmutableMap flags = ImmutableMap.copyOf((Iterable)((DataStoreTypes.KeyedItems)((Map.Entry)Iterables.get((Iterable)data.getData(), (int)0)).getValue()).getItems());
        DataStoreTypes.ItemDescriptor flag1 = (DataStoreTypes.ItemDescriptor)flags.get("flag1");
        DataStoreTypes.ItemDescriptor flag2 = (DataStoreTypes.ItemDescriptor)flags.get("flag2");
        MatcherAssert.assertThat((Object)flag1, (Matcher)Matchers.not((Matcher)Matchers.nullValue()));
        MatcherAssert.assertThat((Object)flag2, (Matcher)Matchers.not((Matcher)Matchers.nullValue()));
        JsonAssertions.assertJsonEquals((String)TestDataTest.flagJson(expectedFlag1, 1), (String)TestDataTest.flagJson(flag1));
        JsonAssertions.assertJsonEquals((String)TestDataTest.flagJson(expectedFlag2, 1), (String)TestDataTest.flagJson(flag2));
    }

    @Test
    public void addsFlag() throws Exception {
        TestData td = TestData.dataSource();
        DataSource ds = td.build((ClientContext)TestComponents.clientContext("", new LDConfig.Builder().build(), this.updates));
        Future started = ds.start();
        MatcherAssert.assertThat((Object)started.isDone(), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)this.updates.valid, (Matcher)Matchers.is((Object)true));
        td.update(td.flag("flag1").on(true));
        ModelBuilders.FlagBuilder expectedFlag = ModelBuilders.flagBuilder("flag1").version(1).salt("").on(true).offVariation(1).fallthroughVariation(0).variations(true, false);
        MatcherAssert.assertThat((Object)this.updates.upserts.size(), (Matcher)Matchers.equalTo((Object)1));
        UpsertParams up = this.updates.upserts.take();
        MatcherAssert.assertThat((Object)up.kind, (Matcher)Matchers.is((Object)DataModel.FEATURES));
        MatcherAssert.assertThat((Object)up.key, (Matcher)Matchers.equalTo((Object)"flag1"));
        DataStoreTypes.ItemDescriptor flag1 = up.item;
        JsonAssertions.assertJsonEquals((String)TestDataTest.flagJson(expectedFlag, 2), (String)TestDataTest.flagJson(flag1));
    }

    @Test
    public void updatesFlag() throws Exception {
        TestData td = TestData.dataSource();
        td.update(td.flag("flag1").on(false).variationForUser("a", true).ifMatch("name", new LDValue[]{LDValue.of((String)"Lucy")}).thenReturn(true));
        ModelBuilders.FlagBuilder expectedFlag = ModelBuilders.flagBuilder("flag1").version(1).salt("").on(false).offVariation(1).fallthroughVariation(0).variations(true, false).addTarget(0, "a").addContextTarget(ContextKind.DEFAULT, 0, new String[0]).addRule("rule0", 0, "{\"contextKind\":\"user\",\"attribute\":\"name\",\"op\":\"in\",\"values\":[\"Lucy\"]}");
        DataSource ds = td.build((ClientContext)TestComponents.clientContext("", new LDConfig.Builder().build(), this.updates));
        Future started = ds.start();
        MatcherAssert.assertThat((Object)started.isDone(), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)this.updates.valid, (Matcher)Matchers.is((Object)true));
        td.update(td.flag("flag1").on(true));
        MatcherAssert.assertThat((Object)this.updates.upserts.size(), (Matcher)Matchers.equalTo((Object)1));
        UpsertParams up = this.updates.upserts.take();
        MatcherAssert.assertThat((Object)up.kind, (Matcher)Matchers.is((Object)DataModel.FEATURES));
        MatcherAssert.assertThat((Object)up.key, (Matcher)Matchers.equalTo((Object)"flag1"));
        DataStoreTypes.ItemDescriptor flag1 = up.item;
        expectedFlag.on(true).version(2);
        JsonAssertions.assertJsonEquals((String)TestDataTest.flagJson(expectedFlag, 2), (String)TestDataTest.flagJson(flag1));
    }

    @Test
    public void flagConfigSimpleBoolean() throws Exception {
        Function<ModelBuilders.FlagBuilder, ModelBuilders.FlagBuilder> expectedBooleanFlag = fb -> fb.on(true).variations(true, false).offVariation(1).fallthroughVariation(0);
        this.verifyFlag(f -> f, expectedBooleanFlag);
        this.verifyFlag(f -> f.booleanFlag(), expectedBooleanFlag);
        this.verifyFlag(f -> f.on(true), expectedBooleanFlag);
        this.verifyFlag(f -> f.on(false), fb -> ((ModelBuilders.FlagBuilder)expectedBooleanFlag.apply((ModelBuilders.FlagBuilder)fb)).on(false));
        this.verifyFlag(f -> f.variationForAll(false), fb -> ((ModelBuilders.FlagBuilder)expectedBooleanFlag.apply((ModelBuilders.FlagBuilder)fb)).fallthroughVariation(1));
        this.verifyFlag(f -> f.variationForAll(true), expectedBooleanFlag);
        this.verifyFlag(f -> f.fallthroughVariation(true).offVariation(false), expectedBooleanFlag);
        this.verifyFlag(f -> f.fallthroughVariation(false).offVariation(true), fb -> ((ModelBuilders.FlagBuilder)expectedBooleanFlag.apply((ModelBuilders.FlagBuilder)fb)).fallthroughVariation(1).offVariation(0));
    }

    @Test
    public void usingBooleanConfigMethodsForcesFlagToBeBoolean() throws Exception {
        Function<ModelBuilders.FlagBuilder, ModelBuilders.FlagBuilder> expectedBooleanFlag = fb -> fb.on(true).variations(true, false).offVariation(1).fallthroughVariation(0);
        this.verifyFlag(f -> f.variations(new LDValue[]{LDValue.of((int)1), LDValue.of((int)2)}).booleanFlag(), expectedBooleanFlag);
        this.verifyFlag(f -> f.variations(new LDValue[]{LDValue.of((boolean)true), LDValue.of((int)2)}).booleanFlag(), expectedBooleanFlag);
        this.verifyFlag(f -> f.booleanFlag(), expectedBooleanFlag);
    }

    @Test
    public void flagConfigStringVariations() throws Exception {
        this.verifyFlag(f -> f.variations(THREE_STRING_VALUES).offVariation(0).fallthroughVariation(2), fb -> fb.variations("red", "green", "blue").on(true).offVariation(0).fallthroughVariation(2));
    }

    @Test
    public void userTargets() throws Exception {
        Function<ModelBuilders.FlagBuilder, ModelBuilders.FlagBuilder> expectedBooleanFlag = fb -> fb.variations(true, false).on(true).offVariation(1).fallthroughVariation(0);
        this.verifyFlag(f -> f.variationForUser("a", true).variationForUser("b", true), fb -> ((ModelBuilders.FlagBuilder)expectedBooleanFlag.apply((ModelBuilders.FlagBuilder)fb)).addTarget(0, "a", "b").addContextTarget(ContextKind.DEFAULT, 0, new String[0]));
        this.verifyFlag(f -> f.variationForUser("a", true).variationForUser("a", true), fb -> ((ModelBuilders.FlagBuilder)expectedBooleanFlag.apply((ModelBuilders.FlagBuilder)fb)).addTarget(0, "a").addContextTarget(ContextKind.DEFAULT, 0, new String[0]));
        this.verifyFlag(f -> f.variationForUser("a", true).variationForUser("a", false), fb -> ((ModelBuilders.FlagBuilder)expectedBooleanFlag.apply((ModelBuilders.FlagBuilder)fb)).addTarget(1, "a").addContextTarget(ContextKind.DEFAULT, 1, new String[0]));
        this.verifyFlag(f -> f.variationForUser("a", false).variationForUser("b", true).variationForUser("c", false), fb -> ((ModelBuilders.FlagBuilder)expectedBooleanFlag.apply((ModelBuilders.FlagBuilder)fb)).addTarget(0, "b").addTarget(1, "a", "c").addContextTarget(ContextKind.DEFAULT, 0, new String[0]).addContextTarget(ContextKind.DEFAULT, 1, new String[0]));
        this.verifyFlag(f -> f.variationForUser("a", true).variationForUser("b", true).variationForUser("a", false), fb -> ((ModelBuilders.FlagBuilder)expectedBooleanFlag.apply((ModelBuilders.FlagBuilder)fb)).addTarget(0, "b").addTarget(1, "a").addContextTarget(ContextKind.DEFAULT, 0, new String[0]).addContextTarget(ContextKind.DEFAULT, 1, new String[0]));
        Function<ModelBuilders.FlagBuilder, ModelBuilders.FlagBuilder> expectedStringFlag = fb -> fb.variations("red", "green", "blue").on(true).offVariation(0).fallthroughVariation(2);
        this.verifyFlag(f -> f.variations(THREE_STRING_VALUES).offVariation(0).fallthroughVariation(2).variationForUser("a", 2).variationForUser("b", 2), fb -> ((ModelBuilders.FlagBuilder)expectedStringFlag.apply((ModelBuilders.FlagBuilder)fb)).addTarget(2, "a", "b").addContextTarget(ContextKind.DEFAULT, 2, new String[0]));
        this.verifyFlag(f -> f.variations(THREE_STRING_VALUES).offVariation(0).fallthroughVariation(2).variationForUser("a", 2).variationForUser("b", 1).variationForUser("c", 2), fb -> ((ModelBuilders.FlagBuilder)expectedStringFlag.apply((ModelBuilders.FlagBuilder)fb)).addTarget(1, "b").addTarget(2, "a", "c").addContextTarget(ContextKind.DEFAULT, 1, new String[0]).addContextTarget(ContextKind.DEFAULT, 2, new String[0]));
        this.verifyFlag(f -> f.variationForUser("a", true).clearTargets(), expectedBooleanFlag);
    }

    @Test
    public void contextTargets() throws Exception {
        ContextKind kind1 = ContextKind.of((String)"org");
        ContextKind kind2 = ContextKind.of((String)"other");
        Function<ModelBuilders.FlagBuilder, ModelBuilders.FlagBuilder> expectedBooleanFlag = fb -> fb.variations(true, false).on(true).offVariation(1).fallthroughVariation(0);
        this.verifyFlag(f -> f.variationForKey(kind1, "a", true).variationForKey(kind1, "b", true), fb -> ((ModelBuilders.FlagBuilder)expectedBooleanFlag.apply((ModelBuilders.FlagBuilder)fb)).addContextTarget(kind1, 0, "a", "b"));
        this.verifyFlag(f -> f.variationForKey(kind1, "a", true).variationForKey(kind2, "a", true), fb -> ((ModelBuilders.FlagBuilder)expectedBooleanFlag.apply((ModelBuilders.FlagBuilder)fb)).addContextTarget(kind1, 0, "a").addContextTarget(kind2, 0, "a"));
        this.verifyFlag(f -> f.variationForKey(kind1, "a", true).variationForKey(kind1, "a", true), fb -> ((ModelBuilders.FlagBuilder)expectedBooleanFlag.apply((ModelBuilders.FlagBuilder)fb)).addContextTarget(kind1, 0, "a"));
        this.verifyFlag(f -> f.variationForKey(kind1, "a", true).variationForKey(kind1, "a", false), fb -> ((ModelBuilders.FlagBuilder)expectedBooleanFlag.apply((ModelBuilders.FlagBuilder)fb)).addContextTarget(kind1, 1, "a"));
        Function<ModelBuilders.FlagBuilder, ModelBuilders.FlagBuilder> expectedStringFlag = fb -> fb.variations("red", "green", "blue").on(true).offVariation(0).fallthroughVariation(2);
        this.verifyFlag(f -> f.variations(THREE_STRING_VALUES).offVariation(0).fallthroughVariation(2).variationForKey(kind1, "a", 2).variationForKey(kind1, "b", 2), fb -> ((ModelBuilders.FlagBuilder)expectedStringFlag.apply((ModelBuilders.FlagBuilder)fb)).addContextTarget(kind1, 2, "a", "b"));
        this.verifyFlag(f -> f.variationForKey(kind1, "a", true).clearTargets(), expectedBooleanFlag);
    }

    @Test
    public void flagRules() throws Exception {
        Function<ModelBuilders.FlagBuilder, ModelBuilders.FlagBuilder> expectedBooleanFlag = fb -> fb.variations(true, false).on(true).offVariation(1).fallthroughVariation(0);
        Function<ModelBuilders.FlagBuilder, ModelBuilders.FlagBuilder> matchReturnsVariation0 = fb -> ((ModelBuilders.FlagBuilder)expectedBooleanFlag.apply((ModelBuilders.FlagBuilder)fb)).addRule("rule0", 0, "{\"contextKind\":\"user\",\"attribute\":\"name\",\"op\":\"in\",\"values\":[\"Lucy\"]}");
        this.verifyFlag(f -> f.ifMatch("name", new LDValue[]{LDValue.of((String)"Lucy")}).thenReturn(true), matchReturnsVariation0);
        this.verifyFlag(f -> f.ifMatch("name", new LDValue[]{LDValue.of((String)"Lucy")}).thenReturn(0), matchReturnsVariation0);
        Function<ModelBuilders.FlagBuilder, ModelBuilders.FlagBuilder> matchReturnsVariation1 = fb -> ((ModelBuilders.FlagBuilder)expectedBooleanFlag.apply((ModelBuilders.FlagBuilder)fb)).addRule("rule0", 1, "{\"contextKind\":\"user\",\"attribute\":\"name\",\"op\":\"in\",\"values\":[\"Lucy\"]}");
        this.verifyFlag(f -> f.ifMatch("name", new LDValue[]{LDValue.of((String)"Lucy")}).thenReturn(false), matchReturnsVariation1);
        this.verifyFlag(f -> f.ifMatch("name", new LDValue[]{LDValue.of((String)"Lucy")}).thenReturn(1), matchReturnsVariation1);
        this.verifyFlag(f -> f.ifNotMatch("name", new LDValue[]{LDValue.of((String)"Lucy")}).thenReturn(true), fb -> ((ModelBuilders.FlagBuilder)expectedBooleanFlag.apply((ModelBuilders.FlagBuilder)fb)).addRule("rule0", 0, "{\"contextKind\":\"user\",\"attribute\":\"name\",\"op\":\"in\",\"values\":[\"Lucy\"],\"negate\":true}"));
        this.verifyFlag(f -> f.ifMatch(ContextKind.of((String)"org"), "name", new LDValue[]{LDValue.of((String)"Catco")}).thenReturn(true), fb -> ((ModelBuilders.FlagBuilder)expectedBooleanFlag.apply((ModelBuilders.FlagBuilder)fb)).addRule("rule0", 0, "{\"contextKind\":\"org\",\"attribute\":\"name\",\"op\":\"in\",\"values\":[\"Catco\"]}"));
        this.verifyFlag(f -> f.ifNotMatch(ContextKind.of((String)"org"), "name", new LDValue[]{LDValue.of((String)"Catco")}).thenReturn(true), fb -> ((ModelBuilders.FlagBuilder)expectedBooleanFlag.apply((ModelBuilders.FlagBuilder)fb)).addRule("rule0", 0, "{\"contextKind\":\"org\",\"attribute\":\"name\",\"op\":\"in\",\"values\":[\"Catco\"],\"negate\":true}"));
        this.verifyFlag(f -> f.ifMatch("name", new LDValue[]{LDValue.of((String)"Lucy")}).andMatch("country", new LDValue[]{LDValue.of((String)"gb")}).thenReturn(true), fb -> ((ModelBuilders.FlagBuilder)expectedBooleanFlag.apply((ModelBuilders.FlagBuilder)fb)).addRule("rule0", 0, "{\"contextKind\":\"user\",\"attribute\":\"name\",\"op\":\"in\",\"values\":[\"Lucy\"]}", "{\"contextKind\":\"user\",\"attribute\":\"country\",\"op\":\"in\",\"values\":[\"gb\"]}"));
        this.verifyFlag(f -> f.ifMatch("name", new LDValue[]{LDValue.of((String)"Lucy")}).andMatch("country", new LDValue[]{LDValue.of((String)"gb")}).thenReturn(true), fb -> ((ModelBuilders.FlagBuilder)expectedBooleanFlag.apply((ModelBuilders.FlagBuilder)fb)).addRule("rule0", 0, "{\"contextKind\":\"user\",\"attribute\":\"name\",\"op\":\"in\",\"values\":[\"Lucy\"]}", "{\"contextKind\":\"user\",\"attribute\":\"country\",\"op\":\"in\",\"values\":[\"gb\"]}"));
        this.verifyFlag(f -> f.ifMatch("name", new LDValue[]{LDValue.of((String)"Lucy")}).thenReturn(true).ifMatch("name", new LDValue[]{LDValue.of((String)"Mina")}).thenReturn(false), fb -> ((ModelBuilders.FlagBuilder)expectedBooleanFlag.apply((ModelBuilders.FlagBuilder)fb)).addRule("rule0", 0, "{\"contextKind\":\"user\",\"attribute\":\"name\",\"op\":\"in\",\"values\":[\"Lucy\"]}").addRule("rule1", 1, "{\"contextKind\":\"user\",\"attribute\":\"name\",\"op\":\"in\",\"values\":[\"Mina\"]}"));
        this.verifyFlag(f -> f.ifMatch("name", new LDValue[]{LDValue.of((String)"Lucy")}).thenReturn(true).clearRules(), expectedBooleanFlag);
    }

    private void verifyFlag(Function<TestData.FlagBuilder, TestData.FlagBuilder> configureFlag, Function<ModelBuilders.FlagBuilder, ModelBuilders.FlagBuilder> configureExpectedFlag) throws Exception {
        ModelBuilders.FlagBuilder expectedFlag = ModelBuilders.flagBuilder("flagkey").version(1).salt("");
        expectedFlag = configureExpectedFlag.apply(expectedFlag);
        TestData td = TestData.dataSource();
        DataSource ds = td.build((ClientContext)TestComponents.clientContext("", new LDConfig.Builder().build(), this.updates));
        ds.start();
        td.update(configureFlag.apply(td.flag("flagkey")));
        MatcherAssert.assertThat((Object)this.updates.upserts.size(), (Matcher)Matchers.equalTo((Object)1));
        UpsertParams up = this.updates.upserts.take();
        DataStoreTypes.ItemDescriptor flag = up.item;
        JsonAssertions.assertJsonEquals((String)TestDataTest.flagJson(expectedFlag, 1), (String)TestDataTest.flagJson(flag));
    }

    private static String flagJson(ModelBuilders.FlagBuilder flagBuilder, int version) {
        return DataModel.FEATURES.serialize(new DataStoreTypes.ItemDescriptor(version, (Object)flagBuilder.build()));
    }

    private static String flagJson(DataStoreTypes.ItemDescriptor flag) {
        return DataModel.FEATURES.serialize(flag);
    }

    private static class CapturingDataSourceUpdates
    implements DataSourceUpdateSink {
        BlockingQueue<DataStoreTypes.FullDataSet<DataStoreTypes.ItemDescriptor>> inits = new LinkedBlockingQueue<DataStoreTypes.FullDataSet<DataStoreTypes.ItemDescriptor>>();
        BlockingQueue<UpsertParams> upserts = new LinkedBlockingQueue<UpsertParams>();
        boolean valid;

        private CapturingDataSourceUpdates() {
        }

        public boolean init(DataStoreTypes.FullDataSet<DataStoreTypes.ItemDescriptor> allData) {
            this.inits.add(allData);
            return true;
        }

        public boolean upsert(DataStoreTypes.DataKind kind, String key, DataStoreTypes.ItemDescriptor item) {
            this.upserts.add(new UpsertParams(kind, key, item));
            return true;
        }

        public DataStoreStatusProvider getDataStoreStatusProvider() {
            return null;
        }

        public void updateStatus(DataSourceStatusProvider.State newState, DataSourceStatusProvider.ErrorInfo newError) {
            this.valid = newState == DataSourceStatusProvider.State.VALID;
        }
    }

    private static class UpsertParams {
        final DataStoreTypes.DataKind kind;
        final String key;
        final DataStoreTypes.ItemDescriptor item;

        UpsertParams(DataStoreTypes.DataKind kind, String key, DataStoreTypes.ItemDescriptor item) {
            this.kind = kind;
            this.key = key;
            this.item = item;
        }
    }
}

