/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.sdk.server.interfaces;

import com.launchdarkly.sdk.server.interfaces.DataStoreStatusProvider;
import com.launchdarkly.testhelpers.TypeBehavior;
import java.util.ArrayList;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Test;

public class DataStoreStatusProviderTypesTest {
    @Test
    public void statusProperties() {
        DataStoreStatusProvider.Status s1 = new DataStoreStatusProvider.Status(true, false);
        MatcherAssert.assertThat((Object)s1.isAvailable(), (Matcher)Matchers.equalTo((Object)true));
        MatcherAssert.assertThat((Object)s1.isRefreshNeeded(), (Matcher)Matchers.equalTo((Object)false));
        DataStoreStatusProvider.Status s2 = new DataStoreStatusProvider.Status(false, true);
        MatcherAssert.assertThat((Object)s2.isAvailable(), (Matcher)Matchers.equalTo((Object)false));
        MatcherAssert.assertThat((Object)s2.isRefreshNeeded(), (Matcher)Matchers.equalTo((Object)true));
    }

    @Test
    public void statusEquality() {
        ArrayList<TypeBehavior.ValueFactory> allPermutations = new ArrayList<TypeBehavior.ValueFactory>();
        allPermutations.add(() -> new DataStoreStatusProvider.Status(false, false));
        allPermutations.add(() -> new DataStoreStatusProvider.Status(false, true));
        allPermutations.add(() -> new DataStoreStatusProvider.Status(true, false));
        allPermutations.add(() -> new DataStoreStatusProvider.Status(true, true));
        TypeBehavior.checkEqualsAndHashCode(allPermutations);
    }

    @Test
    public void statusStringRepresentation() {
        MatcherAssert.assertThat((Object)new DataStoreStatusProvider.Status(true, false).toString(), (Matcher)Matchers.equalTo((Object)"Status(true,false)"));
    }

    @Test
    public void cacheStatsProperties() {
        DataStoreStatusProvider.CacheStats stats = new DataStoreStatusProvider.CacheStats(1L, 2L, 3L, 4L, 5L, 6L);
        MatcherAssert.assertThat((Object)stats.getHitCount(), (Matcher)Matchers.equalTo((Object)1L));
        MatcherAssert.assertThat((Object)stats.getMissCount(), (Matcher)Matchers.equalTo((Object)2L));
        MatcherAssert.assertThat((Object)stats.getLoadSuccessCount(), (Matcher)Matchers.equalTo((Object)3L));
        MatcherAssert.assertThat((Object)stats.getLoadExceptionCount(), (Matcher)Matchers.equalTo((Object)4L));
        MatcherAssert.assertThat((Object)stats.getTotalLoadTime(), (Matcher)Matchers.equalTo((Object)5L));
        MatcherAssert.assertThat((Object)stats.getEvictionCount(), (Matcher)Matchers.equalTo((Object)6L));
    }

    @Test
    public void cacheStatsEquality() {
        int[] values;
        ArrayList<TypeBehavior.ValueFactory> allPermutations = new ArrayList<TypeBehavior.ValueFactory>();
        for (int hit : values = new int[]{0, 1, 2}) {
            for (int miss : values) {
                for (int loadSuccess : values) {
                    for (int loadException : values) {
                        for (int totalLoad : values) {
                            for (int eviction : values) {
                                allPermutations.add(() -> new DataStoreStatusProvider.CacheStats((long)hit, (long)miss, (long)loadSuccess, (long)loadException, (long)totalLoad, (long)eviction));
                            }
                        }
                    }
                }
            }
        }
        TypeBehavior.checkEqualsAndHashCode(allPermutations);
    }

    @Test
    public void cacheStatsStringRepresentation() {
        DataStoreStatusProvider.CacheStats stats = new DataStoreStatusProvider.CacheStats(1L, 2L, 3L, 4L, 5L, 6L);
        MatcherAssert.assertThat((Object)stats.toString(), (Matcher)Matchers.equalTo((Object)"{hit=1, miss=2, loadSuccess=3, loadException=4, totalLoadTime=5, evictionCount=6}"));
    }
}

