/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.sdk.server.interfaces;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSortedMap;
import com.launchdarkly.sdk.server.DataModel;
import com.launchdarkly.sdk.server.subsystems.DataStoreTypes;
import com.launchdarkly.testhelpers.TypeBehavior;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Map;
import java.util.function.Function;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Test;

public class DataStoreTypesTest {
    @Test
    public void dataKindProperties() {
        Function<DataStoreTypes.ItemDescriptor, String> serializer = item -> "version=" + item.getVersion();
        Function<String, DataStoreTypes.ItemDescriptor> deserializer = s -> new DataStoreTypes.ItemDescriptor(0, s);
        DataStoreTypes.DataKind k = new DataStoreTypes.DataKind("foo", serializer, deserializer);
        MatcherAssert.assertThat((Object)k.getName(), (Matcher)Matchers.equalTo((Object)"foo"));
        MatcherAssert.assertThat((Object)k.serialize(new DataStoreTypes.ItemDescriptor(9, null)), (Matcher)Matchers.equalTo((Object)"version=9"));
        MatcherAssert.assertThat((Object)k.deserialize("x"), (Matcher)Matchers.equalTo((Object)new DataStoreTypes.ItemDescriptor(0, (Object)"x")));
        MatcherAssert.assertThat((Object)k.toString(), (Matcher)Matchers.equalTo((Object)"DataKind(foo)"));
    }

    @Test
    public void itemDescriptorProperties() {
        Object o = new Object();
        DataStoreTypes.ItemDescriptor i1 = new DataStoreTypes.ItemDescriptor(1, o);
        MatcherAssert.assertThat((Object)i1.getVersion(), (Matcher)Matchers.equalTo((Object)1));
        MatcherAssert.assertThat((Object)i1.getItem(), (Matcher)Matchers.sameInstance((Object)o));
        DataStoreTypes.ItemDescriptor i2 = DataStoreTypes.ItemDescriptor.deletedItem((int)2);
        MatcherAssert.assertThat((Object)i2.getVersion(), (Matcher)Matchers.equalTo((Object)2));
        MatcherAssert.assertThat((Object)i2.getItem(), (Matcher)Matchers.nullValue());
    }

    @Test
    public void itemDescriptorEquality() {
        ArrayList<TypeBehavior.ValueFactory> allPermutations = new ArrayList<TypeBehavior.ValueFactory>();
        for (int version : new int[]{1, 2}) {
            for (Object item : new Object[]{null, "a", "b"}) {
                allPermutations.add(() -> new DataStoreTypes.ItemDescriptor(version, item));
            }
        }
        TypeBehavior.checkEqualsAndHashCode(allPermutations);
    }

    @Test
    public void itemDescriptorStringRepresentation() {
        MatcherAssert.assertThat((Object)new DataStoreTypes.ItemDescriptor(1, (Object)"a").toString(), (Matcher)Matchers.equalTo((Object)"ItemDescriptor(1,a)"));
        MatcherAssert.assertThat((Object)new DataStoreTypes.ItemDescriptor(2, null).toString(), (Matcher)Matchers.equalTo((Object)"ItemDescriptor(2,null)"));
    }

    @Test
    public void serializedItemDescriptorProperties() {
        DataStoreTypes.SerializedItemDescriptor si1 = new DataStoreTypes.SerializedItemDescriptor(1, false, "x");
        MatcherAssert.assertThat((Object)si1.getVersion(), (Matcher)Matchers.equalTo((Object)1));
        MatcherAssert.assertThat((Object)si1.isDeleted(), (Matcher)Matchers.equalTo((Object)false));
        MatcherAssert.assertThat((Object)si1.getSerializedItem(), (Matcher)Matchers.equalTo((Object)"x"));
        DataStoreTypes.SerializedItemDescriptor si2 = new DataStoreTypes.SerializedItemDescriptor(2, true, null);
        MatcherAssert.assertThat((Object)si2.getVersion(), (Matcher)Matchers.equalTo((Object)2));
        MatcherAssert.assertThat((Object)si2.isDeleted(), (Matcher)Matchers.equalTo((Object)true));
        MatcherAssert.assertThat((Object)si2.getSerializedItem(), (Matcher)Matchers.nullValue());
    }

    @Test
    public void serializedItemDescriptorEquality() {
        ArrayList<TypeBehavior.ValueFactory> allPermutations = new ArrayList<TypeBehavior.ValueFactory>();
        for (int version : new int[]{1, 2}) {
            for (boolean deleted : new boolean[]{true, false}) {
                for (String item : new String[]{null, "a", "b"}) {
                    allPermutations.add(() -> new DataStoreTypes.SerializedItemDescriptor(version, deleted, item));
                }
            }
        }
        TypeBehavior.checkEqualsAndHashCode(allPermutations);
    }

    @Test
    public void serializedItemDescriptorStringRepresentation() {
        MatcherAssert.assertThat((Object)new DataStoreTypes.SerializedItemDescriptor(1, false, "a").toString(), (Matcher)Matchers.equalTo((Object)"SerializedItemDescriptor(1,false,a)"));
        MatcherAssert.assertThat((Object)new DataStoreTypes.SerializedItemDescriptor(2, true, null).toString(), (Matcher)Matchers.equalTo((Object)"SerializedItemDescriptor(2,true,null)"));
    }

    @Test
    public void keyedItemsProperties() {
        DataStoreTypes.ItemDescriptor item1 = new DataStoreTypes.ItemDescriptor(1, (Object)"a");
        DataStoreTypes.ItemDescriptor item2 = new DataStoreTypes.ItemDescriptor(2, (Object)"b");
        DataStoreTypes.KeyedItems items = new DataStoreTypes.KeyedItems((Iterable)ImmutableSortedMap.of((Comparable)((Object)"key1"), (Object)item1, (Comparable)((Object)"key2"), (Object)item2).entrySet());
        MatcherAssert.assertThat((Object)items.getItems(), (Matcher)Matchers.contains((Object[])new Map.Entry[]{new AbstractMap.SimpleEntry<String, DataStoreTypes.ItemDescriptor>("key1", item1), new AbstractMap.SimpleEntry<String, DataStoreTypes.ItemDescriptor>("key2", item2)}));
        DataStoreTypes.KeyedItems emptyItems = new DataStoreTypes.KeyedItems(null);
        MatcherAssert.assertThat((Object)emptyItems.getItems(), (Matcher)Matchers.emptyIterable());
    }

    @Test
    public void keyedItemsEquality() {
        ArrayList<TypeBehavior.ValueFactory> allPermutations = new ArrayList<TypeBehavior.ValueFactory>();
        for (String key : new String[]{"key1", "key2"}) {
            for (int version : new int[]{1, 2}) {
                for (String data : new String[]{null, "a", "b"}) {
                    allPermutations.add(() -> new DataStoreTypes.KeyedItems((Iterable)ImmutableMap.of((Object)key, (Object)new DataStoreTypes.ItemDescriptor(version, (Object)data)).entrySet()));
                }
            }
        }
        TypeBehavior.checkEqualsAndHashCode(allPermutations);
    }

    @Test
    public void fullDataSetProperties() {
        DataStoreTypes.ItemDescriptor item1 = new DataStoreTypes.ItemDescriptor(1, (Object)"a");
        DataStoreTypes.KeyedItems items = new DataStoreTypes.KeyedItems((Iterable)ImmutableMap.of((Object)"key1", (Object)item1).entrySet());
        DataStoreTypes.FullDataSet data = new DataStoreTypes.FullDataSet((Iterable)ImmutableMap.of((Object)DataModel.FEATURES, (Object)items).entrySet());
        MatcherAssert.assertThat((Object)data.getData(), (Matcher)Matchers.contains((Object[])new Map.Entry[]{new AbstractMap.SimpleEntry<DataStoreTypes.DataKind, DataStoreTypes.KeyedItems>(DataModel.FEATURES, items)}));
        DataStoreTypes.FullDataSet emptyData = new DataStoreTypes.FullDataSet(null);
        MatcherAssert.assertThat((Object)emptyData.getData(), (Matcher)Matchers.emptyIterable());
    }

    @Test
    public void fullDataSetEquality() {
        ArrayList<TypeBehavior.ValueFactory> allPermutations = new ArrayList<TypeBehavior.ValueFactory>();
        for (DataStoreTypes.DataKind kind : new DataStoreTypes.DataKind[]{DataModel.FEATURES, DataModel.SEGMENTS}) {
            for (int version : new int[]{1, 2}) {
                allPermutations.add(() -> new DataStoreTypes.FullDataSet((Iterable)ImmutableMap.of((Object)kind, (Object)new DataStoreTypes.KeyedItems((Iterable)ImmutableMap.of((Object)"key", (Object)new DataStoreTypes.ItemDescriptor(version, (Object)"a")).entrySet())).entrySet()));
            }
        }
        TypeBehavior.checkEqualsAndHashCode(allPermutations);
    }
}

