/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.sdk.server;

import com.launchdarkly.logging.LDLogger;
import com.launchdarkly.sdk.EvaluationReason;
import com.launchdarkly.sdk.LDContext;
import com.launchdarkly.sdk.LDValue;
import com.launchdarkly.sdk.server.ClientContextImpl;
import com.launchdarkly.sdk.server.subsystems.ClientContext;
import com.launchdarkly.sdk.server.subsystems.EventProcessor;
import com.launchdarkly.shaded.com.launchdarkly.sdk.internal.events.DefaultEventProcessor;
import com.launchdarkly.shaded.com.launchdarkly.sdk.internal.events.Event;
import com.launchdarkly.shaded.com.launchdarkly.sdk.internal.events.EventsConfiguration;
import java.io.IOException;

final class DefaultEventProcessorWrapper
implements EventProcessor {
    private final DefaultEventProcessor eventProcessor;
    final EventsConfiguration eventsConfig;

    DefaultEventProcessorWrapper(ClientContext clientContext, EventsConfiguration eventsConfig) {
        this.eventsConfig = eventsConfig;
        LDLogger baseLogger = clientContext.getBaseLogger();
        LDLogger logger = baseLogger.subLogger("Events");
        this.eventProcessor = new DefaultEventProcessor(eventsConfig, ClientContextImpl.get((ClientContext)clientContext).sharedExecutor, clientContext.getThreadPriority(), logger);
    }

    @Override
    public void recordEvaluationEvent(LDContext context, String flagKey, int flagVersion, int variation, LDValue value, EvaluationReason reason, LDValue defaultValue, String prerequisiteOfFlagKey, boolean requireFullEvent, Long debugEventsUntilDate) {
        this.eventProcessor.sendEvent(new Event.FeatureRequest(System.currentTimeMillis(), flagKey, context, flagVersion, variation, value, defaultValue, reason, prerequisiteOfFlagKey, requireFullEvent, debugEventsUntilDate, false));
    }

    @Override
    public void recordIdentifyEvent(LDContext context) {
        this.eventProcessor.sendEvent(new Event.Identify(System.currentTimeMillis(), context));
    }

    @Override
    public void recordCustomEvent(LDContext context, String eventKey, LDValue data, Double metricValue) {
        this.eventProcessor.sendEvent(new Event.Custom(System.currentTimeMillis(), eventKey, context, data, metricValue));
    }

    @Override
    public void flush() {
        this.eventProcessor.flushAsync();
    }

    @Override
    public void close() throws IOException {
        this.eventProcessor.close();
    }
}

