/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.sdk.server;

import com.launchdarkly.sdk.LDValue;
import com.launchdarkly.sdk.ObjectBuilder;
import com.launchdarkly.sdk.server.LDConfig;
import com.launchdarkly.sdk.server.subsystems.ClientContext;
import com.launchdarkly.sdk.server.subsystems.DiagnosticDescription;
import com.launchdarkly.sdk.server.subsystems.HttpConfiguration;
import com.launchdarkly.shaded.com.google.common.collect.ImmutableList;
import com.launchdarkly.shaded.com.google.common.collect.ImmutableMap;
import com.launchdarkly.shaded.com.launchdarkly.sdk.internal.events.DiagnosticConfigProperty;
import com.launchdarkly.shaded.com.launchdarkly.sdk.internal.events.DiagnosticStore;

abstract class ServerSideDiagnosticEvents {
    ServerSideDiagnosticEvents() {
    }

    public static DiagnosticStore.SdkDiagnosticParams getSdkDiagnosticParams(ClientContext clientContext, LDConfig config) {
        return new DiagnosticStore.SdkDiagnosticParams(clientContext.getSdkKey(), "java-server-sdk", "6.0.4", "java", ServerSideDiagnosticEvents.makePlatformData(), ImmutableMap.copyOf(clientContext.getHttp().getDefaultHeaders()), ServerSideDiagnosticEvents.makeConfigProperties(clientContext, config));
    }

    private static ImmutableList<LDValue> makeConfigProperties(ClientContext clientContext, LDConfig config) {
        ImmutableList.Builder listBuilder = ImmutableList.builder();
        HttpConfiguration httpConfig = clientContext.getHttp();
        ObjectBuilder builder = LDValue.buildObject();
        builder.put(DiagnosticConfigProperty.CONNECT_TIMEOUT_MILLIS.name, httpConfig.getConnectTimeout().toMillis());
        builder.put(DiagnosticConfigProperty.SOCKET_TIMEOUT_MILLIS.name, httpConfig.getSocketTimeout().toMillis());
        builder.put(DiagnosticConfigProperty.USING_PROXY.name, httpConfig.getProxy() != null);
        builder.put(DiagnosticConfigProperty.USING_PROXY_AUTHENTICATOR.name, httpConfig.getProxyAuthentication() != null);
        builder.put(DiagnosticConfigProperty.START_WAIT_MILLIS.name, config.startWait.toMillis());
        listBuilder.add(builder.build());
        listBuilder.add(ServerSideDiagnosticEvents.describeComponent(config.dataStore, clientContext, DiagnosticConfigProperty.DATA_STORE_TYPE.name));
        listBuilder.add(ServerSideDiagnosticEvents.describeComponent(config.dataSource, clientContext, null));
        listBuilder.add(ServerSideDiagnosticEvents.describeComponent(config.events, clientContext, null));
        return listBuilder.build();
    }

    private static LDValue describeComponent(Object component, ClientContext clientContext, String defaultPropertyName) {
        if (!(component instanceof DiagnosticDescription)) {
            if (defaultPropertyName != null) {
                return LDValue.buildObject().put(defaultPropertyName, "custom").build();
            }
            return LDValue.ofNull();
        }
        LDValue componentDesc = LDValue.normalize(((DiagnosticDescription)component).describeConfiguration(clientContext));
        if (defaultPropertyName == null) {
            return componentDesc;
        }
        return LDValue.buildObject().put(defaultPropertyName, componentDesc.isString() ? componentDesc.stringValue() : "custom").build();
    }

    private static LDValue makePlatformData() {
        return LDValue.buildObject().put("osName", ServerSideDiagnosticEvents.normalizeOsName(System.getProperty("os.name"))).put("javaVendor", System.getProperty("java.vendor")).put("javaVersion", System.getProperty("java.version")).build();
    }

    private static String normalizeOsName(String osName) {
        if (osName != null) {
            if (osName.equals("Mac OS X")) {
                return "MacOS";
            }
            if (osName.startsWith("Windows")) {
                return "Windows";
            }
        }
        return osName;
    }
}

