/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.shaded.com.launchdarkly.sdk.internal.events;

import com.launchdarkly.logging.LDLogger;
import com.launchdarkly.logging.LogValues;
import com.launchdarkly.sdk.LDContext;
import com.launchdarkly.shaded.com.google.gson.Gson;
import com.launchdarkly.shaded.com.launchdarkly.sdk.internal.events.DiagnosticEvent;
import com.launchdarkly.shaded.com.launchdarkly.sdk.internal.events.DiagnosticStore;
import com.launchdarkly.shaded.com.launchdarkly.sdk.internal.events.Event;
import com.launchdarkly.shaded.com.launchdarkly.sdk.internal.events.EventContextDeduplicator;
import com.launchdarkly.shaded.com.launchdarkly.sdk.internal.events.EventOutputFormatter;
import com.launchdarkly.shaded.com.launchdarkly.sdk.internal.events.EventProcessor;
import com.launchdarkly.shaded.com.launchdarkly.sdk.internal.events.EventSender;
import com.launchdarkly.shaded.com.launchdarkly.sdk.internal.events.EventSummarizer;
import com.launchdarkly.shaded.com.launchdarkly.sdk.internal.events.EventsConfiguration;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.Semaphore;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;

public final class DefaultEventProcessor
implements Closeable,
EventProcessor {
    private static final int INITIAL_OUTPUT_BUFFER_SIZE = 2000;
    private static final Gson gson = new Gson();
    private final EventsConfiguration eventsConfig;
    private final BlockingQueue<EventProcessorMessage> inbox;
    private final ScheduledExecutorService scheduler;
    private final AtomicBoolean offline;
    private final AtomicBoolean inBackground;
    private final AtomicBoolean diagnosticInitSent = new AtomicBoolean(false);
    private final AtomicBoolean closed = new AtomicBoolean(false);
    private final Object stateLock = new Object();
    private ScheduledFuture<?> eventFlushTask;
    private ScheduledFuture<?> contextKeysFlushTask;
    private ScheduledFuture<?> periodicDiagnosticEventTask;
    private volatile boolean inputCapacityExceeded = false;
    private final LDLogger logger;

    public DefaultEventProcessor(EventsConfiguration eventsConfig, ScheduledExecutorService sharedExecutor, int threadPriority, LDLogger logger) {
        this.eventsConfig = eventsConfig;
        this.inbox = new ArrayBlockingQueue<EventProcessorMessage>(eventsConfig.capacity);
        this.scheduler = sharedExecutor;
        this.logger = logger;
        this.inBackground = new AtomicBoolean(eventsConfig.initiallyInBackground);
        this.offline = new AtomicBoolean(eventsConfig.initiallyOffline);
        new EventDispatcher(eventsConfig, sharedExecutor, threadPriority, this.inbox, this.inBackground, this.offline, this.closed, logger);
        this.updateScheduledTasks(eventsConfig.initiallyInBackground, eventsConfig.initiallyOffline);
        if (eventsConfig.contextDeduplicator != null && eventsConfig.contextDeduplicator.getFlushInterval() != null) {
            this.contextKeysFlushTask = this.enableOrDisableTask(true, null, eventsConfig.contextDeduplicator.getFlushInterval(), MessageType.FLUSH_USERS);
        }
    }

    @Override
    public void sendEvent(Event e) {
        if (!this.closed.get()) {
            this.postMessageAsync(MessageType.EVENT, e);
        }
    }

    @Override
    public void flushAsync() {
        if (!this.closed.get()) {
            this.postMessageAsync(MessageType.FLUSH, null);
        }
    }

    @Override
    public void flushBlocking() {
        if (!this.closed.get()) {
            this.postMessageAndWait(MessageType.FLUSH, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setInBackground(boolean inBackground) {
        Object object = this.stateLock;
        synchronized (object) {
            if (this.inBackground.getAndSet(inBackground) == inBackground) {
                return;
            }
            this.updateScheduledTasks(inBackground, this.offline.get());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setOffline(boolean offline) {
        Object object = this.stateLock;
        synchronized (object) {
            if (this.offline.getAndSet(offline) == offline) {
                return;
            }
            this.updateScheduledTasks(this.inBackground.get(), offline);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        if (this.closed.compareAndSet(false, true)) {
            Object object = this.stateLock;
            synchronized (object) {
                this.eventFlushTask = this.enableOrDisableTask(false, this.eventFlushTask, 0L, null);
                this.contextKeysFlushTask = this.enableOrDisableTask(false, this.contextKeysFlushTask, 0L, null);
                this.periodicDiagnosticEventTask = this.enableOrDisableTask(false, this.periodicDiagnosticEventTask, 0L, null);
            }
            this.postMessageAsync(MessageType.FLUSH, null);
            this.postMessageAndWait(MessageType.SHUTDOWN, null);
        }
    }

    void updateScheduledTasks(boolean inBackground, boolean offline) {
        this.eventFlushTask = this.enableOrDisableTask(!offline, this.eventFlushTask, this.eventsConfig.flushIntervalMillis, MessageType.FLUSH);
        this.periodicDiagnosticEventTask = this.enableOrDisableTask(!offline && !inBackground && this.eventsConfig.diagnosticStore != null, this.periodicDiagnosticEventTask, this.eventsConfig.diagnosticRecordingIntervalMillis, MessageType.DIAGNOSTIC_STATS);
        if (!(inBackground || offline || this.diagnosticInitSent.get() || this.eventsConfig.diagnosticStore == null)) {
            this.postMessageAsync(MessageType.DIAGNOSTIC_INIT, null);
        }
    }

    ScheduledFuture<?> enableOrDisableTask(boolean shouldEnable, ScheduledFuture<?> currentTask, long intervalMillis, MessageType messageType) {
        if (shouldEnable) {
            if (currentTask != null) {
                return currentTask;
            }
            ScheduledFuture<?> task = this.scheduler.scheduleAtFixedRate(this.postMessageRunnable(messageType, null), intervalMillis, intervalMillis, TimeUnit.MILLISECONDS);
            return task;
        }
        if (currentTask != null) {
            currentTask.cancel(false);
        }
        return null;
    }

    void waitUntilInactive() throws IOException {
        this.postMessageAndWait(MessageType.SYNC, null);
    }

    void postDiagnostic() {
        this.postMessageAsync(MessageType.DIAGNOSTIC_STATS, null);
    }

    private void postMessageAsync(MessageType type, Event event) {
        this.postToChannel(new EventProcessorMessage(type, event, false));
    }

    private void postMessageAndWait(MessageType type, Event event) {
        EventProcessorMessage message = new EventProcessorMessage(type, event, true);
        if (this.postToChannel(message)) {
            message.waitForCompletion();
        }
    }

    private Runnable postMessageRunnable(final MessageType messageType, final Event event) {
        return new Runnable(){

            @Override
            public void run() {
                DefaultEventProcessor.this.postMessageAsync(messageType, event);
            }
        };
    }

    private boolean postToChannel(EventProcessorMessage message) {
        if (this.inbox.offer(message)) {
            return true;
        }
        boolean alreadyLogged = this.inputCapacityExceeded;
        this.inputCapacityExceeded = true;
        if (!alreadyLogged) {
            this.logger.warn("Events are being produced faster than they can be processed; some events will be dropped");
        }
        return false;
    }

    private static final class SendEventsTask
    implements Runnable {
        private final EventsConfiguration eventsConfig;
        private final EventResponseListener responseListener;
        private final BlockingQueue<FlushPayload> payloadQueue;
        private final AtomicInteger activeFlushWorkersCount;
        private final AtomicBoolean stopping;
        private final EventOutputFormatter formatter;
        private final Thread thread;
        private final LDLogger logger;

        SendEventsTask(EventsConfiguration eventsConfig, EventResponseListener responseListener, BlockingQueue<FlushPayload> payloadQueue, AtomicInteger activeFlushWorkersCount, ThreadFactory threadFactory2, LDLogger logger) {
            this.eventsConfig = eventsConfig;
            this.formatter = new EventOutputFormatter(eventsConfig);
            this.responseListener = responseListener;
            this.payloadQueue = payloadQueue;
            this.activeFlushWorkersCount = activeFlushWorkersCount;
            this.stopping = new AtomicBoolean(false);
            this.logger = logger;
            this.thread = threadFactory2.newThread(this);
            this.thread.setDaemon(true);
            this.thread.start();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (!this.stopping.get()) {
                FlushPayload payload = null;
                try {
                    payload = this.payloadQueue.take();
                }
                catch (InterruptedException e) {
                    continue;
                }
                try {
                    ByteArrayOutputStream buffer = new ByteArrayOutputStream(2000);
                    BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)buffer, Charset.forName("UTF-8")), 2000);
                    int outputEventCount = this.formatter.writeOutputEvents(payload.events, payload.summary, writer);
                    ((Writer)writer).flush();
                    EventSender.Result result = this.eventsConfig.eventSender.sendAnalyticsEvents(buffer.toByteArray(), outputEventCount, this.eventsConfig.eventsUri);
                    this.responseListener.handleResponse(result);
                }
                catch (Exception e) {
                    this.logger.error("Unexpected error in event processor: {}", LogValues.exceptionSummary(e));
                    this.logger.debug(LogValues.exceptionTrace(e));
                }
                AtomicInteger atomicInteger = this.activeFlushWorkersCount;
                synchronized (atomicInteger) {
                    this.activeFlushWorkersCount.decrementAndGet();
                    this.activeFlushWorkersCount.notifyAll();
                }
            }
        }

        void stop() {
            this.stopping.set(true);
            this.thread.interrupt();
        }
    }

    private static interface EventResponseListener {
        public void handleResponse(EventSender.Result var1);
    }

    private static final class FlushPayload {
        final Event[] events;
        final EventSummarizer.EventSummary summary;

        FlushPayload(Event[] events, EventSummarizer.EventSummary summary) {
            this.events = events;
            this.summary = summary;
        }
    }

    private static final class EventBuffer {
        final List<Event> events = new ArrayList<Event>();
        final EventSummarizer summarizer = new EventSummarizer();
        private final int capacity;
        private final LDLogger logger;
        private boolean capacityExceeded = false;
        private long droppedEventCount = 0L;

        EventBuffer(int capacity, LDLogger logger) {
            this.capacity = capacity;
            this.logger = logger;
        }

        void add(Event e) {
            if (this.events.size() >= this.capacity) {
                if (!this.capacityExceeded) {
                    this.capacityExceeded = true;
                    this.logger.warn("Exceeded event queue capacity. Increase capacity to avoid dropping events.");
                }
                ++this.droppedEventCount;
            } else {
                this.capacityExceeded = false;
                this.events.add(e);
            }
        }

        void addToSummary(Event.FeatureRequest e) {
            this.summarizer.summarizeEvent(e.getCreationDate(), e.getKey(), e.getVersion(), e.getVariation(), e.getValue(), e.getDefaultVal(), e.getContext());
        }

        boolean isEmpty() {
            return this.events.isEmpty() && this.summarizer.isEmpty();
        }

        long getAndClearDroppedCount() {
            long res = this.droppedEventCount;
            this.droppedEventCount = 0L;
            return res;
        }

        FlushPayload getPayload() {
            Event[] eventsOut = this.events.toArray(new Event[this.events.size()]);
            EventSummarizer.EventSummary summary = this.summarizer.getSummaryAndReset();
            return new FlushPayload(eventsOut, summary);
        }

        void clear() {
            this.events.clear();
            this.summarizer.clear();
        }
    }

    static final class EventDispatcher {
        private static final int MESSAGE_BATCH_SIZE = 50;
        final EventsConfiguration eventsConfig;
        private final BlockingQueue<EventProcessorMessage> inbox;
        private final AtomicBoolean inBackground;
        private final AtomicBoolean offline;
        private final AtomicBoolean closed;
        private final List<SendEventsTask> flushWorkers;
        private final AtomicInteger busyFlushWorkersCount;
        private final AtomicLong lastKnownPastTime = new AtomicLong(0L);
        private final AtomicBoolean disabled = new AtomicBoolean(false);
        private final AtomicBoolean didSendInitEvent = new AtomicBoolean(false);
        final DiagnosticStore diagnosticStore;
        private final EventContextDeduplicator contextDeduplicator;
        private final ExecutorService sharedExecutor;
        private final LDLogger logger;
        private long deduplicatedUsers = 0L;

        private EventDispatcher(EventsConfiguration eventsConfig, ExecutorService sharedExecutor, final int threadPriority, final BlockingQueue<EventProcessorMessage> inbox, AtomicBoolean inBackground, AtomicBoolean offline, AtomicBoolean closed, LDLogger logger) {
            this.eventsConfig = eventsConfig;
            this.inbox = inbox;
            this.inBackground = inBackground;
            this.offline = offline;
            this.closed = closed;
            this.sharedExecutor = sharedExecutor;
            this.diagnosticStore = eventsConfig.diagnosticStore;
            this.busyFlushWorkersCount = new AtomicInteger(0);
            this.logger = logger;
            ThreadFactory threadFactory2 = new ThreadFactory(){

                @Override
                public Thread newThread(Runnable r) {
                    Thread t = new Thread(r);
                    t.setDaemon(true);
                    t.setName(String.format("LaunchDarkly-event-delivery-%d", t.getId()));
                    t.setPriority(threadPriority);
                    return t;
                }
            };
            final ArrayBlockingQueue<FlushPayload> payloadQueue = new ArrayBlockingQueue<FlushPayload>(1);
            final EventBuffer outbox = new EventBuffer(eventsConfig.capacity, logger);
            this.contextDeduplicator = eventsConfig.contextDeduplicator;
            Thread mainThread = threadFactory2.newThread(new Thread(){

                @Override
                public void run() {
                    this.runMainLoop(inbox, outbox, payloadQueue);
                }
            });
            mainThread.setDaemon(true);
            mainThread.setUncaughtExceptionHandler(this::onUncaughtException);
            mainThread.start();
            this.flushWorkers = new ArrayList<SendEventsTask>();
            EventResponseListener listener = this::handleResponse;
            for (int i = 0; i < eventsConfig.eventSendingThreadPoolSize; ++i) {
                SendEventsTask task = new SendEventsTask(eventsConfig, listener, payloadQueue, this.busyFlushWorkersCount, threadFactory2, logger);
                this.flushWorkers.add(task);
            }
        }

        private void onUncaughtException(Thread thread2, Throwable e) {
            this.logger.error("Event processor thread was terminated by an unrecoverable error. No more analytics events will be sent. {} {}", LogValues.exceptionSummary(e), LogValues.exceptionTrace(e));
            this.closed.set(true);
            ArrayList messages = new ArrayList();
            this.inbox.drainTo(messages);
            for (EventProcessorMessage m3 : messages) {
                m3.completed();
            }
        }

        private void runMainLoop(BlockingQueue<EventProcessorMessage> inbox, EventBuffer outbox, BlockingQueue<FlushPayload> payloadQueue) {
            ArrayList<EventProcessorMessage> batch = new ArrayList<EventProcessorMessage>(50);
            while (true) {
                try {
                    block13: while (true) {
                        batch.clear();
                        batch.add(inbox.take());
                        inbox.drainTo(batch, 49);
                        Iterator iterator2 = batch.iterator();
                        while (true) {
                            if (!iterator2.hasNext()) continue block13;
                            EventProcessorMessage message = (EventProcessorMessage)iterator2.next();
                            switch (message.type) {
                                case EVENT: {
                                    this.processEvent(message.event, outbox);
                                    break;
                                }
                                case FLUSH: {
                                    if (this.offline.get()) break;
                                    this.triggerFlush(outbox, payloadQueue);
                                    break;
                                }
                                case FLUSH_USERS: {
                                    if (this.contextDeduplicator == null) break;
                                    this.contextDeduplicator.flush();
                                    break;
                                }
                                case DIAGNOSTIC_INIT: {
                                    if (this.offline.get() || this.inBackground.get() || this.didSendInitEvent.get()) break;
                                    this.sharedExecutor.submit(this.createSendDiagnosticTask(this.diagnosticStore.getInitEvent()));
                                    break;
                                }
                                case DIAGNOSTIC_STATS: {
                                    if (this.offline.get() || this.inBackground.get()) break;
                                    this.sendAndResetDiagnostics(outbox);
                                    break;
                                }
                                case SYNC: {
                                    this.waitUntilAllFlushWorkersInactive();
                                    break;
                                }
                                case SHUTDOWN: {
                                    this.doShutdown();
                                    message.completed();
                                    return;
                                }
                            }
                            message.completed();
                        }
                        break;
                    }
                }
                catch (InterruptedException interruptedException) {
                    continue;
                }
                catch (Exception e) {
                    this.logger.error("Unexpected error in event processor: {}", (Object)e.toString());
                    this.logger.debug(e.toString(), (Object)e);
                    continue;
                }
                break;
            }
        }

        private void sendAndResetDiagnostics(EventBuffer outbox) {
            if (this.disabled.get()) {
                return;
            }
            long droppedEvents = outbox.getAndClearDroppedCount();
            DiagnosticEvent diagnosticEvent = this.diagnosticStore.createEventAndReset(droppedEvents, this.deduplicatedUsers);
            this.deduplicatedUsers = 0L;
            this.sharedExecutor.submit(this.createSendDiagnosticTask(diagnosticEvent));
        }

        private void doShutdown() {
            this.waitUntilAllFlushWorkersInactive();
            this.disabled.set(true);
            for (SendEventsTask task : this.flushWorkers) {
                task.stop();
            }
            try {
                this.eventsConfig.eventSender.close();
            }
            catch (IOException e) {
                this.logger.error("Unexpected error when closing event sender: {}", LogValues.exceptionSummary(e));
                this.logger.debug(LogValues.exceptionTrace(e));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private void waitUntilAllFlushWorkersInactive() {
            while (true) {
                try {
                    while (true) {
                        AtomicInteger atomicInteger = this.busyFlushWorkersCount;
                        synchronized (atomicInteger) {
                            if (this.busyFlushWorkersCount.get() == 0) {
                                return;
                            }
                            this.busyFlushWorkersCount.wait();
                        }
                    }
                }
                catch (InterruptedException interruptedException) {
                    continue;
                }
                break;
            }
        }

        private void processEvent(Event e, EventBuffer outbox) {
            if (this.disabled.get()) {
                return;
            }
            LDContext context = e.getContext();
            if (context == null) {
                return;
            }
            boolean addIndexEvent = false;
            boolean addFullEvent = false;
            Event.FeatureRequest debugEvent = null;
            if (e instanceof Event.FeatureRequest) {
                Event.FeatureRequest fe = (Event.FeatureRequest)e;
                outbox.addToSummary(fe);
                addFullEvent = fe.isTrackEvents();
                if (this.shouldDebugEvent(fe)) {
                    debugEvent = fe.toDebugEvent();
                }
            } else {
                addFullEvent = true;
            }
            if (context != null && context.getFullyQualifiedKey() != null) {
                if (e instanceof Event.FeatureRequest || e instanceof Event.Custom) {
                    if (this.contextDeduplicator != null && !(addIndexEvent = this.contextDeduplicator.processContext(context))) {
                        ++this.deduplicatedUsers;
                    }
                } else if (e instanceof Event.Identify && this.contextDeduplicator != null) {
                    this.contextDeduplicator.processContext(context);
                }
            }
            if (addIndexEvent) {
                Event.Index ie = new Event.Index(e.getCreationDate(), e.getContext());
                outbox.add(ie);
            }
            if (addFullEvent) {
                outbox.add(e);
            }
            if (debugEvent != null) {
                outbox.add(debugEvent);
            }
        }

        private boolean shouldDebugEvent(Event.FeatureRequest fe) {
            long lastPast;
            Long maybeDate = fe.getDebugEventsUntilDate();
            if (maybeDate == null) {
                return false;
            }
            long debugEventsUntilDate = maybeDate;
            return debugEventsUntilDate > 0L && debugEventsUntilDate > (lastPast = this.lastKnownPastTime.get()) && debugEventsUntilDate > System.currentTimeMillis();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void triggerFlush(EventBuffer outbox, BlockingQueue<FlushPayload> payloadQueue) {
            if (this.disabled.get() || outbox.isEmpty()) {
                return;
            }
            FlushPayload payload = outbox.getPayload();
            if (this.diagnosticStore != null) {
                int eventCount = payload.events.length + (payload.summary.isEmpty() ? 0 : 1);
                this.diagnosticStore.recordEventsInBatch(eventCount);
            }
            this.busyFlushWorkersCount.incrementAndGet();
            if (payloadQueue.offer(payload)) {
                outbox.clear();
            } else {
                this.logger.debug("Skipped flushing because all workers are busy");
                outbox.summarizer.restoreTo(payload.summary);
                AtomicInteger atomicInteger = this.busyFlushWorkersCount;
                synchronized (atomicInteger) {
                    this.busyFlushWorkersCount.decrementAndGet();
                    this.busyFlushWorkersCount.notify();
                }
            }
        }

        private void handleResponse(EventSender.Result result) {
            if (result.getTimeFromServer() != null) {
                this.lastKnownPastTime.set(result.getTimeFromServer().getTime());
            }
            if (result.isMustShutDown()) {
                this.disabled.set(true);
            }
        }

        private Runnable createSendDiagnosticTask(final DiagnosticEvent diagnosticEvent) {
            return new Runnable(){

                @Override
                public void run() {
                    try {
                        ByteArrayOutputStream buffer = new ByteArrayOutputStream(2000);
                        BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)buffer, Charset.forName("UTF-8")), 2000);
                        gson.toJson((Object)diagnosticEvent.value, (Appendable)writer);
                        ((Writer)writer).flush();
                        EventSender.Result result = eventsConfig.eventSender.sendDiagnosticEvent(buffer.toByteArray(), eventsConfig.eventsUri);
                        this.handleResponse(result);
                        if (diagnosticEvent.initEvent) {
                            didSendInitEvent.set(true);
                        }
                    }
                    catch (Exception e) {
                        logger.error("Unexpected error in event processor: {}", (Object)e.toString());
                        logger.debug(e.toString(), (Object)e);
                    }
                }
            };
        }
    }

    private static final class EventProcessorMessage {
        private final MessageType type;
        private final Event event;
        private final Semaphore reply;

        private EventProcessorMessage(MessageType type, Event event, boolean sync) {
            this.type = type;
            this.event = event;
            this.reply = sync ? new Semaphore(0) : null;
        }

        void completed() {
            if (this.reply != null) {
                this.reply.release();
            }
        }

        void waitForCompletion() {
            if (this.reply == null) {
                return;
            }
            while (true) {
                try {
                    this.reply.acquire();
                    return;
                }
                catch (InterruptedException interruptedException) {
                    continue;
                }
                break;
            }
        }
    }

    private static enum MessageType {
        EVENT,
        FLUSH,
        FLUSH_USERS,
        DIAGNOSTIC_INIT,
        DIAGNOSTIC_STATS,
        SYNC,
        SHUTDOWN;

    }
}

