/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.shaded.com.launchdarkly.sdk.internal.http;

import com.launchdarkly.logging.LDLogger;

public abstract class HttpErrors {
    private HttpErrors() {
    }

    public static boolean isHttpErrorRecoverable(int statusCode) {
        if (statusCode >= 400 && statusCode < 500) {
            switch (statusCode) {
                case 400: 
                case 408: 
                case 429: {
                    return true;
                }
            }
            return false;
        }
        return true;
    }

    public static boolean checkIfErrorIsRecoverableAndLog(LDLogger logger, String errorDesc, String errorContext, int statusCode, String recoverableMessage) {
        if (statusCode > 0 && !HttpErrors.isHttpErrorRecoverable(statusCode)) {
            logger.error("Error {} (giving up permanently): {}", (Object)errorContext, (Object)errorDesc);
            return false;
        }
        logger.warn("Error {} ({}): {}", errorContext, recoverableMessage, errorDesc);
        return true;
    }

    public static String httpErrorDescription(int statusCode) {
        return "HTTP error " + statusCode + (statusCode == 401 || statusCode == 403 ? " (invalid SDK key)" : "");
    }

    public static final class HttpErrorException
    extends Exception {
        private final int status;

        public HttpErrorException(int status) {
            super("HTTP error " + status);
            this.status = status;
        }

        public int getStatus() {
            return this.status;
        }
    }
}

