/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.sdk.server;

import com.launchdarkly.logging.LDLogAdapter;
import com.launchdarkly.logging.LDLogLevel;
import com.launchdarkly.logging.LDLogger;
import com.launchdarkly.logging.LogCapture;
import com.launchdarkly.logging.Logs;
import com.launchdarkly.sdk.server.Components;
import com.launchdarkly.sdk.server.LDConfig;
import com.launchdarkly.sdk.server.subsystems.ComponentConfigurer;
import org.junit.Rule;
import org.junit.rules.TestWatcher;
import org.junit.runner.Description;

public class BaseTest {
    @Rule
    public DumpLogIfTestFails dumpLogIfTestFails;
    protected final LDLogAdapter testLogging;
    protected final LDLogger testLogger;
    protected final LogCapture logCapture = Logs.capture();

    protected BaseTest() {
        this.testLogging = this.logCapture;
        this.testLogger = LDLogger.withAdapter((LDLogAdapter)this.testLogging, (String)"");
        this.dumpLogIfTestFails = new DumpLogIfTestFails();
    }

    protected LDConfig.Builder baseConfig() {
        return new LDConfig.Builder().dataSource(Components.externalUpdatesOnly()).events(Components.noEvents()).logging((ComponentConfigurer)Components.logging((LDLogAdapter)this.testLogging).level(LDLogLevel.DEBUG));
    }

    class DumpLogIfTestFails
    extends TestWatcher {
        DumpLogIfTestFails() {
        }

        protected void failed(Throwable e, Description description) {
            for (LogCapture.Message message : BaseTest.this.logCapture.getMessages()) {
                System.out.println("LOG {" + description.getDisplayName() + "} >>> " + message.toStringWithTimestamp());
            }
        }
    }
}

