/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.sdk.server;

import com.launchdarkly.logging.LDLogger;
import com.launchdarkly.sdk.EvaluationReason;
import com.launchdarkly.sdk.server.BaseTest;
import com.launchdarkly.sdk.server.BigSegmentStoreWrapper;
import com.launchdarkly.sdk.server.Components;
import com.launchdarkly.sdk.server.EventBroadcasterImpl;
import com.launchdarkly.sdk.server.LDConfig;
import com.launchdarkly.sdk.server.TestComponents;
import com.launchdarkly.sdk.server.interfaces.BigSegmentStoreStatusProvider;
import com.launchdarkly.sdk.server.interfaces.BigSegmentsConfiguration;
import com.launchdarkly.sdk.server.subsystems.BigSegmentStore;
import com.launchdarkly.sdk.server.subsystems.BigSegmentStoreTypes;
import com.launchdarkly.sdk.server.subsystems.ClientContext;
import com.launchdarkly.sdk.server.subsystems.ComponentConfigurer;
import java.time.Duration;
import java.util.Collections;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.easymock.EasyMock;
import org.easymock.EasyMockSupport;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class BigSegmentStoreWrapperTest
extends BaseTest {
    private static final String SDK_KEY = "sdk-key";
    private final EasyMockSupport mocks = new EasyMockSupport();
    private AtomicBoolean storeUnavailable;
    private AtomicReference<BigSegmentStoreTypes.StoreMetadata> storeMetadata;
    private BigSegmentStore storeMock;
    private ComponentConfigurer<BigSegmentStore> storeFactoryMock;
    private EventBroadcasterImpl<BigSegmentStoreStatusProvider.StatusListener, BigSegmentStoreStatusProvider.Status> eventBroadcaster;

    @Before
    public void setup() {
        this.eventBroadcaster = EventBroadcasterImpl.forBigSegmentStoreStatus((ExecutorService)TestComponents.sharedExecutor, (LDLogger)TestComponents.nullLogger);
        this.storeUnavailable = new AtomicBoolean(false);
        this.storeMetadata = new AtomicReference<Object>(null);
        this.storeMock = (BigSegmentStore)this.mocks.niceMock(BigSegmentStore.class);
        EasyMock.expect((Object)this.storeMock.getMetadata()).andAnswer(() -> {
            if (this.storeUnavailable.get()) {
                throw new RuntimeException("sorry");
            }
            return this.storeMetadata.get();
        }).anyTimes();
        this.storeFactoryMock = (ComponentConfigurer)this.mocks.strictMock(ComponentConfigurer.class);
        EasyMock.expect((Object)((BigSegmentStore)this.storeFactoryMock.build((ClientContext)EasyMock.isA(ClientContext.class)))).andReturn((Object)this.storeMock);
    }

    private BigSegmentStoreWrapper makeWrapper(BigSegmentsConfiguration bsConfig) {
        return new BigSegmentStoreWrapper(bsConfig, this.eventBroadcaster, TestComponents.sharedExecutor, this.testLogger);
    }

    private void setStoreMembership(String userKey, BigSegmentStoreTypes.Membership membership) {
        EasyMock.expect((Object)this.storeMock.getMembership(BigSegmentStoreWrapper.hashForUserKey((String)userKey))).andReturn((Object)membership);
    }

    @Test
    public void membershipQueryWithUncachedResultAndHealthyStatus() throws Exception {
        BigSegmentStoreTypes.Membership expectedMembership = BigSegmentStoreTypes.createMembershipFromSegmentRefs(Collections.singleton("key1"), Collections.singleton("key2"));
        String userKey = "userkey";
        this.setStoreMembership(userKey, expectedMembership);
        this.mocks.replayAll();
        this.storeMetadata.set(new BigSegmentStoreTypes.StoreMetadata(System.currentTimeMillis()));
        BigSegmentsConfiguration bsConfig = Components.bigSegments(this.storeFactoryMock).staleAfter(Duration.ofDays(1L)).build((ClientContext)TestComponents.clientContext(SDK_KEY, new LDConfig.Builder().build()));
        try (BigSegmentStoreWrapper wrapper = this.makeWrapper(bsConfig);){
            BigSegmentStoreWrapper.BigSegmentsQueryResult res = wrapper.getUserMembership(userKey);
            Assert.assertEquals((Object)expectedMembership, (Object)res.membership);
            Assert.assertEquals((Object)EvaluationReason.BigSegmentsStatus.HEALTHY, (Object)res.status);
        }
    }

    @Test
    public void membershipQueryReturnsNull() throws Exception {
        String userKey = "userkey";
        this.setStoreMembership(userKey, null);
        this.mocks.replayAll();
        this.storeMetadata.set(new BigSegmentStoreTypes.StoreMetadata(System.currentTimeMillis()));
        BigSegmentsConfiguration bsConfig = Components.bigSegments(this.storeFactoryMock).staleAfter(Duration.ofDays(1L)).build((ClientContext)TestComponents.clientContext(SDK_KEY, new LDConfig.Builder().build()));
        try (BigSegmentStoreWrapper wrapper = this.makeWrapper(bsConfig);){
            BigSegmentStoreWrapper.BigSegmentsQueryResult res = wrapper.getUserMembership(userKey);
            Assert.assertEquals((Object)BigSegmentStoreTypes.createMembershipFromSegmentRefs(null, null), (Object)res.membership);
            Assert.assertEquals((Object)EvaluationReason.BigSegmentsStatus.HEALTHY, (Object)res.status);
        }
    }

    @Test
    public void membershipQueryWithCachedResultAndHealthyStatus() throws Exception {
        BigSegmentStoreTypes.Membership expectedMembership = BigSegmentStoreTypes.createMembershipFromSegmentRefs(Collections.singleton("key1"), Collections.singleton("key2"));
        String userKey = "userkey";
        this.setStoreMembership(userKey, expectedMembership);
        this.mocks.replayAll();
        this.storeMetadata.set(new BigSegmentStoreTypes.StoreMetadata(System.currentTimeMillis()));
        BigSegmentsConfiguration bsConfig = Components.bigSegments(this.storeFactoryMock).staleAfter(Duration.ofDays(1L)).build((ClientContext)TestComponents.clientContext(SDK_KEY, new LDConfig.Builder().build()));
        try (BigSegmentStoreWrapper wrapper = this.makeWrapper(bsConfig);){
            BigSegmentStoreWrapper.BigSegmentsQueryResult res1 = wrapper.getUserMembership(userKey);
            Assert.assertEquals((Object)expectedMembership, (Object)res1.membership);
            Assert.assertEquals((Object)EvaluationReason.BigSegmentsStatus.HEALTHY, (Object)res1.status);
            BigSegmentStoreWrapper.BigSegmentsQueryResult res2 = wrapper.getUserMembership(userKey);
            Assert.assertEquals((Object)expectedMembership, (Object)res2.membership);
            Assert.assertEquals((Object)EvaluationReason.BigSegmentsStatus.HEALTHY, (Object)res2.status);
        }
    }

    @Test
    public void membershipQueryWithStaleStatus() throws Exception {
        BigSegmentStoreTypes.Membership expectedMembership = BigSegmentStoreTypes.createMembershipFromSegmentRefs(Collections.singleton("key1"), Collections.singleton("key2"));
        String userKey = "userkey";
        this.setStoreMembership(userKey, expectedMembership);
        this.mocks.replayAll();
        this.storeMetadata.set(new BigSegmentStoreTypes.StoreMetadata(System.currentTimeMillis() - 1000L));
        BigSegmentsConfiguration bsConfig = Components.bigSegments(this.storeFactoryMock).staleAfter(Duration.ofMillis(500L)).build((ClientContext)TestComponents.clientContext(SDK_KEY, new LDConfig.Builder().build()));
        try (BigSegmentStoreWrapper wrapper = this.makeWrapper(bsConfig);){
            BigSegmentStoreWrapper.BigSegmentsQueryResult res = wrapper.getUserMembership(userKey);
            Assert.assertEquals((Object)expectedMembership, (Object)res.membership);
            Assert.assertEquals((Object)EvaluationReason.BigSegmentsStatus.STALE, (Object)res.status);
        }
    }

    @Test
    public void membershipQueryWithStaleStatusDueToNoStoreMetadata() throws Exception {
        BigSegmentStoreTypes.Membership expectedMembership = BigSegmentStoreTypes.createMembershipFromSegmentRefs(Collections.singleton("key1"), Collections.singleton("key2"));
        String userKey = "userkey";
        this.setStoreMembership(userKey, expectedMembership);
        this.mocks.replayAll();
        this.storeMetadata.set(null);
        BigSegmentsConfiguration bsConfig = Components.bigSegments(this.storeFactoryMock).staleAfter(Duration.ofMillis(500L)).build((ClientContext)TestComponents.clientContext(SDK_KEY, new LDConfig.Builder().build()));
        try (BigSegmentStoreWrapper wrapper = this.makeWrapper(bsConfig);){
            BigSegmentStoreWrapper.BigSegmentsQueryResult res = wrapper.getUserMembership(userKey);
            Assert.assertEquals((Object)expectedMembership, (Object)res.membership);
            Assert.assertEquals((Object)EvaluationReason.BigSegmentsStatus.STALE, (Object)res.status);
        }
    }

    @Test
    public void leastRecentUserIsEvictedFromCache() throws Exception {
        String userKey1 = "userkey1";
        String userKey2 = "userkey2";
        String userKey3 = "userkey3";
        BigSegmentStoreTypes.Membership expectedMembership1 = BigSegmentStoreTypes.createMembershipFromSegmentRefs(Collections.singleton("seg1"), null);
        BigSegmentStoreTypes.Membership expectedMembership2 = BigSegmentStoreTypes.createMembershipFromSegmentRefs(Collections.singleton("seg2"), null);
        BigSegmentStoreTypes.Membership expectedMembership3 = BigSegmentStoreTypes.createMembershipFromSegmentRefs(Collections.singleton("seg3"), null);
        this.setStoreMembership(userKey1, expectedMembership1);
        this.setStoreMembership(userKey2, expectedMembership2);
        this.setStoreMembership(userKey3, expectedMembership3);
        this.setStoreMembership(userKey1, expectedMembership1);
        this.mocks.replayAll();
        this.storeMetadata.set(new BigSegmentStoreTypes.StoreMetadata(System.currentTimeMillis()));
        BigSegmentsConfiguration bsConfig = Components.bigSegments(this.storeFactoryMock).userCacheSize(2).staleAfter(Duration.ofDays(1L)).build((ClientContext)TestComponents.clientContext(SDK_KEY, new LDConfig.Builder().build()));
        try (BigSegmentStoreWrapper wrapper = this.makeWrapper(bsConfig);){
            BigSegmentStoreWrapper.BigSegmentsQueryResult res1 = wrapper.getUserMembership(userKey1);
            Assert.assertEquals((Object)expectedMembership1, (Object)res1.membership);
            Assert.assertEquals((Object)EvaluationReason.BigSegmentsStatus.HEALTHY, (Object)res1.status);
            BigSegmentStoreWrapper.BigSegmentsQueryResult res2 = wrapper.getUserMembership(userKey2);
            Assert.assertEquals((Object)expectedMembership2, (Object)res2.membership);
            Assert.assertEquals((Object)EvaluationReason.BigSegmentsStatus.HEALTHY, (Object)res2.status);
            BigSegmentStoreWrapper.BigSegmentsQueryResult res3 = wrapper.getUserMembership(userKey3);
            Assert.assertEquals((Object)expectedMembership3, (Object)res3.membership);
            Assert.assertEquals((Object)EvaluationReason.BigSegmentsStatus.HEALTHY, (Object)res3.status);
            BigSegmentStoreWrapper.BigSegmentsQueryResult res2a = wrapper.getUserMembership(userKey2);
            Assert.assertEquals((Object)expectedMembership2, (Object)res2a.membership);
            Assert.assertEquals((Object)EvaluationReason.BigSegmentsStatus.HEALTHY, (Object)res2a.status);
            BigSegmentStoreWrapper.BigSegmentsQueryResult res3a = wrapper.getUserMembership(userKey3);
            Assert.assertEquals((Object)expectedMembership3, (Object)res3a.membership);
            Assert.assertEquals((Object)EvaluationReason.BigSegmentsStatus.HEALTHY, (Object)res3a.status);
            BigSegmentStoreWrapper.BigSegmentsQueryResult res1a = wrapper.getUserMembership(userKey1);
            Assert.assertEquals((Object)expectedMembership1, (Object)res1a.membership);
            Assert.assertEquals((Object)EvaluationReason.BigSegmentsStatus.HEALTHY, (Object)res1a.status);
        }
    }

    @Test
    public void pollingDetectsStoreUnavailability() throws Exception {
        this.mocks.replayAll();
        this.storeMetadata.set(new BigSegmentStoreTypes.StoreMetadata(System.currentTimeMillis()));
        BigSegmentsConfiguration bsConfig = Components.bigSegments(this.storeFactoryMock).statusPollInterval(Duration.ofMillis(10L)).staleAfter(Duration.ofDays(1L)).build((ClientContext)TestComponents.clientContext(SDK_KEY, new LDConfig.Builder().build()));
        try (BigSegmentStoreWrapper wrapper = this.makeWrapper(bsConfig);){
            Assert.assertTrue((boolean)wrapper.getStatus().isAvailable());
            LinkedBlockingQueue statuses = new LinkedBlockingQueue();
            this.eventBroadcaster.register(statuses::add);
            this.storeUnavailable.set(true);
            BigSegmentStoreStatusProvider.Status status1 = (BigSegmentStoreStatusProvider.Status)statuses.take();
            if (status1.isAvailable()) {
                status1 = (BigSegmentStoreStatusProvider.Status)statuses.take();
            }
            Assert.assertFalse((boolean)status1.isAvailable());
            Assert.assertEquals((Object)status1, (Object)wrapper.getStatus());
            this.storeUnavailable.set(false);
            BigSegmentStoreStatusProvider.Status status2 = (BigSegmentStoreStatusProvider.Status)statuses.take();
            Assert.assertTrue((boolean)status2.isAvailable());
            Assert.assertEquals((Object)status2, (Object)wrapper.getStatus());
        }
    }

    @Test
    public void pollingDetectsStaleStatus() throws Exception {
        this.mocks.replayAll();
        this.storeMetadata.set(new BigSegmentStoreTypes.StoreMetadata(System.currentTimeMillis() + 10000L));
        BigSegmentsConfiguration bsConfig = Components.bigSegments(this.storeFactoryMock).statusPollInterval(Duration.ofMillis(10L)).staleAfter(Duration.ofMillis(200L)).build((ClientContext)TestComponents.clientContext(SDK_KEY, new LDConfig.Builder().build()));
        try (BigSegmentStoreWrapper wrapper = this.makeWrapper(bsConfig);){
            Assert.assertFalse((boolean)wrapper.getStatus().isStale());
            LinkedBlockingQueue statuses = new LinkedBlockingQueue();
            this.eventBroadcaster.register(statuses::add);
            this.storeMetadata.set(new BigSegmentStoreTypes.StoreMetadata(System.currentTimeMillis() - 1000L));
            BigSegmentStoreStatusProvider.Status status1 = (BigSegmentStoreStatusProvider.Status)statuses.take();
            if (!status1.isStale()) {
                status1 = (BigSegmentStoreStatusProvider.Status)statuses.take();
            }
            Assert.assertTrue((boolean)status1.isStale());
            Assert.assertEquals((Object)status1, (Object)wrapper.getStatus());
            this.storeMetadata.set(new BigSegmentStoreTypes.StoreMetadata(System.currentTimeMillis() + 10000L));
            BigSegmentStoreStatusProvider.Status status2 = (BigSegmentStoreStatusProvider.Status)statuses.take();
            Assert.assertFalse((boolean)status2.isStale());
            Assert.assertEquals((Object)status2, (Object)wrapper.getStatus());
        }
    }
}

