/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.sdk.server;

import com.launchdarkly.sdk.server.ClientContextImpl;
import com.launchdarkly.sdk.server.Components;
import com.launchdarkly.sdk.server.LDConfig;
import com.launchdarkly.sdk.server.TestComponents;
import com.launchdarkly.sdk.server.integrations.HttpConfigurationBuilder;
import com.launchdarkly.sdk.server.integrations.LoggingConfigurationBuilder;
import com.launchdarkly.sdk.server.subsystems.ClientContext;
import com.launchdarkly.sdk.server.subsystems.ComponentConfigurer;
import com.launchdarkly.sdk.server.subsystems.HttpConfiguration;
import com.launchdarkly.sdk.server.subsystems.LoggingConfiguration;
import java.time.Duration;
import java.util.concurrent.ScheduledExecutorService;
import org.junit.Assert;
import org.junit.Test;

public class ClientContextImplTest {
    private static final String SDK_KEY = "sdk-key";

    @Test
    public void getBasicDefaultProperties() {
        LDConfig config = new LDConfig.Builder().build();
        ClientContextImpl c = ClientContextImpl.fromConfig((String)SDK_KEY, (LDConfig)config, null);
        Assert.assertEquals((Object)SDK_KEY, (Object)c.getSdkKey());
        Assert.assertFalse((boolean)c.isOffline());
        Assert.assertEquals((long)1L, (long)c.getThreadPriority());
        HttpConfiguration httpConfig = c.getHttp();
        Assert.assertEquals((Object)HttpConfigurationBuilder.DEFAULT_CONNECT_TIMEOUT, (Object)httpConfig.getConnectTimeout());
        LoggingConfiguration loggingConfig = c.getLogging();
        Assert.assertEquals((Object)LoggingConfigurationBuilder.DEFAULT_LOG_DATA_SOURCE_OUTAGE_AS_ERROR_AFTER, (Object)loggingConfig.getLogDataSourceOutageAsErrorAfter());
    }

    @Test
    public void getBasicPropertiesWithCustomConfig() {
        LDConfig config = new LDConfig.Builder().http((ComponentConfigurer)Components.httpConfiguration().connectTimeout(Duration.ofSeconds(10L))).logging((ComponentConfigurer)Components.logging().logDataSourceOutageAsErrorAfter(Duration.ofMinutes(20L))).offline(true).threadPriority(10).build();
        ClientContextImpl c = ClientContextImpl.fromConfig((String)SDK_KEY, (LDConfig)config, (ScheduledExecutorService)TestComponents.sharedExecutor);
        Assert.assertEquals((Object)SDK_KEY, (Object)c.getSdkKey());
        Assert.assertTrue((boolean)c.isOffline());
        Assert.assertEquals((long)10L, (long)c.getThreadPriority());
        HttpConfiguration httpConfig = c.getHttp();
        Assert.assertEquals((Object)Duration.ofSeconds(10L), (Object)httpConfig.getConnectTimeout());
        LoggingConfiguration loggingConfig = c.getLogging();
        Assert.assertEquals((Object)Duration.ofMinutes(20L), (Object)loggingConfig.getLogDataSourceOutageAsErrorAfter());
    }

    @Test
    public void getPackagePrivateSharedExecutor() {
        LDConfig config = new LDConfig.Builder().build();
        ClientContextImpl c = ClientContextImpl.fromConfig((String)SDK_KEY, (LDConfig)config, (ScheduledExecutorService)TestComponents.sharedExecutor);
        Assert.assertSame((Object)TestComponents.sharedExecutor, (Object)ClientContextImpl.get((ClientContext)c).sharedExecutor);
    }

    @Test
    public void getPackagePrivateDiagnosticAccumulator() {
        LDConfig config = new LDConfig.Builder().build();
        ClientContextImpl c = ClientContextImpl.fromConfig((String)SDK_KEY, (LDConfig)config, (ScheduledExecutorService)TestComponents.sharedExecutor);
        Assert.assertNotNull((Object)ClientContextImpl.get((ClientContext)c).diagnosticStore);
    }

    @Test
    public void diagnosticStoreIsNullIfOptedOut() {
        LDConfig config = new LDConfig.Builder().diagnosticOptOut(true).build();
        ClientContextImpl c = ClientContextImpl.fromConfig((String)SDK_KEY, (LDConfig)config, (ScheduledExecutorService)TestComponents.sharedExecutor);
        Assert.assertNull((Object)ClientContextImpl.get((ClientContext)c).diagnosticStore);
    }

    @Test
    public void packagePrivatePropertiesHaveDefaultsIfContextIsNotOurImplementation() {
        ClientContext c = new ClientContext(SDK_KEY);
        ClientContextImpl impl = ClientContextImpl.get((ClientContext)c);
        Assert.assertNotNull((Object)impl.sharedExecutor);
        Assert.assertNull((Object)impl.diagnosticStore);
        ClientContextImpl impl2 = ClientContextImpl.get((ClientContext)c);
        Assert.assertNotNull((Object)impl2.sharedExecutor);
        Assert.assertSame((Object)impl.sharedExecutor, (Object)impl2.sharedExecutor);
    }
}

