/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.sdk.server;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.launchdarkly.sdk.LDValue;
import com.launchdarkly.sdk.server.DataModel;
import com.launchdarkly.sdk.server.DataModelDependencies;
import com.launchdarkly.sdk.server.DataStoreTestTypes;
import com.launchdarkly.sdk.server.ModelBuilders;
import com.launchdarkly.sdk.server.subsystems.DataStoreTypes;
import java.util.HashSet;
import java.util.Map;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;

public class DataModelDependenciesTest {
    static DataStoreTypes.FullDataSet<DataStoreTypes.ItemDescriptor> DEPENDENCY_ORDERING_TEST_DATA = new DataStoreTestTypes.DataBuilder().addAny(DataModel.FEATURES, new DataModel.VersionedData[]{ModelBuilders.flagBuilder("a").prerequisites(ModelBuilders.prerequisite("b", 0), ModelBuilders.prerequisite("c", 0)).build(), ModelBuilders.flagBuilder("b").prerequisites(ModelBuilders.prerequisite("c", 0), ModelBuilders.prerequisite("e", 0)).build(), ModelBuilders.flagBuilder("c").build(), ModelBuilders.flagBuilder("d").build(), ModelBuilders.flagBuilder("e").build(), ModelBuilders.flagBuilder("f").build()}).addAny(DataModel.SEGMENTS, new DataModel.VersionedData[]{ModelBuilders.segmentBuilder("o").build()}).build();

    @Test
    public void computeDependenciesFromFlag() {
        DataModel.FeatureFlag flag1 = ModelBuilders.flagBuilder("key").build();
        MatcherAssert.assertThat((Object)DataModelDependencies.computeDependenciesFrom((DataStoreTypes.DataKind)DataModel.FEATURES, (DataStoreTypes.ItemDescriptor)new DataStoreTypes.ItemDescriptor(flag1.getVersion(), (Object)flag1)), (Matcher)Matchers.emptyIterable());
        DataModel.FeatureFlag flag2 = ModelBuilders.flagBuilder("key").prerequisites(ModelBuilders.prerequisite("flag2", 0), ModelBuilders.prerequisite("flag3", 0)).rules(ModelBuilders.ruleBuilder().clauses(ModelBuilders.clause("key", DataModel.Operator.in, LDValue.of((String)"ignore")), ModelBuilders.clauseMatchingSegment("segment1", "segment2")).build(), ModelBuilders.ruleBuilder().clauses(ModelBuilders.clauseMatchingSegment("segment3")).build()).build();
        MatcherAssert.assertThat((Object)DataModelDependencies.computeDependenciesFrom((DataStoreTypes.DataKind)DataModel.FEATURES, (DataStoreTypes.ItemDescriptor)new DataStoreTypes.ItemDescriptor(flag2.getVersion(), (Object)flag2)), (Matcher)Matchers.contains((Object[])new DataModelDependencies.KindAndKey[]{new DataModelDependencies.KindAndKey(DataModel.FEATURES, "flag2"), new DataModelDependencies.KindAndKey(DataModel.FEATURES, "flag3"), new DataModelDependencies.KindAndKey(DataModel.SEGMENTS, "segment1"), new DataModelDependencies.KindAndKey(DataModel.SEGMENTS, "segment2"), new DataModelDependencies.KindAndKey(DataModel.SEGMENTS, "segment3")}));
    }

    @Test
    public void computeDependenciesFromSegment() {
        DataModel.Segment segment = ModelBuilders.segmentBuilder("segment").build();
        MatcherAssert.assertThat((Object)DataModelDependencies.computeDependenciesFrom((DataStoreTypes.DataKind)DataModel.SEGMENTS, (DataStoreTypes.ItemDescriptor)new DataStoreTypes.ItemDescriptor(segment.getVersion(), (Object)segment)), (Matcher)Matchers.emptyIterable());
    }

    @Test
    public void computeDependenciesFromUnknownDataKind() {
        MatcherAssert.assertThat((Object)DataModelDependencies.computeDependenciesFrom((DataStoreTypes.DataKind)DataStoreTestTypes.TEST_ITEMS, (DataStoreTypes.ItemDescriptor)new DataStoreTypes.ItemDescriptor(1, (Object)new DataStoreTestTypes.TestItem("x", 1))), (Matcher)Matchers.emptyIterable());
    }

    @Test
    public void computeDependenciesFromNullItem() {
        MatcherAssert.assertThat((Object)DataModelDependencies.computeDependenciesFrom((DataStoreTypes.DataKind)DataModel.FEATURES, (DataStoreTypes.ItemDescriptor)new DataStoreTypes.ItemDescriptor(1, null)), (Matcher)Matchers.emptyIterable());
        MatcherAssert.assertThat((Object)DataModelDependencies.computeDependenciesFrom((DataStoreTypes.DataKind)DataModel.FEATURES, null), (Matcher)Matchers.emptyIterable());
    }

    @Test
    public void sortAllCollections() {
        DataStoreTypes.FullDataSet result = DataModelDependencies.sortAllCollections(DEPENDENCY_ORDERING_TEST_DATA);
        DataModelDependenciesTest.verifySortedData((DataStoreTypes.FullDataSet<DataStoreTypes.ItemDescriptor>)result, DEPENDENCY_ORDERING_TEST_DATA);
    }

    @Test
    public void sortAllCollectionsLeavesItemsOfUnknownDataKindUnchanged() {
        DataStoreTestTypes.TestItem extraItem1 = new DataStoreTestTypes.TestItem("item1", 1);
        DataStoreTestTypes.TestItem extraItem2 = new DataStoreTestTypes.TestItem("item2", 1);
        DataStoreTypes.FullDataSet<DataStoreTypes.ItemDescriptor> inputData = new DataStoreTestTypes.DataBuilder().addAny(DataModel.FEATURES, new DataModel.VersionedData[]{ModelBuilders.flagBuilder("a").prerequisites(ModelBuilders.prerequisite("b", 0), ModelBuilders.prerequisite("c", 0)).build(), ModelBuilders.flagBuilder("b").prerequisites(ModelBuilders.prerequisite("c", 0)).build(), ModelBuilders.flagBuilder("c").build()}).addAny(DataModel.SEGMENTS, new DataModel.VersionedData[0]).addAny(DataStoreTestTypes.TEST_ITEMS, extraItem1, extraItem2).build();
        DataStoreTypes.FullDataSet result = DataModelDependencies.sortAllCollections(inputData);
        MatcherAssert.assertThat((Object)result.getData(), (Matcher)Matchers.iterableWithSize((int)3));
        MatcherAssert.assertThat((Object)Iterables.transform((Iterable)result.getData(), coll -> (DataStoreTypes.DataKind)coll.getKey()), (Matcher)Matchers.contains((Object[])new DataStoreTypes.DataKind[]{DataModel.SEGMENTS, DataModel.FEATURES, DataStoreTestTypes.TEST_ITEMS}));
        MatcherAssert.assertThat((Object)((DataStoreTypes.KeyedItems)((Map.Entry)Iterables.get((Iterable)result.getData(), (int)2)).getValue()).getItems(), (Matcher)Matchers.contains((Object[])new Map.Entry[]{extraItem1.toKeyedItemDescriptor(), extraItem2.toKeyedItemDescriptor()}));
    }

    static void verifySortedData(DataStoreTypes.FullDataSet<DataStoreTypes.ItemDescriptor> sortedData, DataStoreTypes.FullDataSet<DataStoreTypes.ItemDescriptor> inputData) {
        Map<DataStoreTypes.DataKind, Map<String, DataStoreTypes.ItemDescriptor>> dataMap = DataStoreTestTypes.toDataMap(sortedData);
        Assert.assertEquals((long)2L, (long)dataMap.size());
        Map<DataStoreTypes.DataKind, Map<String, DataStoreTypes.ItemDescriptor>> inputDataMap = DataStoreTestTypes.toDataMap(inputData);
        Assert.assertEquals((Object)DataModel.SEGMENTS, (Object)Iterables.get(dataMap.keySet(), (int)0));
        Assert.assertEquals((long)inputDataMap.get(DataModel.SEGMENTS).size(), (long)((Map)Iterables.get(dataMap.values(), (int)0)).size());
        Assert.assertEquals((Object)DataModel.FEATURES, (Object)Iterables.get(dataMap.keySet(), (int)1));
        Map map1 = (Map)Iterables.get(dataMap.values(), (int)1);
        ImmutableList list1 = ImmutableList.copyOf((Iterable)Iterables.transform(map1.values(), d -> (DataModel.FeatureFlag)d.getItem()));
        Assert.assertEquals((long)inputDataMap.get(DataModel.FEATURES).size(), (long)map1.size());
        for (int itemIndex = 0; itemIndex < list1.size(); ++itemIndex) {
            DataModel.FeatureFlag item = (DataModel.FeatureFlag)list1.get(itemIndex);
            for (DataModel.Prerequisite prereq : item.getPrerequisites()) {
                DataModel.FeatureFlag depFlag = (DataModel.FeatureFlag)((DataStoreTypes.ItemDescriptor)map1.get(prereq.getKey())).getItem();
                int depIndex = list1.indexOf(depFlag);
                if (depIndex <= itemIndex) continue;
                Assert.fail((String)String.format("%s depends on %s, but %s was listed first; keys in order are [%s]", item.getKey(), prereq.getKey(), item.getKey(), Joiner.on((String)", ").join(map1.keySet())));
            }
        }
    }

    @Test
    public void dependencyTrackerReturnsSingleValueResultForUnknownItem() {
        DataModelDependencies.DependencyTracker dt = new DataModelDependencies.DependencyTracker();
        this.verifyAffectedItems(dt, DataModel.FEATURES, "flag1", new DataModelDependencies.KindAndKey(DataModel.FEATURES, "flag1"));
    }

    @Test
    public void dependencyTrackerBuildsGraph() {
        DataModelDependencies.DependencyTracker dt = new DataModelDependencies.DependencyTracker();
        DataModel.Segment segment1 = ModelBuilders.segmentBuilder("segment1").build();
        DataModel.Segment segment2 = ModelBuilders.segmentBuilder("segment2").rules(ModelBuilders.segmentRuleBuilder().clauses(ModelBuilders.clauseMatchingSegment("segment3")).build()).build();
        DataModel.Segment segment3 = ModelBuilders.segmentBuilder("segment3").build();
        DataModel.FeatureFlag flag1 = ModelBuilders.flagBuilder("flag1").prerequisites(ModelBuilders.prerequisite("flag2", 0), ModelBuilders.prerequisite("flag3", 0)).rules(ModelBuilders.ruleBuilder().clauses(ModelBuilders.clauseMatchingSegment("segment1", "segment2")).build()).build();
        DataModel.FeatureFlag flag2 = ModelBuilders.flagBuilder("flag2").prerequisites(ModelBuilders.prerequisite("flag4", 0)).rules(ModelBuilders.ruleBuilder().clauses(ModelBuilders.clauseMatchingSegment("segment2")).build()).build();
        for (DataModel.Segment segment : new DataModel.Segment[]{segment1, segment2, segment3}) {
            dt.updateDependenciesFrom(DataModel.SEGMENTS, segment.getKey(), new DataStoreTypes.ItemDescriptor(segment.getVersion(), (Object)segment));
        }
        for (DataModel.Segment segment : new DataModel.FeatureFlag[]{flag1, flag2}) {
            dt.updateDependenciesFrom(DataModel.FEATURES, segment.getKey(), new DataStoreTypes.ItemDescriptor(segment.getVersion(), (Object)segment));
        }
        this.verifyAffectedItems(dt, DataModel.FEATURES, "flag1", new DataModelDependencies.KindAndKey(DataModel.FEATURES, "flag1"));
        this.verifyAffectedItems(dt, DataModel.FEATURES, "flag2", new DataModelDependencies.KindAndKey(DataModel.FEATURES, "flag2"), new DataModelDependencies.KindAndKey(DataModel.FEATURES, "flag1"));
        this.verifyAffectedItems(dt, DataModel.FEATURES, "flag3", new DataModelDependencies.KindAndKey(DataModel.FEATURES, "flag3"), new DataModelDependencies.KindAndKey(DataModel.FEATURES, "flag1"));
        this.verifyAffectedItems(dt, DataModel.SEGMENTS, "segment1", new DataModelDependencies.KindAndKey(DataModel.SEGMENTS, "segment1"), new DataModelDependencies.KindAndKey(DataModel.FEATURES, "flag1"));
        this.verifyAffectedItems(dt, DataModel.SEGMENTS, "segment2", new DataModelDependencies.KindAndKey(DataModel.SEGMENTS, "segment2"), new DataModelDependencies.KindAndKey(DataModel.FEATURES, "flag1"), new DataModelDependencies.KindAndKey(DataModel.FEATURES, "flag2"));
        this.verifyAffectedItems(dt, DataModel.SEGMENTS, "segment3", new DataModelDependencies.KindAndKey(DataModel.SEGMENTS, "segment3"), new DataModelDependencies.KindAndKey(DataModel.SEGMENTS, "segment2"), new DataModelDependencies.KindAndKey(DataModel.FEATURES, "flag1"), new DataModelDependencies.KindAndKey(DataModel.FEATURES, "flag2"));
    }

    @Test
    public void dependencyTrackerUpdatesGraph() {
        DataModelDependencies.DependencyTracker dt = new DataModelDependencies.DependencyTracker();
        DataModel.FeatureFlag flag1 = ModelBuilders.flagBuilder("flag1").prerequisites(ModelBuilders.prerequisite("flag3", 0)).build();
        dt.updateDependenciesFrom(DataModel.FEATURES, flag1.getKey(), new DataStoreTypes.ItemDescriptor(flag1.getVersion(), (Object)flag1));
        DataModel.FeatureFlag flag2 = ModelBuilders.flagBuilder("flag2").prerequisites(ModelBuilders.prerequisite("flag3", 0)).build();
        dt.updateDependenciesFrom(DataModel.FEATURES, flag2.getKey(), new DataStoreTypes.ItemDescriptor(flag2.getVersion(), (Object)flag2));
        this.verifyAffectedItems(dt, DataModel.FEATURES, "flag3", new DataModelDependencies.KindAndKey(DataModel.FEATURES, "flag3"), new DataModelDependencies.KindAndKey(DataModel.FEATURES, "flag2"), new DataModelDependencies.KindAndKey(DataModel.FEATURES, "flag1"));
        DataModel.FeatureFlag flag1v2 = ModelBuilders.flagBuilder("flag1").prerequisites(ModelBuilders.prerequisite("flag4", 0)).build();
        dt.updateDependenciesFrom(DataModel.FEATURES, flag1.getKey(), new DataStoreTypes.ItemDescriptor(flag1v2.getVersion(), (Object)flag1v2));
        this.verifyAffectedItems(dt, DataModel.FEATURES, "flag3", new DataModelDependencies.KindAndKey(DataModel.FEATURES, "flag3"), new DataModelDependencies.KindAndKey(DataModel.FEATURES, "flag2"));
        this.verifyAffectedItems(dt, DataModel.FEATURES, "flag4", new DataModelDependencies.KindAndKey(DataModel.FEATURES, "flag4"), new DataModelDependencies.KindAndKey(DataModel.FEATURES, "flag1"));
    }

    @Test
    public void dependencyTrackerResetsGraph() {
        DataModelDependencies.DependencyTracker dt = new DataModelDependencies.DependencyTracker();
        DataModel.FeatureFlag flag1 = ModelBuilders.flagBuilder("flag1").prerequisites(ModelBuilders.prerequisite("flag3", 0)).build();
        dt.updateDependenciesFrom(DataModel.FEATURES, flag1.getKey(), new DataStoreTypes.ItemDescriptor(flag1.getVersion(), (Object)flag1));
        this.verifyAffectedItems(dt, DataModel.FEATURES, "flag3", new DataModelDependencies.KindAndKey(DataModel.FEATURES, "flag3"), new DataModelDependencies.KindAndKey(DataModel.FEATURES, "flag1"));
        dt.reset();
        this.verifyAffectedItems(dt, DataModel.FEATURES, "flag3", new DataModelDependencies.KindAndKey(DataModel.FEATURES, "flag3"));
    }

    private void verifyAffectedItems(DataModelDependencies.DependencyTracker dt, DataStoreTypes.DataKind kind, String key, DataModelDependencies.KindAndKey ... expected) {
        HashSet result = new HashSet();
        dt.addAffectedItems(result, new DataModelDependencies.KindAndKey(kind, key));
        MatcherAssert.assertThat(result, (Matcher)Matchers.equalTo((Object)ImmutableSet.copyOf((Object[])expected)));
    }

    @Test
    public void kindAndKeyEquality() {
        DataModelDependencies.KindAndKey kk1 = new DataModelDependencies.KindAndKey(DataModel.FEATURES, "key1");
        DataModelDependencies.KindAndKey kk2 = new DataModelDependencies.KindAndKey(DataModel.FEATURES, "key1");
        MatcherAssert.assertThat((Object)kk1, (Matcher)Matchers.equalTo((Object)kk2));
        MatcherAssert.assertThat((Object)kk2, (Matcher)Matchers.equalTo((Object)kk1));
        MatcherAssert.assertThat((Object)kk1.hashCode(), (Matcher)Matchers.equalTo((Object)kk2.hashCode()));
        DataModelDependencies.KindAndKey kk3 = new DataModelDependencies.KindAndKey(DataModel.FEATURES, "key2");
        MatcherAssert.assertThat((Object)kk3, (Matcher)Matchers.not((Matcher)Matchers.equalTo((Object)kk1)));
        MatcherAssert.assertThat((Object)kk1, (Matcher)Matchers.not((Matcher)Matchers.equalTo((Object)kk3)));
        DataModelDependencies.KindAndKey kk4 = new DataModelDependencies.KindAndKey(DataModel.SEGMENTS, "key1");
        MatcherAssert.assertThat((Object)kk4, (Matcher)Matchers.not((Matcher)Matchers.equalTo((Object)kk1)));
        MatcherAssert.assertThat((Object)kk1, (Matcher)Matchers.not((Matcher)Matchers.equalTo((Object)kk4)));
        MatcherAssert.assertThat((Object)kk1, (Matcher)Matchers.not((Matcher)Matchers.equalTo(null)));
        MatcherAssert.assertThat((Object)kk1, (Matcher)Matchers.not((Matcher)Matchers.equalTo((Object)"x")));
    }
}

