/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.sdk.server;

import com.launchdarkly.logging.LDLogger;
import com.launchdarkly.sdk.server.DataModel;
import com.launchdarkly.sdk.server.DataModelDependenciesTest;
import com.launchdarkly.sdk.server.DataSourceUpdatesImpl;
import com.launchdarkly.sdk.server.DataStoreTestTypes;
import com.launchdarkly.sdk.server.EventBroadcasterImpl;
import com.launchdarkly.sdk.server.ModelBuilders;
import com.launchdarkly.sdk.server.TestComponents;
import com.launchdarkly.sdk.server.TestUtil;
import com.launchdarkly.sdk.server.interfaces.DataSourceStatusProvider;
import com.launchdarkly.sdk.server.interfaces.FlagChangeEvent;
import com.launchdarkly.sdk.server.interfaces.FlagChangeListener;
import com.launchdarkly.sdk.server.subsystems.DataStore;
import com.launchdarkly.sdk.server.subsystems.DataStoreTypes;
import com.launchdarkly.testhelpers.ConcurrentHelpers;
import java.io.IOException;
import java.time.Duration;
import java.time.Instant;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.easymock.Capture;
import org.easymock.EasyMock;
import org.easymock.EasyMockSupport;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Test;

public class DataSourceUpdatesImplTest {
    private final EventBroadcasterImpl<FlagChangeListener, FlagChangeEvent> flagChangeBroadcaster = EventBroadcasterImpl.forFlagChangeEvents((ExecutorService)TestComponents.sharedExecutor, (LDLogger)TestComponents.nullLogger);
    private final EasyMockSupport mocks = new EasyMockSupport();

    private DataSourceUpdatesImpl makeInstance(DataStore store) {
        return this.makeInstance(store, null);
    }

    private DataSourceUpdatesImpl makeInstance(DataStore store, EventBroadcasterImpl<DataSourceStatusProvider.StatusListener, DataSourceStatusProvider.Status> statusBroadcaster) {
        return new DataSourceUpdatesImpl(store, null, this.flagChangeBroadcaster, statusBroadcaster, TestComponents.sharedExecutor, null, TestComponents.nullLogger);
    }

    @Test
    public void sendsEventsOnInitForNewlyAddedFlags() throws Exception {
        DataStore store = TestComponents.inMemoryDataStore();
        DataStoreTestTypes.DataBuilder builder = new DataStoreTestTypes.DataBuilder().addAny(DataModel.FEATURES, new DataModel.VersionedData[]{ModelBuilders.flagBuilder("flag1").version(1).build()}).addAny(DataModel.SEGMENTS, new DataModel.VersionedData[]{ModelBuilders.segmentBuilder("segment1").version(1).build()});
        DataSourceUpdatesImpl storeUpdates = this.makeInstance(store);
        storeUpdates.init(builder.build());
        LinkedBlockingQueue eventSink = new LinkedBlockingQueue();
        this.flagChangeBroadcaster.register(eventSink::add);
        builder.addAny(DataModel.FEATURES, new DataModel.VersionedData[]{ModelBuilders.flagBuilder("flag2").version(1).build()}).addAny(DataModel.SEGMENTS, new DataModel.VersionedData[]{ModelBuilders.segmentBuilder("segment2").version(1).build()});
        storeUpdates.init(builder.build());
        TestUtil.expectEvents(eventSink, "flag2");
    }

    @Test
    public void sendsEventOnUpdateForNewlyAddedFlag() throws Exception {
        DataStore store = TestComponents.inMemoryDataStore();
        DataStoreTestTypes.DataBuilder builder = new DataStoreTestTypes.DataBuilder().addAny(DataModel.FEATURES, new DataModel.VersionedData[]{ModelBuilders.flagBuilder("flag1").version(1).build()}).addAny(DataModel.SEGMENTS, new DataModel.VersionedData[]{ModelBuilders.segmentBuilder("segment1").version(1).build()});
        DataSourceUpdatesImpl storeUpdates = this.makeInstance(store);
        storeUpdates.init(builder.build());
        LinkedBlockingQueue eventSink = new LinkedBlockingQueue();
        this.flagChangeBroadcaster.register(eventSink::add);
        storeUpdates.upsert(DataModel.FEATURES, "flag2", new DataStoreTypes.ItemDescriptor(1, (Object)ModelBuilders.flagBuilder("flag2").version(1).build()));
        TestUtil.expectEvents(eventSink, "flag2");
    }

    @Test
    public void sendsEventsOnInitForUpdatedFlags() throws Exception {
        DataStore store = TestComponents.inMemoryDataStore();
        DataStoreTestTypes.DataBuilder builder = new DataStoreTestTypes.DataBuilder().addAny(DataModel.FEATURES, new DataModel.VersionedData[]{ModelBuilders.flagBuilder("flag1").version(1).build(), ModelBuilders.flagBuilder("flag2").version(1).build()}).addAny(DataModel.SEGMENTS, new DataModel.VersionedData[]{ModelBuilders.segmentBuilder("segment1").version(1).build(), ModelBuilders.segmentBuilder("segment2").version(1).build()});
        DataSourceUpdatesImpl storeUpdates = this.makeInstance(store);
        storeUpdates.init(builder.build());
        LinkedBlockingQueue eventSink = new LinkedBlockingQueue();
        this.flagChangeBroadcaster.register(eventSink::add);
        builder.addAny(DataModel.FEATURES, new DataModel.VersionedData[]{ModelBuilders.flagBuilder("flag2").version(2).build()}).addAny(DataModel.SEGMENTS, new DataModel.VersionedData[]{ModelBuilders.segmentBuilder("segment2").version(2).build()});
        storeUpdates.init(builder.build());
        TestUtil.expectEvents(eventSink, "flag2");
    }

    @Test
    public void sendsEventOnUpdateForUpdatedFlag() throws Exception {
        DataStore store = TestComponents.inMemoryDataStore();
        DataStoreTestTypes.DataBuilder builder = new DataStoreTestTypes.DataBuilder().addAny(DataModel.FEATURES, new DataModel.VersionedData[]{ModelBuilders.flagBuilder("flag1").version(1).build(), ModelBuilders.flagBuilder("flag2").version(1).build()}).addAny(DataModel.SEGMENTS, new DataModel.VersionedData[]{ModelBuilders.segmentBuilder("segment1").version(1).build()});
        DataSourceUpdatesImpl storeUpdates = this.makeInstance(store);
        storeUpdates.init(builder.build());
        LinkedBlockingQueue eventSink = new LinkedBlockingQueue();
        this.flagChangeBroadcaster.register(eventSink::add);
        storeUpdates.upsert(DataModel.FEATURES, "flag2", new DataStoreTypes.ItemDescriptor(2, (Object)ModelBuilders.flagBuilder("flag2").version(2).build()));
        TestUtil.expectEvents(eventSink, "flag2");
    }

    @Test
    public void doesNotSendsEventOnUpdateIfItemWasNotReallyUpdated() throws Exception {
        DataStore store = TestComponents.inMemoryDataStore();
        DataModel.FeatureFlag flag1 = ModelBuilders.flagBuilder("flag1").version(1).build();
        DataModel.FeatureFlag flag2 = ModelBuilders.flagBuilder("flag2").version(1).build();
        DataStoreTestTypes.DataBuilder builder = new DataStoreTestTypes.DataBuilder().addAny(DataModel.FEATURES, new DataModel.VersionedData[]{flag1, flag2});
        DataSourceUpdatesImpl storeUpdates = this.makeInstance(store);
        storeUpdates.init(builder.build());
        LinkedBlockingQueue eventSink = new LinkedBlockingQueue();
        this.flagChangeBroadcaster.register(eventSink::add);
        storeUpdates.upsert(DataModel.FEATURES, flag2.getKey(), new DataStoreTypes.ItemDescriptor(flag2.getVersion(), (Object)flag2));
        ConcurrentHelpers.assertNoMoreValues(eventSink, (long)100L, (TimeUnit)TimeUnit.MILLISECONDS);
    }

    @Test
    public void sendsEventsOnInitForDeletedFlags() throws Exception {
        DataStore store = TestComponents.inMemoryDataStore();
        DataStoreTestTypes.DataBuilder builder = new DataStoreTestTypes.DataBuilder().addAny(DataModel.FEATURES, new DataModel.VersionedData[]{ModelBuilders.flagBuilder("flag1").version(1).build(), ModelBuilders.flagBuilder("flag2").version(1).build()}).addAny(DataModel.SEGMENTS, new DataModel.VersionedData[]{ModelBuilders.segmentBuilder("segment1").version(1).build()});
        DataSourceUpdatesImpl storeUpdates = this.makeInstance(store);
        storeUpdates.init(builder.build());
        LinkedBlockingQueue eventSink = new LinkedBlockingQueue();
        this.flagChangeBroadcaster.register(eventSink::add);
        builder.remove(DataModel.FEATURES, "flag2");
        builder.remove(DataModel.SEGMENTS, "segment1");
        storeUpdates.init(builder.build());
        TestUtil.expectEvents(eventSink, "flag2");
    }

    @Test
    public void sendsEventOnUpdateForDeletedFlag() throws Exception {
        DataStore store = TestComponents.inMemoryDataStore();
        DataStoreTestTypes.DataBuilder builder = new DataStoreTestTypes.DataBuilder().addAny(DataModel.FEATURES, new DataModel.VersionedData[]{ModelBuilders.flagBuilder("flag1").version(1).build(), ModelBuilders.flagBuilder("flag2").version(1).build()}).addAny(DataModel.SEGMENTS, new DataModel.VersionedData[]{ModelBuilders.segmentBuilder("segment1").version(1).build()});
        DataSourceUpdatesImpl storeUpdates = this.makeInstance(store);
        storeUpdates.init(builder.build());
        LinkedBlockingQueue events = new LinkedBlockingQueue();
        this.flagChangeBroadcaster.register(events::add);
        storeUpdates.upsert(DataModel.FEATURES, "flag2", DataStoreTypes.ItemDescriptor.deletedItem((int)2));
        TestUtil.expectEvents(events, "flag2");
    }

    @Test
    public void sendsEventsOnInitForFlagsWhosePrerequisitesChanged() throws Exception {
        DataStore store = TestComponents.inMemoryDataStore();
        DataStoreTestTypes.DataBuilder builder = new DataStoreTestTypes.DataBuilder().addAny(DataModel.FEATURES, new DataModel.VersionedData[]{ModelBuilders.flagBuilder("flag1").version(1).build(), ModelBuilders.flagBuilder("flag2").version(1).prerequisites(ModelBuilders.prerequisite("flag1", 0)).build(), ModelBuilders.flagBuilder("flag3").version(1).build(), ModelBuilders.flagBuilder("flag4").version(1).prerequisites(ModelBuilders.prerequisite("flag1", 0)).build(), ModelBuilders.flagBuilder("flag5").version(1).prerequisites(ModelBuilders.prerequisite("flag4", 0)).build(), ModelBuilders.flagBuilder("flag6").version(1).build()});
        DataSourceUpdatesImpl storeUpdates = this.makeInstance(store);
        storeUpdates.init(builder.build());
        LinkedBlockingQueue eventSink = new LinkedBlockingQueue();
        this.flagChangeBroadcaster.register(eventSink::add);
        builder.addAny(DataModel.FEATURES, new DataModel.VersionedData[]{ModelBuilders.flagBuilder("flag1").version(2).build()});
        storeUpdates.init(builder.build());
        TestUtil.expectEvents(eventSink, "flag1", "flag2", "flag4", "flag5");
    }

    @Test
    public void sendsEventsOnUpdateForFlagsWhosePrerequisitesChanged() throws Exception {
        DataStore store = TestComponents.inMemoryDataStore();
        DataStoreTestTypes.DataBuilder builder = new DataStoreTestTypes.DataBuilder().addAny(DataModel.FEATURES, new DataModel.VersionedData[]{ModelBuilders.flagBuilder("flag1").version(1).build(), ModelBuilders.flagBuilder("flag2").version(1).prerequisites(ModelBuilders.prerequisite("flag1", 0)).build(), ModelBuilders.flagBuilder("flag3").version(1).build(), ModelBuilders.flagBuilder("flag4").version(1).prerequisites(ModelBuilders.prerequisite("flag1", 0)).build(), ModelBuilders.flagBuilder("flag5").version(1).prerequisites(ModelBuilders.prerequisite("flag4", 0)).build(), ModelBuilders.flagBuilder("flag6").version(1).build()});
        DataSourceUpdatesImpl storeUpdates = this.makeInstance(store);
        storeUpdates.init(builder.build());
        LinkedBlockingQueue eventSink = new LinkedBlockingQueue();
        this.flagChangeBroadcaster.register(eventSink::add);
        storeUpdates.upsert(DataModel.FEATURES, "flag1", new DataStoreTypes.ItemDescriptor(2, (Object)ModelBuilders.flagBuilder("flag1").version(2).build()));
        TestUtil.expectEvents(eventSink, "flag1", "flag2", "flag4", "flag5");
    }

    @Test
    public void sendsEventsOnInitForFlagsWhoseSegmentsChanged() throws Exception {
        DataStore store = TestComponents.inMemoryDataStore();
        DataStoreTestTypes.DataBuilder builder = new DataStoreTestTypes.DataBuilder().addAny(DataModel.FEATURES, new DataModel.VersionedData[]{ModelBuilders.flagBuilder("flag1").version(1).build(), ModelBuilders.flagBuilder("flag2").version(1).rules(ModelBuilders.ruleBuilder().clauses(ModelBuilders.clauseMatchingSegment("segment1")).build()).build(), ModelBuilders.flagBuilder("flag3").version(1).build(), ModelBuilders.flagBuilder("flag4").version(1).prerequisites(ModelBuilders.prerequisite("flag2", 0)).build()}).addAny(DataModel.SEGMENTS, new DataModel.VersionedData[]{ModelBuilders.segmentBuilder("segment1").version(1).build(), ModelBuilders.segmentBuilder("segment2").version(1).build()});
        DataSourceUpdatesImpl storeUpdates = this.makeInstance(store);
        storeUpdates.init(builder.build());
        LinkedBlockingQueue eventSink = new LinkedBlockingQueue();
        this.flagChangeBroadcaster.register(eventSink::add);
        storeUpdates.upsert(DataModel.SEGMENTS, "segment1", new DataStoreTypes.ItemDescriptor(2, (Object)ModelBuilders.segmentBuilder("segment1").version(2).build()));
        TestUtil.expectEvents(eventSink, "flag2", "flag4");
    }

    @Test
    public void sendsEventsOnUpdateForFlagsWhoseSegmentsChanged() throws Exception {
        DataStore store = TestComponents.inMemoryDataStore();
        DataStoreTestTypes.DataBuilder builder = new DataStoreTestTypes.DataBuilder().addAny(DataModel.FEATURES, new DataModel.VersionedData[]{ModelBuilders.flagBuilder("flag1").version(1).build(), ModelBuilders.flagBuilder("flag2").version(1).rules(ModelBuilders.ruleBuilder().clauses(ModelBuilders.clauseMatchingSegment("segment1")).build()).build(), ModelBuilders.flagBuilder("flag3").version(1).build(), ModelBuilders.flagBuilder("flag4").version(1).prerequisites(ModelBuilders.prerequisite("flag2", 0)).build()}).addAny(DataModel.SEGMENTS, new DataModel.VersionedData[]{ModelBuilders.segmentBuilder("segment1").version(1).build(), ModelBuilders.segmentBuilder("segment2").version(1).build()});
        DataSourceUpdatesImpl storeUpdates = this.makeInstance(store);
        storeUpdates.init(builder.build());
        LinkedBlockingQueue eventSink = new LinkedBlockingQueue();
        this.flagChangeBroadcaster.register(eventSink::add);
        builder.addAny(DataModel.SEGMENTS, new DataModel.VersionedData[]{ModelBuilders.segmentBuilder("segment1").version(2).build()});
        storeUpdates.init(builder.build());
        TestUtil.expectEvents(eventSink, "flag2", "flag4");
    }

    @Test
    public void dataSetIsPassedToDataStoreInCorrectOrder() throws Exception {
        Capture captureData = Capture.newInstance();
        DataStore store = (DataStore)this.mocks.createStrictMock(DataStore.class);
        store.init((DataStoreTypes.FullDataSet)EasyMock.capture((Capture)captureData));
        EasyMock.replay((Object[])new Object[]{store});
        DataSourceUpdatesImpl storeUpdates = this.makeInstance(store);
        storeUpdates.init(DataModelDependenciesTest.DEPENDENCY_ORDERING_TEST_DATA);
        DataModelDependenciesTest.verifySortedData((DataStoreTypes.FullDataSet<DataStoreTypes.ItemDescriptor>)((DataStoreTypes.FullDataSet)captureData.getValue()), DataModelDependenciesTest.DEPENDENCY_ORDERING_TEST_DATA);
    }

    @Test
    public void updateStatusBroadcastsNewStatus() {
        EventBroadcasterImpl broadcaster = EventBroadcasterImpl.forDataSourceStatus((ExecutorService)TestComponents.sharedExecutor, (LDLogger)TestComponents.nullLogger);
        DataSourceUpdatesImpl updates = this.makeInstance(TestComponents.inMemoryDataStore(), (EventBroadcasterImpl<DataSourceStatusProvider.StatusListener, DataSourceStatusProvider.Status>)broadcaster);
        LinkedBlockingQueue statuses = new LinkedBlockingQueue();
        broadcaster.register(statuses::add);
        Instant timeBeforeUpdate = Instant.now();
        DataSourceStatusProvider.ErrorInfo errorInfo = DataSourceStatusProvider.ErrorInfo.fromHttpError((int)401);
        updates.updateStatus(DataSourceStatusProvider.State.OFF, errorInfo);
        DataSourceStatusProvider.Status status = (DataSourceStatusProvider.Status)ConcurrentHelpers.awaitValue(statuses, (long)500L, (TimeUnit)TimeUnit.MILLISECONDS);
        MatcherAssert.assertThat((Object)status.getState(), (Matcher)Matchers.is((Object)DataSourceStatusProvider.State.OFF));
        MatcherAssert.assertThat((Object)status.getStateSince(), (Matcher)Matchers.greaterThanOrEqualTo((Comparable)timeBeforeUpdate));
        MatcherAssert.assertThat((Object)status.getLastError(), (Matcher)Matchers.is((Object)errorInfo));
    }

    @Test
    public void updateStatusKeepsStateUnchangedIfStateWasInitializingAndNewStateIsInterrupted() {
        EventBroadcasterImpl broadcaster = EventBroadcasterImpl.forDataSourceStatus((ExecutorService)TestComponents.sharedExecutor, (LDLogger)TestComponents.nullLogger);
        DataSourceUpdatesImpl updates = this.makeInstance(TestComponents.inMemoryDataStore(), (EventBroadcasterImpl<DataSourceStatusProvider.StatusListener, DataSourceStatusProvider.Status>)broadcaster);
        MatcherAssert.assertThat((Object)updates.getLastStatus().getState(), (Matcher)Matchers.is((Object)DataSourceStatusProvider.State.INITIALIZING));
        Instant originalTime = updates.getLastStatus().getStateSince();
        LinkedBlockingQueue statuses = new LinkedBlockingQueue();
        broadcaster.register(statuses::add);
        DataSourceStatusProvider.ErrorInfo errorInfo = DataSourceStatusProvider.ErrorInfo.fromHttpError((int)401);
        updates.updateStatus(DataSourceStatusProvider.State.INTERRUPTED, errorInfo);
        DataSourceStatusProvider.Status status = (DataSourceStatusProvider.Status)ConcurrentHelpers.awaitValue(statuses, (long)500L, (TimeUnit)TimeUnit.MILLISECONDS);
        MatcherAssert.assertThat((Object)status.getState(), (Matcher)Matchers.is((Object)DataSourceStatusProvider.State.INITIALIZING));
        MatcherAssert.assertThat((Object)status.getStateSince(), (Matcher)Matchers.is((Object)originalTime));
        MatcherAssert.assertThat((Object)status.getLastError(), (Matcher)Matchers.is((Object)errorInfo));
    }

    @Test
    public void updateStatusDoesNothingIfParametersHaveNoNewData() {
        EventBroadcasterImpl broadcaster = EventBroadcasterImpl.forDataSourceStatus((ExecutorService)TestComponents.sharedExecutor, (LDLogger)TestComponents.nullLogger);
        DataSourceUpdatesImpl updates = this.makeInstance(TestComponents.inMemoryDataStore(), (EventBroadcasterImpl<DataSourceStatusProvider.StatusListener, DataSourceStatusProvider.Status>)broadcaster);
        LinkedBlockingQueue statuses = new LinkedBlockingQueue();
        broadcaster.register(statuses::add);
        updates.updateStatus(null, null);
        updates.updateStatus(DataSourceStatusProvider.State.INITIALIZING, null);
        ConcurrentHelpers.assertNoMoreValues(statuses, (long)100L, (TimeUnit)TimeUnit.MILLISECONDS);
    }

    @Test
    public void outageTimeoutLogging() throws Exception {
        LinkedBlockingQueue outageErrors = new LinkedBlockingQueue();
        Duration outageTimeout = Duration.ofMillis(100L);
        DataSourceUpdatesImpl updates = new DataSourceUpdatesImpl(TestComponents.inMemoryDataStore(), null, this.flagChangeBroadcaster, EventBroadcasterImpl.forDataSourceStatus((ExecutorService)TestComponents.sharedExecutor, (LDLogger)TestComponents.nullLogger), TestComponents.sharedExecutor, outageTimeout, TestComponents.nullLogger);
        updates.onOutageErrorLog = outageErrors::add;
        updates.updateStatus(DataSourceStatusProvider.State.INTERRUPTED, DataSourceStatusProvider.ErrorInfo.fromHttpError((int)500));
        updates.updateStatus(DataSourceStatusProvider.State.VALID, null);
        ConcurrentHelpers.assertNoMoreValues(outageErrors, (long)outageTimeout.plus(Duration.ofMillis(20L)).toMillis(), (TimeUnit)TimeUnit.MILLISECONDS);
        updates.updateStatus(DataSourceStatusProvider.State.INTERRUPTED, DataSourceStatusProvider.ErrorInfo.fromHttpError((int)501));
        updates.updateStatus(DataSourceStatusProvider.State.INTERRUPTED, DataSourceStatusProvider.ErrorInfo.fromHttpError((int)502));
        updates.updateStatus(DataSourceStatusProvider.State.INTERRUPTED, DataSourceStatusProvider.ErrorInfo.fromException((DataSourceStatusProvider.ErrorKind)DataSourceStatusProvider.ErrorKind.NETWORK_ERROR, (Throwable)new IOException("x")));
        updates.updateStatus(DataSourceStatusProvider.State.INTERRUPTED, DataSourceStatusProvider.ErrorInfo.fromHttpError((int)501));
        String errorsDesc = (String)ConcurrentHelpers.awaitValue(outageErrors, (long)250L, (TimeUnit)TimeUnit.MILLISECONDS);
        MatcherAssert.assertThat((Object)errorsDesc, (Matcher)Matchers.containsString((String)"NETWORK_ERROR (1 time)"));
        MatcherAssert.assertThat((Object)errorsDesc, (Matcher)Matchers.containsString((String)"ERROR_RESPONSE(501) (2 times)"));
        MatcherAssert.assertThat((Object)errorsDesc, (Matcher)Matchers.containsString((String)"ERROR_RESPONSE(502) (1 time)"));
    }
}

