/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.sdk.server;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.launchdarkly.sdk.LDValue;
import com.launchdarkly.sdk.ObjectBuilder;
import com.launchdarkly.sdk.server.DataModel;
import com.launchdarkly.sdk.server.TestUtil;
import com.launchdarkly.sdk.server.subsystems.DataStoreTypes;
import java.util.AbstractMap;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;

public class DataStoreTestTypes {
    public static final DataStoreTypes.DataKind TEST_ITEMS = new DataStoreTypes.DataKind("test-items", DataStoreTestTypes::serializeTestItem, DataStoreTestTypes::deserializeTestItem);
    public static final DataStoreTypes.DataKind OTHER_TEST_ITEMS = new DataStoreTypes.DataKind("other-test-items", DataStoreTestTypes::serializeTestItem, DataStoreTestTypes::deserializeTestItem);

    public static <T> Map<DataStoreTypes.DataKind, Map<String, T>> toDataMap(DataStoreTypes.FullDataSet<T> data) {
        return ImmutableMap.copyOf((Iterable)Iterables.transform((Iterable)data.getData(), e -> new AbstractMap.SimpleEntry((DataStoreTypes.DataKind)e.getKey(), DataStoreTestTypes.toItemsMap((DataStoreTypes.KeyedItems)e.getValue()))));
    }

    public static <T> Map<String, T> toItemsMap(DataStoreTypes.KeyedItems<T> data) {
        return ImmutableMap.copyOf((Iterable)data.getItems());
    }

    public static DataStoreTypes.SerializedItemDescriptor toSerialized(DataStoreTypes.DataKind kind, DataStoreTypes.ItemDescriptor item) {
        boolean isDeleted = item.getItem() == null;
        return new DataStoreTypes.SerializedItemDescriptor(item.getVersion(), isDeleted, kind.serialize(item));
    }

    private static String serializeTestItem(DataStoreTypes.ItemDescriptor item) {
        if (item.getItem() == null) {
            return "DELETED:" + item.getVersion();
        }
        return TestUtil.TEST_GSON_INSTANCE.toJson(item.getItem());
    }

    private static DataStoreTypes.ItemDescriptor deserializeTestItem(String s) {
        if (s.startsWith("DELETED:")) {
            return DataStoreTypes.ItemDescriptor.deletedItem((int)Integer.parseInt(s.substring(8)));
        }
        TestItem ti = (TestItem)TestUtil.TEST_GSON_INSTANCE.fromJson(s, TestItem.class);
        return new DataStoreTypes.ItemDescriptor(ti.version, (Object)ti);
    }

    public static class DataBuilder {
        private Map<DataStoreTypes.DataKind, Map<String, DataStoreTypes.ItemDescriptor>> data = new HashMap<DataStoreTypes.DataKind, Map<String, DataStoreTypes.ItemDescriptor>>();

        public static DataBuilder forStandardTypes() {
            DataBuilder ret = new DataBuilder();
            ret.add(DataModel.FEATURES, new TestItem[0]);
            ret.add(DataModel.SEGMENTS, new TestItem[0]);
            return ret;
        }

        public DataBuilder add(DataStoreTypes.DataKind kind, TestItem ... items) {
            return this.addAny(kind, items);
        }

        public DataBuilder addAny(DataStoreTypes.DataKind kind, DataModel.VersionedData ... items) {
            Map<String, DataStoreTypes.ItemDescriptor> itemsMap = this.data.get(kind);
            if (itemsMap == null) {
                itemsMap = new LinkedHashMap<String, DataStoreTypes.ItemDescriptor>();
                this.data.put(kind, itemsMap);
            }
            for (DataModel.VersionedData item : items) {
                itemsMap.put(item.getKey(), new DataStoreTypes.ItemDescriptor(item.getVersion(), (Object)item));
            }
            return this;
        }

        public DataBuilder remove(DataStoreTypes.DataKind kind, String key) {
            if (this.data.get(kind) != null) {
                this.data.get(kind).remove(key);
            }
            return this;
        }

        public DataStoreTypes.FullDataSet<DataStoreTypes.ItemDescriptor> build() {
            return new DataStoreTypes.FullDataSet((Iterable)ImmutableMap.copyOf((Map)Maps.transformValues(this.data, itemsMap -> new DataStoreTypes.KeyedItems((Iterable)ImmutableList.copyOf(itemsMap.entrySet())))).entrySet());
        }

        public DataStoreTypes.FullDataSet<DataStoreTypes.SerializedItemDescriptor> buildSerialized() {
            return new DataStoreTypes.FullDataSet((Iterable)ImmutableMap.copyOf((Map)Maps.transformEntries(this.data, (kind, itemsMap) -> new DataStoreTypes.KeyedItems((Iterable)ImmutableMap.copyOf((Map)Maps.transformValues((Map)itemsMap, item -> DataStoreTestTypes.toSerialized(kind, item))).entrySet()))).entrySet());
        }

        public LDValue buildJson() {
            DataStoreTypes.FullDataSet<DataStoreTypes.SerializedItemDescriptor> allData = this.buildSerialized();
            ObjectBuilder allBuilder = LDValue.buildObject();
            for (Map.Entry coll : allData.getData()) {
                String namespace = ((DataStoreTypes.DataKind)coll.getKey()).getName().equals("features") ? "flags" : ((DataStoreTypes.DataKind)coll.getKey()).getName();
                ObjectBuilder itemsBuilder = LDValue.buildObject();
                for (Map.Entry item : ((DataStoreTypes.KeyedItems)coll.getValue()).getItems()) {
                    itemsBuilder.put((String)item.getKey(), LDValue.parse((String)((DataStoreTypes.SerializedItemDescriptor)item.getValue()).getSerializedItem()));
                }
                allBuilder.put(namespace, itemsBuilder.build());
            }
            return allBuilder.build();
        }
    }

    public static class TestItem
    implements DataModel.VersionedData {
        public final String key;
        public final String name;
        public final int version;
        public final boolean deleted;

        public TestItem(String key, String name, int version, boolean deleted) {
            this.key = key;
            this.name = name;
            this.version = version;
            this.deleted = deleted;
        }

        public TestItem(String key, String name, int version) {
            this(key, name, version, false);
        }

        public TestItem(String key, int version) {
            this(key, "", version);
        }

        public String getKey() {
            return this.key;
        }

        public int getVersion() {
            return this.version;
        }

        public boolean isDeleted() {
            return this.deleted;
        }

        public TestItem withName(String newName) {
            return new TestItem(this.key, newName, this.version);
        }

        public TestItem withVersion(int newVersion) {
            return new TestItem(this.key, this.name, newVersion);
        }

        public DataStoreTypes.ItemDescriptor toItemDescriptor() {
            return new DataStoreTypes.ItemDescriptor(this.version, (Object)this);
        }

        public Map.Entry<String, DataStoreTypes.ItemDescriptor> toKeyedItemDescriptor() {
            return new AbstractMap.SimpleEntry<String, DataStoreTypes.ItemDescriptor>(this.key, this.toItemDescriptor());
        }

        public DataStoreTypes.SerializedItemDescriptor toSerializedItemDescriptor() {
            return DataStoreTestTypes.toSerialized(TEST_ITEMS, this.toItemDescriptor());
        }

        public boolean equals(Object other) {
            if (other instanceof TestItem) {
                TestItem o = (TestItem)other;
                return Objects.equals(this.name, o.name) && Objects.equals(this.key, o.key) && this.version == o.version;
            }
            return false;
        }

        public int hashCode() {
            return Objects.hash(this.name, this.key, this.version);
        }

        public String toString() {
            return "TestItem(" + this.name + "," + this.key + "," + this.version + ")";
        }
    }
}

