/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.sdk.server;

import com.launchdarkly.sdk.server.BaseTest;
import com.launchdarkly.sdk.server.EventBroadcasterImpl;
import com.launchdarkly.sdk.server.TestComponents;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Test;

public class EventBroadcasterImplTest
extends BaseTest {
    private EventBroadcasterImpl<FakeListener, FakeEvent> broadcaster;

    public EventBroadcasterImplTest() {
        this.broadcaster = new EventBroadcasterImpl(FakeListener::sendEvent, (ExecutorService)TestComponents.sharedExecutor, this.testLogger);
    }

    @Test
    public void sendingEventWithNoListenersDoesNotCauseError() {
        this.broadcaster.broadcast((Object)new FakeEvent());
    }

    @Test
    public void sendingEventWithNoExecutorDoesNotCauseError() {
        new EventBroadcasterImpl(FakeListener::sendEvent, null, this.testLogger).broadcast((Object)new FakeEvent());
    }

    @Test
    public void hasListeners() {
        MatcherAssert.assertThat((Object)this.broadcaster.hasListeners(), (Matcher)Matchers.is((Object)false));
        FakeListener listener1 = e -> {};
        FakeListener listener2 = e -> {};
        this.broadcaster.register((Object)listener1);
        this.broadcaster.register((Object)listener2);
        MatcherAssert.assertThat((Object)this.broadcaster.hasListeners(), (Matcher)Matchers.is((Object)true));
        this.broadcaster.unregister((Object)listener1);
        MatcherAssert.assertThat((Object)this.broadcaster.hasListeners(), (Matcher)Matchers.is((Object)true));
        this.broadcaster.unregister((Object)listener2);
        MatcherAssert.assertThat((Object)this.broadcaster.hasListeners(), (Matcher)Matchers.is((Object)false));
    }

    @Test
    public void allListenersReceiveEvent() throws Exception {
        LinkedBlockingQueue events1 = new LinkedBlockingQueue();
        LinkedBlockingQueue events2 = new LinkedBlockingQueue();
        FakeListener listener1 = events1::add;
        FakeListener listener2 = events2::add;
        this.broadcaster.register((Object)listener1);
        this.broadcaster.register((Object)listener2);
        FakeEvent e1 = new FakeEvent();
        FakeEvent e2 = new FakeEvent();
        this.broadcaster.broadcast((Object)e1);
        this.broadcaster.broadcast((Object)e2);
        MatcherAssert.assertThat((Object)((FakeEvent)events1.take()), (Matcher)Matchers.is((Object)e1));
        MatcherAssert.assertThat((Object)((FakeEvent)events1.take()), (Matcher)Matchers.is((Object)e2));
        MatcherAssert.assertThat((Object)events1.isEmpty(), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)((FakeEvent)events2.take()), (Matcher)Matchers.is((Object)e1));
        MatcherAssert.assertThat((Object)((FakeEvent)events2.take()), (Matcher)Matchers.is((Object)e2));
        MatcherAssert.assertThat((Object)events2.isEmpty(), (Matcher)Matchers.is((Object)true));
    }

    @Test
    public void canUnregisterListener() throws Exception {
        LinkedBlockingQueue events1 = new LinkedBlockingQueue();
        LinkedBlockingQueue events2 = new LinkedBlockingQueue();
        FakeListener listener1 = events1::add;
        FakeListener listener2 = events2::add;
        this.broadcaster.register((Object)listener1);
        this.broadcaster.register((Object)listener2);
        FakeEvent e1 = new FakeEvent();
        FakeEvent e2 = new FakeEvent();
        FakeEvent e3 = new FakeEvent();
        this.broadcaster.broadcast((Object)e1);
        this.broadcaster.unregister((Object)listener2);
        this.broadcaster.broadcast((Object)e2);
        this.broadcaster.register((Object)listener2);
        this.broadcaster.broadcast((Object)e3);
        MatcherAssert.assertThat((Object)((FakeEvent)events1.take()), (Matcher)Matchers.is((Object)e1));
        MatcherAssert.assertThat((Object)((FakeEvent)events1.take()), (Matcher)Matchers.is((Object)e2));
        MatcherAssert.assertThat((Object)((FakeEvent)events1.take()), (Matcher)Matchers.is((Object)e3));
        MatcherAssert.assertThat((Object)events1.isEmpty(), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)((FakeEvent)events2.take()), (Matcher)Matchers.is((Object)e1));
        MatcherAssert.assertThat((Object)((FakeEvent)events2.take()), (Matcher)Matchers.is((Object)e3));
        MatcherAssert.assertThat((Object)events2.isEmpty(), (Matcher)Matchers.is((Object)true));
    }

    @Test
    public void exceptionFromEarlierListenerDoesNotInterfereWithLaterListener() throws Exception {
        FakeListener listener1 = e -> {
            throw new RuntimeException("sorry");
        };
        this.broadcaster.register((Object)listener1);
        LinkedBlockingQueue events2 = new LinkedBlockingQueue();
        FakeListener listener2 = events2::add;
        this.broadcaster.register((Object)listener2);
        FakeEvent e2 = new FakeEvent();
        this.broadcaster.broadcast((Object)e2);
        MatcherAssert.assertThat((Object)((FakeEvent)events2.take()), (Matcher)Matchers.is((Object)e2));
    }

    static interface FakeListener {
        public void sendEvent(FakeEvent var1);
    }

    static class FakeEvent {
        FakeEvent() {
        }
    }
}

