/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.sdk.server;

import com.google.gson.Gson;
import com.launchdarkly.sdk.LDValue;
import com.launchdarkly.sdk.server.DataModel;
import com.launchdarkly.sdk.server.JsonHelpers;
import com.launchdarkly.sdk.server.ModelBuilders;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;

public class FlagModelDeserializationTest {
    private static final Gson gson = new Gson();

    @Test
    public void preprocessingIsDoneOnDeserialization() {
        DataModel.FeatureFlag originalFlag = ModelBuilders.flagBuilder("flagkey").variations("a", "b").prerequisites(new DataModel.Prerequisite("abc", 0)).targets(ModelBuilders.target(0, "x")).rules(ModelBuilders.ruleBuilder().clauses(ModelBuilders.clause("key", DataModel.Operator.in, LDValue.of((String)"x"), LDValue.of((String)"y"))).build()).build();
        String flagJson = JsonHelpers.serialize((Object)originalFlag);
        DataModel.FeatureFlag flag = (DataModel.FeatureFlag)gson.fromJson(flagJson, DataModel.FeatureFlag.class);
        Assert.assertNotNull((Object)flag.preprocessed);
        for (DataModel.Prerequisite p : flag.getPrerequisites()) {
            Assert.assertNotNull((Object)p.preprocessed);
        }
        for (DataModel.Target t : flag.getTargets()) {
            Assert.assertNotNull((Object)t.preprocessed);
        }
        for (DataModel.Rule r : flag.getRules()) {
            MatcherAssert.assertThat((Object)r.preprocessed, (Matcher)Matchers.notNullValue());
            for (DataModel.Clause c : r.getClauses()) {
                MatcherAssert.assertThat((Object)c.preprocessed, (Matcher)Matchers.notNullValue());
            }
        }
    }
}

