/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.sdk.server;

import com.launchdarkly.sdk.EvaluationDetail;
import com.launchdarkly.sdk.EvaluationReason;
import com.launchdarkly.sdk.LDContext;
import com.launchdarkly.sdk.server.BaseTest;
import com.launchdarkly.sdk.server.BigSegmentStoreWrapper;
import com.launchdarkly.sdk.server.Components;
import com.launchdarkly.sdk.server.DataModel;
import com.launchdarkly.sdk.server.Evaluator;
import com.launchdarkly.sdk.server.LDClient;
import com.launchdarkly.sdk.server.LDConfig;
import com.launchdarkly.sdk.server.ModelBuilders;
import com.launchdarkly.sdk.server.TestComponents;
import com.launchdarkly.sdk.server.TestUtil;
import com.launchdarkly.sdk.server.subsystems.BigSegmentStore;
import com.launchdarkly.sdk.server.subsystems.BigSegmentStoreTypes;
import com.launchdarkly.sdk.server.subsystems.ClientContext;
import com.launchdarkly.sdk.server.subsystems.ComponentConfigurer;
import com.launchdarkly.sdk.server.subsystems.DataStore;
import java.util.Collections;
import org.easymock.EasyMock;
import org.easymock.EasyMockSupport;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class LDClientBigSegmentsTest
extends BaseTest {
    private final LDContext user = LDContext.create((String)"userkey");
    private final DataModel.Segment bigSegment = ModelBuilders.segmentBuilder("segmentkey").unbounded(true).generation(1).build();
    private final DataModel.FeatureFlag flag = ModelBuilders.booleanFlagWithClauses("flagkey", ModelBuilders.clauseMatchingSegment(this.bigSegment));
    private LDConfig.Builder configBuilder;
    private BigSegmentStore storeMock;
    private ComponentConfigurer<BigSegmentStore> storeFactoryMock;
    private final EasyMockSupport mocks = new EasyMockSupport();

    @Before
    public void setup() {
        DataStore dataStore = TestComponents.initedDataStore();
        TestUtil.upsertFlag(dataStore, this.flag);
        TestUtil.upsertSegment(dataStore, this.bigSegment);
        this.storeMock = (BigSegmentStore)this.mocks.niceMock(BigSegmentStore.class);
        this.storeFactoryMock = (ComponentConfigurer)this.mocks.strictMock(ComponentConfigurer.class);
        EasyMock.expect((Object)((BigSegmentStore)this.storeFactoryMock.build((ClientContext)EasyMock.isA(ClientContext.class)))).andReturn((Object)this.storeMock);
        this.configBuilder = this.baseConfig().dataStore(TestComponents.specificComponent(dataStore));
    }

    @Test
    public void userNotFound() throws Exception {
        EasyMock.expect((Object)this.storeMock.getMetadata()).andAnswer(() -> new BigSegmentStoreTypes.StoreMetadata(System.currentTimeMillis())).anyTimes();
        EasyMock.expect((Object)this.storeMock.getMembership(BigSegmentStoreWrapper.hashForUserKey((String)this.user.getKey()))).andReturn(null);
        this.mocks.replayAll();
        LDConfig config = this.configBuilder.bigSegments((ComponentConfigurer)Components.bigSegments(this.storeFactoryMock)).build();
        try (LDClient client = new LDClient("SDK_KEY", config);){
            EvaluationDetail result = client.boolVariationDetail("flagkey", this.user, false);
            Assert.assertFalse((boolean)((Boolean)result.getValue()));
            Assert.assertEquals((Object)EvaluationReason.BigSegmentsStatus.HEALTHY, (Object)result.getReason().getBigSegmentsStatus());
        }
    }

    @Test
    public void userFound() throws Exception {
        BigSegmentStoreTypes.Membership membership = BigSegmentStoreTypes.createMembershipFromSegmentRefs(Collections.singleton(Evaluator.makeBigSegmentRef((DataModel.Segment)this.bigSegment)), null);
        EasyMock.expect((Object)this.storeMock.getMetadata()).andAnswer(() -> new BigSegmentStoreTypes.StoreMetadata(System.currentTimeMillis())).anyTimes();
        EasyMock.expect((Object)this.storeMock.getMembership(BigSegmentStoreWrapper.hashForUserKey((String)this.user.getKey()))).andReturn((Object)membership);
        this.mocks.replayAll();
        LDConfig config = this.configBuilder.bigSegments((ComponentConfigurer)Components.bigSegments(this.storeFactoryMock)).build();
        try (LDClient client = new LDClient("SDK_KEY", config);){
            EvaluationDetail result = client.boolVariationDetail("flagkey", this.user, false);
            Assert.assertTrue((boolean)((Boolean)result.getValue()));
            Assert.assertEquals((Object)EvaluationReason.BigSegmentsStatus.HEALTHY, (Object)result.getReason().getBigSegmentsStatus());
        }
    }

    @Test
    public void storeError() throws Exception {
        EasyMock.expect((Object)this.storeMock.getMetadata()).andAnswer(() -> new BigSegmentStoreTypes.StoreMetadata(System.currentTimeMillis())).anyTimes();
        EasyMock.expect((Object)this.storeMock.getMembership(BigSegmentStoreWrapper.hashForUserKey((String)this.user.getKey()))).andThrow((Throwable)new RuntimeException("sorry"));
        this.mocks.replayAll();
        LDConfig config = this.configBuilder.bigSegments((ComponentConfigurer)Components.bigSegments(this.storeFactoryMock)).build();
        try (LDClient client = new LDClient("SDK_KEY", config);){
            EvaluationDetail result = client.boolVariationDetail("flagkey", this.user, false);
            Assert.assertFalse((boolean)((Boolean)result.getValue()));
            Assert.assertEquals((Object)EvaluationReason.BigSegmentsStatus.STORE_ERROR, (Object)result.getReason().getBigSegmentsStatus());
        }
    }

    @Test
    public void storeNotConfigured() throws Exception {
        try (LDClient client = new LDClient("SDK_KEY", this.configBuilder.build());){
            EvaluationDetail result = client.boolVariationDetail("flagkey", this.user, false);
            Assert.assertFalse((boolean)((Boolean)result.getValue()));
            Assert.assertEquals((Object)EvaluationReason.BigSegmentsStatus.NOT_CONFIGURED, (Object)result.getReason().getBigSegmentsStatus());
        }
    }
}

