/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.sdk.server;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.gson.Gson;
import com.launchdarkly.sdk.EvaluationDetail;
import com.launchdarkly.sdk.EvaluationReason;
import com.launchdarkly.sdk.LDContext;
import com.launchdarkly.sdk.LDUser;
import com.launchdarkly.sdk.LDValue;
import com.launchdarkly.sdk.server.BaseTest;
import com.launchdarkly.sdk.server.DataModel;
import com.launchdarkly.sdk.server.Evaluator;
import com.launchdarkly.sdk.server.FeatureFlagsState;
import com.launchdarkly.sdk.server.FlagsStateOption;
import com.launchdarkly.sdk.server.InMemoryDataStore;
import com.launchdarkly.sdk.server.LDClient;
import com.launchdarkly.sdk.server.LDConfig;
import com.launchdarkly.sdk.server.ModelBuilders;
import com.launchdarkly.sdk.server.TestComponents;
import com.launchdarkly.sdk.server.TestUtil;
import com.launchdarkly.sdk.server.integrations.TestData;
import com.launchdarkly.sdk.server.interfaces.LDClientInterface;
import com.launchdarkly.sdk.server.subsystems.ComponentConfigurer;
import com.launchdarkly.sdk.server.subsystems.DataStore;
import com.launchdarkly.sdk.server.subsystems.DataStoreTypes;
import com.launchdarkly.testhelpers.JsonAssertions;
import java.time.Duration;
import java.util.Map;
import org.junit.Assert;
import org.junit.Test;

public class LDClientEvaluationTest
extends BaseTest {
    private static final LDContext context = LDContext.create((String)"userkey");
    private static final LDUser contextAsUser = new LDUser(context.getKey());
    private static final LDContext invalidContext = LDContext.create(null);
    private static final LDUser invalidUser = new LDUser(null);
    private static final Gson gson = new Gson();
    private DataStore dataStore = TestComponents.initedDataStore();
    private LDConfig config = this.baseConfig().dataStore(TestComponents.specificComponent(this.dataStore)).build();
    private LDClientInterface client = new LDClient("SDK_KEY", this.config);

    private <T> void doTypedVariationTests(EvalMethod<LDContext, T> variationMethod, EvalMethod<LDUser, T> variationForUserMethod, EvalDetailMethod<LDContext, T> variationDetailMethod, EvalDetailMethod<LDUser, T> variationDetailForUserMethod, T expectedValue, LDValue expectedLdValue, T defaultValue, LDValue wrongTypeLdValue) {
        String flagKey = "flagkey";
        String wrongTypeFlagKey = "wrongtypekey";
        String nullValueFlagKey = "nullvaluekey";
        String unknownKey = "unknownkey";
        TestData testData = TestData.dataSource();
        testData.update(testData.flag(flagKey).on(true).variations(new LDValue[]{LDValue.ofNull(), expectedLdValue}).variationForUser(context.getKey(), 1));
        testData.update(testData.flag(nullValueFlagKey).on(true).variations(new LDValue[]{LDValue.ofNull()}).variationForUser(context.getKey(), 0));
        testData.update(testData.flag(wrongTypeFlagKey).on(true).variations(new LDValue[]{LDValue.ofNull(), wrongTypeLdValue}).variationForUser(context.getKey(), 1));
        LDClient client = new LDClient("SDK_KEY", this.baseConfig().dataSource((ComponentConfigurer)testData).build());
        Assert.assertEquals(expectedValue, variationMethod.apply((LDClientInterface)client, flagKey, context, defaultValue));
        Assert.assertEquals(expectedValue, variationForUserMethod.apply((LDClientInterface)client, flagKey, contextAsUser, defaultValue));
        Assert.assertEquals((Object)EvaluationDetail.fromValue(expectedValue, (int)1, (EvaluationReason)EvaluationReason.targetMatch()), variationDetailMethod.apply((LDClientInterface)client, flagKey, context, defaultValue));
        Assert.assertEquals((Object)EvaluationDetail.fromValue(expectedValue, (int)1, (EvaluationReason)EvaluationReason.targetMatch()), variationDetailForUserMethod.apply((LDClientInterface)client, flagKey, contextAsUser, defaultValue));
        Assert.assertEquals(defaultValue, variationMethod.apply((LDClientInterface)client, unknownKey, context, defaultValue));
        Assert.assertEquals(defaultValue, variationForUserMethod.apply((LDClientInterface)client, unknownKey, contextAsUser, defaultValue));
        Assert.assertEquals((Object)EvaluationDetail.fromValue(defaultValue, (int)-1, (EvaluationReason)EvaluationReason.error((EvaluationReason.ErrorKind)EvaluationReason.ErrorKind.FLAG_NOT_FOUND)), variationDetailMethod.apply((LDClientInterface)client, unknownKey, context, defaultValue));
        Assert.assertEquals((Object)EvaluationDetail.fromValue(defaultValue, (int)-1, (EvaluationReason)EvaluationReason.error((EvaluationReason.ErrorKind)EvaluationReason.ErrorKind.FLAG_NOT_FOUND)), variationDetailForUserMethod.apply((LDClientInterface)client, unknownKey, contextAsUser, defaultValue));
        Assert.assertEquals(defaultValue, variationMethod.apply((LDClientInterface)client, flagKey, invalidContext, defaultValue));
        Assert.assertEquals(defaultValue, variationMethod.apply((LDClientInterface)client, flagKey, null, defaultValue));
        Assert.assertEquals(defaultValue, variationForUserMethod.apply((LDClientInterface)client, flagKey, invalidUser, defaultValue));
        Assert.assertEquals(defaultValue, variationForUserMethod.apply((LDClientInterface)client, flagKey, null, defaultValue));
        Assert.assertEquals((Object)EvaluationDetail.fromValue(defaultValue, (int)-1, (EvaluationReason)EvaluationReason.error((EvaluationReason.ErrorKind)EvaluationReason.ErrorKind.USER_NOT_SPECIFIED)), variationDetailMethod.apply((LDClientInterface)client, flagKey, invalidContext, defaultValue));
        Assert.assertEquals((Object)EvaluationDetail.fromValue(defaultValue, (int)-1, (EvaluationReason)EvaluationReason.error((EvaluationReason.ErrorKind)EvaluationReason.ErrorKind.USER_NOT_SPECIFIED)), variationDetailMethod.apply((LDClientInterface)client, flagKey, null, defaultValue));
        Assert.assertEquals((Object)EvaluationDetail.fromValue(defaultValue, (int)-1, (EvaluationReason)EvaluationReason.error((EvaluationReason.ErrorKind)EvaluationReason.ErrorKind.USER_NOT_SPECIFIED)), variationDetailForUserMethod.apply((LDClientInterface)client, flagKey, invalidUser, defaultValue));
        Assert.assertEquals((Object)EvaluationDetail.fromValue(defaultValue, (int)-1, (EvaluationReason)EvaluationReason.error((EvaluationReason.ErrorKind)EvaluationReason.ErrorKind.USER_NOT_SPECIFIED)), variationDetailForUserMethod.apply((LDClientInterface)client, flagKey, null, defaultValue));
        if (wrongTypeLdValue != null) {
            Assert.assertEquals(defaultValue, variationMethod.apply((LDClientInterface)client, wrongTypeFlagKey, context, defaultValue));
            Assert.assertEquals(defaultValue, variationForUserMethod.apply((LDClientInterface)client, wrongTypeFlagKey, contextAsUser, defaultValue));
            Assert.assertEquals((Object)EvaluationDetail.fromValue(defaultValue, (int)-1, (EvaluationReason)EvaluationReason.error((EvaluationReason.ErrorKind)EvaluationReason.ErrorKind.WRONG_TYPE)), variationDetailMethod.apply((LDClientInterface)client, wrongTypeFlagKey, context, defaultValue));
        }
    }

    @Test
    public void boolEvaluations() {
        this.doTypedVariationTests((c, f, ctx, d) -> c.boolVariation(f, ctx, d.booleanValue()), (c, f, u, d) -> c.boolVariation(f, u, d.booleanValue()), (c, f, ctx, d) -> c.boolVariationDetail(f, ctx, d.booleanValue()), (c, f, u, d) -> c.boolVariationDetail(f, u, d.booleanValue()), true, LDValue.of((boolean)true), false, LDValue.of((String)"wrongtype"));
    }

    @Test
    public void intEvaluations() {
        this.doTypedVariationTests((c, f, ctx, d) -> c.intVariation(f, ctx, d.intValue()), (c, f, u, d) -> c.intVariation(f, u, d.intValue()), (c, f, ctx, d) -> c.intVariationDetail(f, ctx, d.intValue()), (c, f, u, d) -> c.intVariationDetail(f, u, d.intValue()), 2, LDValue.of((int)2), 1, LDValue.of((String)"wrongtype"));
    }

    @Test
    public void doubleEvaluations() {
        this.doTypedVariationTests((c, f, ctx, d) -> c.doubleVariation(f, ctx, d.doubleValue()), (c, f, u, d) -> c.doubleVariation(f, u, d.doubleValue()), (c, f, ctx, d) -> c.doubleVariationDetail(f, ctx, d.doubleValue()), (c, f, u, d) -> c.doubleVariationDetail(f, u, d.doubleValue()), 2.5, LDValue.of((double)2.5), 1.5, LDValue.of((String)"wrongtype"));
    }

    @Test
    public void jsonEvaluations() {
        LDValue data = LDValue.buildObject().put("thing", "stuff").build();
        LDValue defaultValue = LDValue.of((String)"default");
        this.doTypedVariationTests((c, f, ctx, d) -> c.jsonValueVariation(f, ctx, d), (c, f, u, d) -> c.jsonValueVariation(f, u, d), (c, f, ctx, d) -> c.jsonValueVariationDetail(f, ctx, d), (c, f, u, d) -> c.jsonValueVariationDetail(f, u, d), data, data, defaultValue, null);
    }

    @Test
    public void intVariationReturnsFlagValueEvenIfEncodedAsDouble() throws Exception {
        TestUtil.upsertFlag(this.dataStore, ModelBuilders.flagWithValue("key", LDValue.of((double)2.0)));
        Assert.assertEquals((long)2L, (long)this.client.intVariation("key", context, 1));
    }

    @Test
    public void intVariationFromDoubleRoundsTowardZero() throws Exception {
        TestUtil.upsertFlag(this.dataStore, ModelBuilders.flagWithValue("flag1", LDValue.of((double)2.25)));
        TestUtil.upsertFlag(this.dataStore, ModelBuilders.flagWithValue("flag2", LDValue.of((double)2.75)));
        TestUtil.upsertFlag(this.dataStore, ModelBuilders.flagWithValue("flag3", LDValue.of((double)-2.25)));
        TestUtil.upsertFlag(this.dataStore, ModelBuilders.flagWithValue("flag4", LDValue.of((double)-2.75)));
        Assert.assertEquals((long)2L, (long)this.client.intVariation("flag1", context, 1));
        Assert.assertEquals((long)2L, (long)this.client.intVariation("flag2", context, 1));
        Assert.assertEquals((long)-2L, (long)this.client.intVariation("flag3", context, 1));
        Assert.assertEquals((long)-2L, (long)this.client.intVariation("flag4", context, 1));
    }

    @Test
    public void doubleVariationReturnsFlagValueEvenIfEncodedAsInt() throws Exception {
        TestUtil.upsertFlag(this.dataStore, ModelBuilders.flagWithValue("key", LDValue.of((int)2)));
        Assert.assertEquals((double)2.0, (double)this.client.doubleVariation("key", context, 1.0), (double)0.0);
    }

    @Test
    public void doubleVariationReturnsDefaultValueForUnknownFlag() throws Exception {
        Assert.assertEquals((double)1.0, (double)this.client.doubleVariation("key", context, 1.0), (double)0.0);
        Assert.assertEquals((Object)EvaluationDetail.fromValue((Object)1.0, (int)-1, (EvaluationReason)EvaluationReason.error((EvaluationReason.ErrorKind)EvaluationReason.ErrorKind.FLAG_NOT_FOUND)), (Object)this.client.doubleVariationDetail("key", context, 1.0));
    }

    @Test
    public void doubleVariationReturnsDefaultValueForWrongType() throws Exception {
        TestUtil.upsertFlag(this.dataStore, ModelBuilders.flagWithValue("key", LDValue.of((String)"wrong")));
        Assert.assertEquals((double)1.0, (double)this.client.doubleVariation("key", context, 1.0), (double)0.0);
        Assert.assertEquals((Object)EvaluationDetail.fromValue((Object)1.0, (int)-1, (EvaluationReason)EvaluationReason.error((EvaluationReason.ErrorKind)EvaluationReason.ErrorKind.WRONG_TYPE)), (Object)this.client.doubleVariationDetail("key", context, 1.0));
    }

    @Test
    public void stringVariationWithNullDefaultReturnsFlagValue() throws Exception {
        TestUtil.upsertFlag(this.dataStore, ModelBuilders.flagWithValue("key", LDValue.of((String)"b")));
        Assert.assertEquals((Object)"b", (Object)this.client.stringVariation("key", context, null));
    }

    @Test
    public void stringVariationWithNullDefaultReturnsDefaultValueForUnknownFlag() throws Exception {
        Assert.assertNull((Object)this.client.stringVariation("key", context, null));
        Assert.assertEquals((Object)EvaluationDetail.fromValue((Object)null, (int)-1, (EvaluationReason)EvaluationReason.error((EvaluationReason.ErrorKind)EvaluationReason.ErrorKind.FLAG_NOT_FOUND)), (Object)this.client.stringVariationDetail("key", context, null));
    }

    @Test
    public void stringVariationReturnsDefaultValueForWrongType() throws Exception {
        TestUtil.upsertFlag(this.dataStore, ModelBuilders.flagWithValue("key", LDValue.of((boolean)true)));
        Assert.assertEquals((Object)"a", (Object)this.client.stringVariation("key", context, "a"));
        Assert.assertEquals((Object)EvaluationDetail.fromValue((Object)"a", (int)-1, (EvaluationReason)EvaluationReason.error((EvaluationReason.ErrorKind)EvaluationReason.ErrorKind.WRONG_TYPE)), (Object)this.client.stringVariationDetail("key", context, "a"));
    }

    @Test
    public void stringVariationWithNullDefaultReturnsDefaultValueForWrongType() throws Exception {
        TestUtil.upsertFlag(this.dataStore, ModelBuilders.flagWithValue("key", LDValue.of((boolean)true)));
        Assert.assertNull((Object)this.client.stringVariation("key", context, null));
        Assert.assertEquals((Object)EvaluationDetail.fromValue((Object)null, (int)-1, (EvaluationReason)EvaluationReason.error((EvaluationReason.ErrorKind)EvaluationReason.ErrorKind.WRONG_TYPE)), (Object)this.client.stringVariationDetail("key", context, null));
    }

    @Test
    public void canMatchUserBySegment() throws Exception {
        DataModel.Segment segment = ModelBuilders.segmentBuilder("segment1").version(1).included(context.getKey()).build();
        TestUtil.upsertSegment(this.dataStore, segment);
        DataModel.Clause clause = ModelBuilders.clauseMatchingSegment("segment1");
        DataModel.FeatureFlag feature = ModelBuilders.booleanFlagWithClauses("feature", clause);
        TestUtil.upsertFlag(this.dataStore, feature);
        Assert.assertTrue((boolean)this.client.boolVariation("feature", context, false));
    }

    @Test
    public void canTryToMatchUserBySegmentWhenSegmentIsNotFound() throws Exception {
        DataModel.Clause clause = ModelBuilders.clauseMatchingSegment("segment1");
        DataModel.FeatureFlag feature = ModelBuilders.booleanFlagWithClauses("feature", clause);
        TestUtil.upsertFlag(this.dataStore, feature);
        Assert.assertFalse((boolean)this.client.boolVariation("feature", context, false));
    }

    @Test
    public void canGetDetailsForSuccessfulEvaluation() throws Exception {
        TestUtil.upsertFlag(this.dataStore, ModelBuilders.flagWithValue("key", LDValue.of((boolean)true)));
        EvaluationDetail expectedResult = EvaluationDetail.fromValue((Object)true, (int)0, (EvaluationReason)EvaluationReason.off());
        Assert.assertEquals((Object)expectedResult, (Object)this.client.boolVariationDetail("key", context, false));
    }

    @Test
    public void jsonVariationReturnsNullIfFlagEvaluatesToNull() {
        DataModel.FeatureFlag flag = ModelBuilders.flagBuilder("key").on(false).offVariation(0).variations(LDValue.ofNull()).build();
        TestUtil.upsertFlag(this.dataStore, flag);
        Assert.assertEquals((Object)LDValue.ofNull(), (Object)this.client.jsonValueVariation("key", context, LDValue.buildObject().build()));
    }

    @Test
    public void typedVariationReturnsZeroValueForTypeIfFlagEvaluatesToNull() {
        DataModel.FeatureFlag flag = ModelBuilders.flagBuilder("key").on(false).offVariation(0).variations(LDValue.ofNull()).build();
        TestUtil.upsertFlag(this.dataStore, flag);
        Assert.assertEquals((Object)false, (Object)this.client.boolVariation("key", context, true));
        Assert.assertEquals((long)0L, (long)this.client.intVariation("key", context, 1));
        Assert.assertEquals((double)0.0, (double)this.client.doubleVariation("key", context, 1.0), (double)0.0);
    }

    @Test
    public void variationDetailReturnsDefaultIfFlagEvaluatesToNull() {
        DataModel.FeatureFlag flag = ModelBuilders.flagBuilder("key").on(false).offVariation(null).build();
        TestUtil.upsertFlag(this.dataStore, flag);
        EvaluationDetail expected = EvaluationDetail.fromValue((Object)"default", (int)-1, (EvaluationReason)EvaluationReason.off());
        EvaluationDetail actual = this.client.stringVariationDetail("key", context, "default");
        Assert.assertEquals((Object)expected, (Object)actual);
        Assert.assertTrue((boolean)actual.isDefaultValue());
    }

    @Test
    public void deletedFlagPlaceholderIsTreatedAsUnknownFlag() {
        DataModel.FeatureFlag flag = ModelBuilders.flagWithValue("key", LDValue.of((String)"hello"));
        TestUtil.upsertFlag(this.dataStore, flag);
        this.dataStore.upsert(DataModel.FEATURES, flag.getKey(), DataStoreTypes.ItemDescriptor.deletedItem((int)(flag.getVersion() + 1)));
        Assert.assertEquals((Object)"default", (Object)this.client.stringVariation(flag.getKey(), context, "default"));
    }

    @Test
    public void appropriateErrorIfClientNotInitialized() throws Exception {
        InMemoryDataStore badDataStore = new InMemoryDataStore();
        LDConfig badConfig = this.baseConfig().dataStore(TestComponents.specificComponent(badDataStore)).dataSource(TestComponents.specificComponent(TestComponents.failedDataSource())).startWait(Duration.ZERO).build();
        try (LDClient badClient = new LDClient("SDK_KEY", badConfig);){
            EvaluationDetail expectedResult = EvaluationDetail.fromValue((Object)false, (int)-1, (EvaluationReason)EvaluationReason.error((EvaluationReason.ErrorKind)EvaluationReason.ErrorKind.CLIENT_NOT_READY));
            Assert.assertEquals((Object)expectedResult, (Object)badClient.boolVariationDetail("key", context, false));
        }
    }

    @Test
    public void appropriateErrorIfFlagDoesNotExist() throws Exception {
        EvaluationDetail expectedResult = EvaluationDetail.fromValue((Object)"default", (int)-1, (EvaluationReason)EvaluationReason.error((EvaluationReason.ErrorKind)EvaluationReason.ErrorKind.FLAG_NOT_FOUND));
        Assert.assertEquals((Object)expectedResult, (Object)this.client.stringVariationDetail("key", context, "default"));
    }

    @Test
    public void appropriateErrorIfContextIsInvalid() throws Exception {
        TestUtil.upsertFlag(this.dataStore, ModelBuilders.flagWithValue("key", LDValue.of((boolean)true)));
        EvaluationDetail expectedResult = EvaluationDetail.fromValue((Object)"default", (int)-1, (EvaluationReason)EvaluationReason.error((EvaluationReason.ErrorKind)EvaluationReason.ErrorKind.USER_NOT_SPECIFIED));
        Assert.assertEquals((Object)expectedResult, (Object)this.client.stringVariationDetail("key", invalidContext, "default"));
    }

    @Test
    public void appropriateErrorIfValueWrongType() throws Exception {
        TestUtil.upsertFlag(this.dataStore, ModelBuilders.flagWithValue("key", LDValue.of((boolean)true)));
        EvaluationDetail expectedResult = EvaluationDetail.fromValue((Object)3, (int)-1, (EvaluationReason)EvaluationReason.error((EvaluationReason.ErrorKind)EvaluationReason.ErrorKind.WRONG_TYPE));
        Assert.assertEquals((Object)expectedResult, (Object)this.client.intVariationDetail("key", context, 3));
    }

    @Test
    public void appropriateErrorForUnexpectedExceptionFromDataStore() throws Exception {
        RuntimeException exception = new RuntimeException("sorry");
        DataStore badDataStore = TestComponents.dataStoreThatThrowsException(exception);
        LDConfig badConfig = this.baseConfig().dataStore(TestComponents.specificComponent(badDataStore)).build();
        try (LDClient badClient = new LDClient("SDK_KEY", badConfig);){
            EvaluationDetail expectedResult = EvaluationDetail.fromValue((Object)false, (int)-1, (EvaluationReason)EvaluationReason.exception((Exception)exception));
            Assert.assertEquals((Object)expectedResult, (Object)badClient.boolVariationDetail("key", context, false));
        }
    }

    @Test
    public void appropriateErrorForUnexpectedExceptionFromFlagEvaluation() throws Exception {
        TestUtil.upsertFlag(this.dataStore, ModelBuilders.flagWithValue("$ test error flag $", LDValue.of((boolean)true)));
        EvaluationDetail expectedResult = EvaluationDetail.fromValue((Object)false, (int)-1, (EvaluationReason)EvaluationReason.exception((Exception)Evaluator.EXPECTED_EXCEPTION_FROM_INVALID_FLAG));
        Assert.assertEquals((Object)expectedResult, (Object)this.client.boolVariationDetail("$ test error flag $", context, false));
    }

    @Test
    public void evaluationUsesStoreIfStoreIsInitializedButClientIsNot() throws Exception {
        TestUtil.upsertFlag(this.dataStore, ModelBuilders.flagWithValue("key", LDValue.of((String)"value")));
        LDConfig customConfig = this.baseConfig().dataStore(TestComponents.specificComponent(this.dataStore)).dataSource(TestComponents.specificComponent(TestComponents.failedDataSource())).startWait(Duration.ZERO).build();
        try (LDClient client = new LDClient("SDK_KEY", customConfig);){
            Assert.assertFalse((boolean)client.isInitialized());
            Assert.assertEquals((Object)"value", (Object)client.stringVariation("key", context, ""));
        }
    }

    @Test
    public void allFlagsStateReturnsState() throws Exception {
        DataModel.FeatureFlag flag1 = ModelBuilders.flagBuilder("key1").version(100).trackEvents(false).on(false).offVariation(0).variations(LDValue.of((String)"value1")).build();
        DataModel.FeatureFlag flag2 = ModelBuilders.flagBuilder("key2").version(200).trackEvents(true).debugEventsUntilDate(1000L).on(true).fallthrough(ModelBuilders.fallthroughVariation(1)).variations(LDValue.of((String)"off"), LDValue.of((String)"value2")).build();
        DataModel.FeatureFlag flag3 = ModelBuilders.flagBuilder("key3").version(300).on(true).fallthroughVariation(1).variations(LDValue.of((String)"x"), LDValue.of((String)"value3")).trackEvents(false).trackEventsFallthrough(true).build();
        TestUtil.upsertFlag(this.dataStore, flag1);
        TestUtil.upsertFlag(this.dataStore, flag2);
        TestUtil.upsertFlag(this.dataStore, flag3);
        FeatureFlagsState state = this.client.allFlagsState(context, new FlagsStateOption[0]);
        Assert.assertTrue((boolean)state.isValid());
        String json = "{\"key1\":\"value1\",\"key2\":\"value2\",\"key3\":\"value3\",\"$flagsState\":{\"key1\":{\"variation\":0,\"version\":100},\"key2\":{\"variation\":1,\"version\":200,\"trackEvents\":true,\"debugEventsUntilDate\":1000},\"key3\":{\"variation\":1,\"version\":300,\"trackEvents\":true,\"trackReason\":true,\"reason\":{\"kind\":\"FALLTHROUGH\"}}},\"$valid\":true}";
        JsonAssertions.assertJsonEquals((String)json, (String)gson.toJson((Object)state));
        LDUser userWithOldUserType = new LDUser(context.getKey());
        JsonAssertions.assertJsonEquals((String)gson.toJson((Object)state), (String)gson.toJson((Object)this.client.allFlagsState(userWithOldUserType, new FlagsStateOption[0])));
    }

    @Test
    public void allFlagsStateCanFilterForOnlyClientSideFlags() {
        DataModel.FeatureFlag flag1 = ModelBuilders.flagBuilder("server-side-1").build();
        DataModel.FeatureFlag flag2 = ModelBuilders.flagBuilder("server-side-2").build();
        DataModel.FeatureFlag flag3 = ModelBuilders.flagBuilder("client-side-1").clientSide(true).variations(LDValue.of((String)"value1")).offVariation(0).build();
        DataModel.FeatureFlag flag4 = ModelBuilders.flagBuilder("client-side-2").clientSide(true).variations(LDValue.of((String)"value2")).offVariation(0).build();
        TestUtil.upsertFlag(this.dataStore, flag1);
        TestUtil.upsertFlag(this.dataStore, flag2);
        TestUtil.upsertFlag(this.dataStore, flag3);
        TestUtil.upsertFlag(this.dataStore, flag4);
        FeatureFlagsState state = this.client.allFlagsState(context, new FlagsStateOption[]{FlagsStateOption.CLIENT_SIDE_ONLY});
        Assert.assertTrue((boolean)state.isValid());
        Map allValues = state.toValuesMap();
        Assert.assertEquals((Object)ImmutableMap.of((Object)"client-side-1", (Object)LDValue.of((String)"value1"), (Object)"client-side-2", (Object)LDValue.of((String)"value2")), (Object)allValues);
    }

    @Test
    public void allFlagsStateReturnsStateWithReasons() {
        DataModel.FeatureFlag flag1 = ModelBuilders.flagBuilder("key1").version(100).trackEvents(false).on(false).offVariation(0).variations(LDValue.of((String)"value1")).build();
        DataModel.FeatureFlag flag2 = ModelBuilders.flagBuilder("key2").version(200).trackEvents(true).debugEventsUntilDate(1000L).on(true).fallthrough(ModelBuilders.fallthroughVariation(1)).variations(LDValue.of((String)"off"), LDValue.of((String)"value2")).build();
        TestUtil.upsertFlag(this.dataStore, flag1);
        TestUtil.upsertFlag(this.dataStore, flag2);
        FeatureFlagsState state = this.client.allFlagsState(context, new FlagsStateOption[]{FlagsStateOption.WITH_REASONS});
        Assert.assertTrue((boolean)state.isValid());
        String json = "{\"key1\":\"value1\",\"key2\":\"value2\",\"$flagsState\":{\"key1\":{\"variation\":0,\"version\":100,\"reason\":{\"kind\":\"OFF\"}},\"key2\":{\"variation\":1,\"version\":200,\"reason\":{\"kind\":\"FALLTHROUGH\"},\"trackEvents\":true,\"debugEventsUntilDate\":1000}},\"$valid\":true}";
        JsonAssertions.assertJsonEquals((String)json, (String)gson.toJson((Object)state));
    }

    @Test
    public void allFlagsStateCanOmitDetailsForUntrackedFlags() {
        long futureTime = System.currentTimeMillis() + 1000000L;
        DataModel.FeatureFlag flag1 = ModelBuilders.flagBuilder("key1").version(100).trackEvents(false).on(false).offVariation(0).variations(LDValue.of((String)"value1")).build();
        DataModel.FeatureFlag flag2 = ModelBuilders.flagBuilder("key2").version(200).trackEvents(true).on(true).fallthrough(ModelBuilders.fallthroughVariation(1)).variations(LDValue.of((String)"off"), LDValue.of((String)"value2")).build();
        DataModel.FeatureFlag flag3 = ModelBuilders.flagBuilder("key3").version(300).trackEvents(false).debugEventsUntilDate(futureTime).on(false).offVariation(0).variations(LDValue.of((String)"value3")).build();
        TestUtil.upsertFlag(this.dataStore, flag1);
        TestUtil.upsertFlag(this.dataStore, flag2);
        TestUtil.upsertFlag(this.dataStore, flag3);
        FeatureFlagsState state = this.client.allFlagsState(context, new FlagsStateOption[]{FlagsStateOption.WITH_REASONS, FlagsStateOption.DETAILS_ONLY_FOR_TRACKED_FLAGS});
        Assert.assertTrue((boolean)state.isValid());
        String json = "{\"key1\":\"value1\",\"key2\":\"value2\",\"key3\":\"value3\",\"$flagsState\":{\"key1\":{\"variation\":0},\"key2\":{\"variation\":1,\"version\":200,\"reason\":{\"kind\":\"FALLTHROUGH\"},\"trackEvents\":true},\"key3\":{\"variation\":0,\"version\":300,\"reason\":{\"kind\":\"OFF\"},\"debugEventsUntilDate\":" + futureTime + "}},\"$valid\":true}";
        JsonAssertions.assertJsonEquals((String)json, (String)gson.toJson((Object)state));
    }

    @Test
    public void allFlagsStateFiltersOutDeletedFlags() throws Exception {
        DataModel.FeatureFlag flag1 = ModelBuilders.flagBuilder("key1").version(1).build();
        DataModel.FeatureFlag flag2 = ModelBuilders.flagBuilder("key2").version(1).build();
        TestUtil.upsertFlag(this.dataStore, flag1);
        TestUtil.upsertFlag(this.dataStore, flag2);
        this.dataStore.upsert(DataModel.FEATURES, flag2.getKey(), DataStoreTypes.ItemDescriptor.deletedItem((int)(flag2.getVersion() + 1)));
        FeatureFlagsState state = this.client.allFlagsState(context, new FlagsStateOption[0]);
        Assert.assertTrue((boolean)state.isValid());
        Map valuesMap = state.toValuesMap();
        Assert.assertEquals((long)1L, (long)valuesMap.size());
        Assert.assertEquals((Object)flag1.getKey(), (Object)Iterables.getFirst(valuesMap.keySet(), null));
    }

    @Test
    public void allFlagsStateReturnsEmptyStateForNullContext() throws Exception {
        TestUtil.upsertFlag(this.dataStore, ModelBuilders.flagWithValue("key", LDValue.of((String)"value")));
        FeatureFlagsState state = this.client.allFlagsState((LDContext)null, new FlagsStateOption[0]);
        Assert.assertFalse((boolean)state.isValid());
        Assert.assertEquals((long)0L, (long)state.toValuesMap().size());
    }

    @Test
    public void allFlagsStateReturnsEmptyStateForInvalidContext() throws Exception {
        TestUtil.upsertFlag(this.dataStore, ModelBuilders.flagWithValue("key", LDValue.of((String)"value")));
        FeatureFlagsState state = this.client.allFlagsState(invalidContext, new FlagsStateOption[0]);
        Assert.assertFalse((boolean)state.isValid());
        Assert.assertEquals((long)0L, (long)state.toValuesMap().size());
    }

    @Test
    public void allFlagsStateReturnsEmptyStateIfDataStoreThrowsException() throws Exception {
        LDConfig customConfig = this.baseConfig().dataStore(TestComponents.specificComponent(TestComponents.dataStoreThatThrowsException(new RuntimeException("sorry")))).startWait(Duration.ZERO).build();
        try (LDClient client = new LDClient("SDK_KEY", customConfig);){
            FeatureFlagsState state = client.allFlagsState(context, new FlagsStateOption[0]);
            Assert.assertFalse((boolean)state.isValid());
            Assert.assertEquals((long)0L, (long)state.toValuesMap().size());
        }
    }

    @Test
    public void allFlagsStateUsesNullValueForFlagIfEvaluationThrowsException() throws Exception {
        TestUtil.upsertFlag(this.dataStore, ModelBuilders.flagWithValue("goodkey", LDValue.of((String)"value")));
        TestUtil.upsertFlag(this.dataStore, ModelBuilders.flagWithValue("$ test error flag $", LDValue.of((String)"nope")));
        FeatureFlagsState state = this.client.allFlagsState(context, new FlagsStateOption[0]);
        Assert.assertTrue((boolean)state.isValid());
        Assert.assertEquals((long)2L, (long)state.toValuesMap().size());
        Assert.assertEquals((Object)LDValue.of((String)"value"), (Object)state.getFlagValue("goodkey"));
        Assert.assertEquals((Object)LDValue.ofNull(), (Object)state.getFlagValue("$ test error flag $"));
    }

    @Test
    public void allFlagsStateUsesStoreDataIfStoreIsInitializedButClientIsNot() throws Exception {
        TestUtil.upsertFlag(this.dataStore, ModelBuilders.flagWithValue("key", LDValue.of((String)"value")));
        LDConfig customConfig = this.baseConfig().dataStore(TestComponents.specificComponent(this.dataStore)).dataSource(TestComponents.specificComponent(TestComponents.failedDataSource())).startWait(Duration.ZERO).build();
        try (LDClient client = new LDClient("SDK_KEY", customConfig);){
            Assert.assertFalse((boolean)client.isInitialized());
            FeatureFlagsState state = client.allFlagsState(context, new FlagsStateOption[0]);
            Assert.assertTrue((boolean)state.isValid());
            Assert.assertEquals((Object)LDValue.of((String)"value"), (Object)state.getFlagValue("key"));
        }
    }

    @Test
    public void allFlagsStateReturnsEmptyStateIfClientAndStoreAreNotInitialized() throws Exception {
        LDConfig customConfig = this.baseConfig().dataSource(TestComponents.specificComponent(TestComponents.failedDataSource())).startWait(Duration.ZERO).build();
        try (LDClient client = new LDClient("SDK_KEY", customConfig);){
            Assert.assertFalse((boolean)client.isInitialized());
            FeatureFlagsState state = client.allFlagsState(context, new FlagsStateOption[0]);
            Assert.assertFalse((boolean)state.isValid());
        }
    }

    public static interface EvalDetailMethod<ContextT, ValueT> {
        public EvaluationDetail<ValueT> apply(LDClientInterface var1, String var2, ContextT var3, ValueT var4);
    }

    public static interface EvalMethod<ContextT, ValueT> {
        public ValueT apply(LDClientInterface var1, String var2, ContextT var3, ValueT var4);
    }
}

