/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.sdk.server;

import com.launchdarkly.sdk.LDContext;
import com.launchdarkly.sdk.LDValue;
import com.launchdarkly.sdk.server.BaseTest;
import com.launchdarkly.sdk.server.Components;
import com.launchdarkly.sdk.server.ComponentsImpl;
import com.launchdarkly.sdk.server.DataModel;
import com.launchdarkly.sdk.server.DefaultEventProcessorWrapper;
import com.launchdarkly.sdk.server.LDClient;
import com.launchdarkly.sdk.server.LDConfig;
import com.launchdarkly.sdk.server.ModelBuilders;
import com.launchdarkly.sdk.server.TestComponents;
import com.launchdarkly.sdk.server.TestUtil;
import com.launchdarkly.sdk.server.interfaces.DataSourceStatusProvider;
import com.launchdarkly.sdk.server.subsystems.ComponentConfigurer;
import com.launchdarkly.sdk.server.subsystems.DataStore;
import java.io.IOException;
import org.junit.Assert;
import org.junit.Test;

public class LDClientExternalUpdatesOnlyTest
extends BaseTest {
    @Test
    public void externalUpdatesOnlyClientHasNullDataSource() throws Exception {
        LDConfig config = this.baseConfig().dataSource(Components.externalUpdatesOnly()).build();
        try (LDClient client = new LDClient("SDK_KEY", config);){
            Assert.assertEquals(ComponentsImpl.NullDataSource.class, client.dataSource.getClass());
        }
    }

    @Test
    public void externalUpdatesOnlyClientHasDefaultEventProcessor() throws Exception {
        LDConfig config = this.baseConfig().dataSource(Components.externalUpdatesOnly()).events((ComponentConfigurer)Components.sendEvents()).build();
        try (LDClient client = new LDClient("SDK_KEY", config);){
            Assert.assertEquals(DefaultEventProcessorWrapper.class, client.eventProcessor.getClass());
        }
    }

    @Test
    public void externalUpdatesOnlyClientIsInitialized() throws Exception {
        LDConfig config = this.baseConfig().dataSource(Components.externalUpdatesOnly()).build();
        try (LDClient client = new LDClient("SDK_KEY", config);){
            Assert.assertTrue((boolean)client.isInitialized());
            Assert.assertEquals((Object)DataSourceStatusProvider.State.VALID, (Object)client.getDataSourceStatusProvider().getStatus().getState());
        }
    }

    @Test
    public void externalUpdatesOnlyClientGetsFlagFromDataStore() throws IOException {
        DataStore testDataStore = TestComponents.initedDataStore();
        LDConfig config = this.baseConfig().dataSource(Components.externalUpdatesOnly()).dataStore(TestComponents.specificComponent(testDataStore)).build();
        DataModel.FeatureFlag flag = ModelBuilders.flagWithValue("key", LDValue.of((boolean)true));
        TestUtil.upsertFlag(testDataStore, flag);
        try (LDClient client = new LDClient("SDK_KEY", config);){
            Assert.assertTrue((boolean)client.boolVariation("key", LDContext.create((String)"user"), false));
        }
    }
}

