/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.sdk.server;

import com.launchdarkly.sdk.LDContext;
import com.launchdarkly.sdk.LDValue;
import com.launchdarkly.sdk.server.BaseTest;
import com.launchdarkly.sdk.server.Components;
import com.launchdarkly.sdk.server.LDClient;
import com.launchdarkly.sdk.server.LDConfig;
import com.launchdarkly.sdk.server.TestComponents;
import com.launchdarkly.sdk.server.integrations.MockPersistentDataStore;
import com.launchdarkly.sdk.server.integrations.PersistentDataStoreBuilder;
import com.launchdarkly.sdk.server.integrations.TestData;
import com.launchdarkly.sdk.server.interfaces.BigSegmentStoreStatusProvider;
import com.launchdarkly.sdk.server.interfaces.DataSourceStatusProvider;
import com.launchdarkly.sdk.server.interfaces.DataStoreStatusProvider;
import com.launchdarkly.sdk.server.interfaces.FlagChangeEvent;
import com.launchdarkly.sdk.server.interfaces.FlagChangeListener;
import com.launchdarkly.sdk.server.interfaces.FlagValueChangeEvent;
import com.launchdarkly.sdk.server.subsystems.BigSegmentStore;
import com.launchdarkly.sdk.server.subsystems.BigSegmentStoreTypes;
import com.launchdarkly.sdk.server.subsystems.ComponentConfigurer;
import com.launchdarkly.testhelpers.ConcurrentHelpers;
import java.time.Duration;
import java.time.Instant;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.easymock.EasyMock;
import org.easymock.EasyMockSupport;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;

public class LDClientListenersTest
extends BaseTest {
    private static final String SDK_KEY = "SDK_KEY";

    @Test
    public void clientSendsFlagChangeEvents() throws Exception {
        String flagKey = "flagkey";
        TestData testData = TestData.dataSource();
        testData.update(testData.flag(flagKey).on(true));
        LDConfig config = this.baseConfig().dataSource((ComponentConfigurer)testData).events(Components.noEvents()).build();
        try (LDClient client = new LDClient(SDK_KEY, config);){
            LinkedBlockingQueue eventSink1 = new LinkedBlockingQueue();
            LinkedBlockingQueue eventSink2 = new LinkedBlockingQueue();
            FlagChangeListener listener1 = eventSink1::add;
            FlagChangeListener listener2 = eventSink2::add;
            client.getFlagTracker().addFlagChangeListener(listener1);
            client.getFlagTracker().addFlagChangeListener(listener2);
            ConcurrentHelpers.assertNoMoreValues(eventSink1, (long)100L, (TimeUnit)TimeUnit.MILLISECONDS);
            ConcurrentHelpers.assertNoMoreValues(eventSink2, (long)100L, (TimeUnit)TimeUnit.MILLISECONDS);
            testData.update(testData.flag(flagKey).on(false));
            FlagChangeEvent event1 = (FlagChangeEvent)ConcurrentHelpers.awaitValue(eventSink1, (long)1L, (TimeUnit)TimeUnit.SECONDS);
            FlagChangeEvent event2 = (FlagChangeEvent)ConcurrentHelpers.awaitValue(eventSink2, (long)1L, (TimeUnit)TimeUnit.SECONDS);
            MatcherAssert.assertThat((Object)event1.getKey(), (Matcher)Matchers.equalTo((Object)flagKey));
            MatcherAssert.assertThat((Object)event2.getKey(), (Matcher)Matchers.equalTo((Object)flagKey));
            ConcurrentHelpers.assertNoMoreValues(eventSink1, (long)100L, (TimeUnit)TimeUnit.MILLISECONDS);
            ConcurrentHelpers.assertNoMoreValues(eventSink2, (long)100L, (TimeUnit)TimeUnit.MILLISECONDS);
            client.getFlagTracker().removeFlagChangeListener(listener1);
            testData.update(testData.flag(flagKey).on(true));
            FlagChangeEvent event3 = (FlagChangeEvent)ConcurrentHelpers.awaitValue(eventSink2, (long)1L, (TimeUnit)TimeUnit.SECONDS);
            MatcherAssert.assertThat((Object)event3.getKey(), (Matcher)Matchers.equalTo((Object)flagKey));
            ConcurrentHelpers.assertNoMoreValues(eventSink1, (long)100L, (TimeUnit)TimeUnit.MILLISECONDS);
            ConcurrentHelpers.assertNoMoreValues(eventSink2, (long)100L, (TimeUnit)TimeUnit.MILLISECONDS);
        }
    }

    @Test
    public void clientSendsFlagValueChangeEvents() throws Exception {
        String flagKey = "important-flag";
        LDContext user = LDContext.create((String)"important-user");
        LDContext otherUser = LDContext.create((String)"unimportant-user");
        TestData testData = TestData.dataSource();
        testData.update(testData.flag(flagKey).on(false));
        LDConfig config = this.baseConfig().dataSource((ComponentConfigurer)testData).events(Components.noEvents()).build();
        try (LDClient client = new LDClient(SDK_KEY, config);){
            LinkedBlockingQueue eventSink1 = new LinkedBlockingQueue();
            LinkedBlockingQueue eventSink2 = new LinkedBlockingQueue();
            LinkedBlockingQueue eventSink3 = new LinkedBlockingQueue();
            client.getFlagTracker().addFlagValueChangeListener(flagKey, user, eventSink1::add);
            FlagChangeListener listener2 = client.getFlagTracker().addFlagValueChangeListener(flagKey, user, eventSink2::add);
            client.getFlagTracker().removeFlagChangeListener(listener2);
            client.getFlagTracker().addFlagValueChangeListener(flagKey, otherUser, eventSink3::add);
            ConcurrentHelpers.assertNoMoreValues(eventSink1, (long)100L, (TimeUnit)TimeUnit.MILLISECONDS);
            ConcurrentHelpers.assertNoMoreValues(eventSink2, (long)100L, (TimeUnit)TimeUnit.MILLISECONDS);
            ConcurrentHelpers.assertNoMoreValues(eventSink3, (long)100L, (TimeUnit)TimeUnit.MILLISECONDS);
            testData.update(testData.flag(flagKey).on(true).variationForUser(user.getKey(), true).fallthroughVariation(false));
            FlagValueChangeEvent event1 = (FlagValueChangeEvent)ConcurrentHelpers.awaitValue(eventSink1, (long)1L, (TimeUnit)TimeUnit.SECONDS);
            MatcherAssert.assertThat((Object)event1.getKey(), (Matcher)Matchers.equalTo((Object)flagKey));
            MatcherAssert.assertThat((Object)event1.getOldValue(), (Matcher)Matchers.equalTo((Object)LDValue.of((boolean)false)));
            MatcherAssert.assertThat((Object)event1.getNewValue(), (Matcher)Matchers.equalTo((Object)LDValue.of((boolean)true)));
            ConcurrentHelpers.assertNoMoreValues(eventSink1, (long)100L, (TimeUnit)TimeUnit.MILLISECONDS);
            ConcurrentHelpers.assertNoMoreValues(eventSink2, (long)100L, (TimeUnit)TimeUnit.MILLISECONDS);
            ConcurrentHelpers.assertNoMoreValues(eventSink2, (long)100L, (TimeUnit)TimeUnit.MILLISECONDS);
        }
    }

    @Test
    public void dataSourceStatusProviderReturnsLatestStatus() throws Exception {
        TestData testData = TestData.dataSource();
        LDConfig config = this.baseConfig().dataSource((ComponentConfigurer)testData).events(Components.noEvents()).build();
        Instant timeBeforeStarting = Instant.now();
        try (LDClient client = new LDClient(SDK_KEY, config);){
            DataSourceStatusProvider.Status initialStatus = client.getDataSourceStatusProvider().getStatus();
            MatcherAssert.assertThat((Object)initialStatus.getState(), (Matcher)Matchers.equalTo((Object)DataSourceStatusProvider.State.VALID));
            MatcherAssert.assertThat((Object)initialStatus.getStateSince(), (Matcher)Matchers.greaterThanOrEqualTo((Comparable)timeBeforeStarting));
            MatcherAssert.assertThat((Object)initialStatus.getLastError(), (Matcher)Matchers.nullValue());
            DataSourceStatusProvider.ErrorInfo errorInfo = new DataSourceStatusProvider.ErrorInfo(DataSourceStatusProvider.ErrorKind.ERROR_RESPONSE, 401, null, Instant.now());
            testData.updateStatus(DataSourceStatusProvider.State.OFF, errorInfo);
            DataSourceStatusProvider.Status newStatus = client.getDataSourceStatusProvider().getStatus();
            MatcherAssert.assertThat((Object)newStatus.getState(), (Matcher)Matchers.equalTo((Object)DataSourceStatusProvider.State.OFF));
            MatcherAssert.assertThat((Object)newStatus.getStateSince(), (Matcher)Matchers.greaterThanOrEqualTo((Comparable)errorInfo.getTime()));
            MatcherAssert.assertThat((Object)newStatus.getLastError(), (Matcher)Matchers.equalTo((Object)errorInfo));
        }
    }

    @Test
    public void dataSourceStatusProviderSendsStatusUpdates() throws Exception {
        TestData testData = TestData.dataSource();
        LDConfig config = this.baseConfig().dataSource((ComponentConfigurer)testData).events(Components.noEvents()).build();
        try (LDClient client = new LDClient(SDK_KEY, config);){
            LinkedBlockingQueue statuses = new LinkedBlockingQueue();
            client.getDataSourceStatusProvider().addStatusListener(statuses::add);
            DataSourceStatusProvider.ErrorInfo errorInfo = new DataSourceStatusProvider.ErrorInfo(DataSourceStatusProvider.ErrorKind.ERROR_RESPONSE, 401, null, Instant.now());
            testData.updateStatus(DataSourceStatusProvider.State.OFF, errorInfo);
            DataSourceStatusProvider.Status newStatus = (DataSourceStatusProvider.Status)statuses.take();
            MatcherAssert.assertThat((Object)newStatus.getState(), (Matcher)Matchers.equalTo((Object)DataSourceStatusProvider.State.OFF));
            MatcherAssert.assertThat((Object)newStatus.getStateSince(), (Matcher)Matchers.greaterThanOrEqualTo((Comparable)errorInfo.getTime()));
            MatcherAssert.assertThat((Object)newStatus.getLastError(), (Matcher)Matchers.equalTo((Object)errorInfo));
        }
    }

    @Test
    public void dataStoreStatusMonitoringIsDisabledForInMemoryStore() throws Exception {
        LDConfig config = this.baseConfig().dataSource(Components.externalUpdatesOnly()).events(Components.noEvents()).build();
        try (LDClient client = new LDClient(SDK_KEY, config);){
            MatcherAssert.assertThat((Object)client.getDataStoreStatusProvider().isStatusMonitoringEnabled(), (Matcher)Matchers.equalTo((Object)false));
        }
    }

    @Test
    public void dataStoreStatusMonitoringIsEnabledForPersistentStore() throws Exception {
        LDConfig config = this.baseConfig().dataSource(Components.externalUpdatesOnly()).dataStore((ComponentConfigurer)Components.persistentDataStore(TestComponents.specificComponent(new MockPersistentDataStore()))).events(Components.noEvents()).build();
        try (LDClient client = new LDClient(SDK_KEY, config);){
            MatcherAssert.assertThat((Object)client.getDataStoreStatusProvider().isStatusMonitoringEnabled(), (Matcher)Matchers.equalTo((Object)true));
        }
    }

    @Test
    public void dataStoreStatusProviderReturnsLatestStatus() throws Exception {
        PersistentDataStoreBuilder underlyingStoreFactory = Components.persistentDataStore(TestComponents.specificComponent(new MockPersistentDataStore()));
        TestComponents.ContextCapturingFactory capturingFactory = new TestComponents.ContextCapturingFactory(underlyingStoreFactory);
        LDConfig config = this.baseConfig().dataStore(capturingFactory).build();
        try (LDClient client = new LDClient(SDK_KEY, config);){
            DataStoreStatusProvider.Status originalStatus = new DataStoreStatusProvider.Status(true, false);
            DataStoreStatusProvider.Status newStatus = new DataStoreStatusProvider.Status(false, false);
            MatcherAssert.assertThat((Object)client.getDataStoreStatusProvider().getStatus(), (Matcher)Matchers.equalTo((Object)originalStatus));
            capturingFactory.clientContext.getDataStoreUpdateSink().updateStatus(newStatus);
            MatcherAssert.assertThat((Object)client.getDataStoreStatusProvider().getStatus(), (Matcher)Matchers.equalTo((Object)newStatus));
        }
    }

    @Test
    public void dataStoreStatusProviderSendsStatusUpdates() throws Exception {
        PersistentDataStoreBuilder underlyingStoreFactory = Components.persistentDataStore(TestComponents.specificComponent(new MockPersistentDataStore()));
        TestComponents.ContextCapturingFactory capturingFactory = new TestComponents.ContextCapturingFactory(underlyingStoreFactory);
        LDConfig config = this.baseConfig().dataStore(capturingFactory).build();
        try (LDClient client = new LDClient(SDK_KEY, config);){
            LinkedBlockingQueue statuses = new LinkedBlockingQueue();
            client.getDataStoreStatusProvider().addStatusListener(statuses::add);
            DataStoreStatusProvider.Status newStatus = new DataStoreStatusProvider.Status(false, false);
            capturingFactory.clientContext.getDataStoreUpdateSink().updateStatus(newStatus);
            MatcherAssert.assertThat((Object)((DataStoreStatusProvider.Status)statuses.take()), (Matcher)Matchers.equalTo((Object)newStatus));
        }
    }

    @Test
    public void eventsAreDispatchedOnTaskThread() throws Exception {
        int desiredPriority = 9;
        LinkedBlockingQueue capturedThreads = new LinkedBlockingQueue();
        TestData testData = TestData.dataSource();
        testData.update(testData.flag("flagkey").on(true));
        LDConfig config = this.baseConfig().dataSource((ComponentConfigurer)testData).events(Components.noEvents()).threadPriority(desiredPriority).build();
        try (LDClient client = new LDClient(SDK_KEY, config);){
            client.getFlagTracker().addFlagChangeListener(params -> capturedThreads.add(Thread.currentThread()));
            testData.update(testData.flag("flagkey").on(false));
            Thread handlerThread = (Thread)capturedThreads.take();
            Assert.assertEquals((long)desiredPriority, (long)handlerThread.getPriority());
            MatcherAssert.assertThat((Object)handlerThread.getName(), (Matcher)Matchers.containsString((String)"LaunchDarkly-tasks"));
        }
    }

    @Test
    public void bigSegmentStoreStatusReturnsUnavailableStatusWhenNotConfigured() throws Exception {
        LDConfig config = this.baseConfig().build();
        try (LDClient client = new LDClient(SDK_KEY, config);){
            BigSegmentStoreStatusProvider.Status status = client.getBigSegmentStoreStatusProvider().getStatus();
            Assert.assertFalse((boolean)status.isAvailable());
            Assert.assertFalse((boolean)status.isStale());
        }
    }

    @Test
    public void bigSegmentStoreStatusProviderSendsStatusUpdates() throws Exception {
        EasyMockSupport mocks = new EasyMockSupport();
        AtomicBoolean storeAvailable = new AtomicBoolean(true);
        BigSegmentStore storeMock = (BigSegmentStore)mocks.niceMock(BigSegmentStore.class);
        EasyMock.expect((Object)storeMock.getMetadata()).andAnswer(() -> {
            if (storeAvailable.get()) {
                return new BigSegmentStoreTypes.StoreMetadata(System.currentTimeMillis());
            }
            throw new RuntimeException("sorry");
        }).anyTimes();
        ComponentConfigurer<BigSegmentStore> storeFactory = TestComponents.specificComponent(storeMock);
        EasyMock.replay((Object[])new Object[]{storeMock});
        LDConfig config = this.baseConfig().bigSegments((ComponentConfigurer)Components.bigSegments(storeFactory).statusPollInterval(Duration.ofMillis(10L))).build();
        try (LDClient client = new LDClient(SDK_KEY, config);){
            BigSegmentStoreStatusProvider.Status status1 = client.getBigSegmentStoreStatusProvider().getStatus();
            Assert.assertTrue((boolean)status1.isAvailable());
            LinkedBlockingQueue statuses = new LinkedBlockingQueue();
            client.getBigSegmentStoreStatusProvider().addStatusListener(statuses::add);
            storeAvailable.set(false);
            BigSegmentStoreStatusProvider.Status status = (BigSegmentStoreStatusProvider.Status)statuses.take();
            Assert.assertFalse((boolean)status.isAvailable());
            Assert.assertEquals((Object)status, (Object)client.getBigSegmentStoreStatusProvider().getStatus());
        }
    }
}

