/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.sdk.server;

import com.google.common.collect.ImmutableMap;
import com.launchdarkly.sdk.LDContext;
import com.launchdarkly.sdk.LDValue;
import com.launchdarkly.sdk.server.BaseTest;
import com.launchdarkly.sdk.server.ComponentsImpl;
import com.launchdarkly.sdk.server.FeatureFlagsState;
import com.launchdarkly.sdk.server.FlagsStateOption;
import com.launchdarkly.sdk.server.LDClient;
import com.launchdarkly.sdk.server.LDConfig;
import com.launchdarkly.sdk.server.ModelBuilders;
import com.launchdarkly.sdk.server.TestComponents;
import com.launchdarkly.sdk.server.TestUtil;
import com.launchdarkly.sdk.server.interfaces.DataSourceStatusProvider;
import com.launchdarkly.sdk.server.subsystems.DataStore;
import java.io.IOException;
import org.junit.Assert;
import org.junit.Test;

public class LDClientOfflineTest
extends BaseTest {
    private static final LDContext user = LDContext.create((String)"user");

    @Test
    public void offlineClientHasNullDataSource() throws IOException {
        LDConfig config = this.baseConfig().offline(true).build();
        try (LDClient client = new LDClient("SDK_KEY", config);){
            Assert.assertEquals(ComponentsImpl.NullDataSource.class, client.dataSource.getClass());
        }
    }

    @Test
    public void offlineClientHasNullEventProcessor() throws IOException {
        LDConfig config = this.baseConfig().offline(true).build();
        try (LDClient client = new LDClient("SDK_KEY", config);){
            Assert.assertEquals(ComponentsImpl.NullEventProcessor.class, client.eventProcessor.getClass());
        }
    }

    @Test
    public void offlineClientIsInitialized() throws IOException {
        LDConfig config = this.baseConfig().offline(true).build();
        try (LDClient client = new LDClient("SDK_KEY", config);){
            Assert.assertTrue((boolean)client.isInitialized());
            Assert.assertEquals((Object)DataSourceStatusProvider.State.VALID, (Object)client.getDataSourceStatusProvider().getStatus().getState());
        }
    }

    @Test
    public void offlineClientReturnsDefaultValue() throws IOException {
        LDConfig config = this.baseConfig().offline(true).build();
        try (LDClient client = new LDClient("SDK_KEY", config);){
            Assert.assertEquals((Object)"x", (Object)client.stringVariation("key", user, "x"));
        }
    }

    @Test
    public void offlineClientGetsFlagsStateFromDataStore() throws IOException {
        DataStore testDataStore = TestComponents.initedDataStore();
        LDConfig config = this.baseConfig().offline(true).dataStore(TestComponents.specificComponent(testDataStore)).build();
        TestUtil.upsertFlag(testDataStore, ModelBuilders.flagWithValue("key", LDValue.of((boolean)true)));
        try (LDClient client = new LDClient("SDK_KEY", config);){
            FeatureFlagsState state = client.allFlagsState(user, new FlagsStateOption[0]);
            Assert.assertTrue((boolean)state.isValid());
            Assert.assertEquals((Object)ImmutableMap.of((Object)"key", (Object)LDValue.of((boolean)true)), (Object)state.toValuesMap());
        }
    }
}

