/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.sdk.server;

import com.google.common.collect.ImmutableMap;
import com.launchdarkly.sdk.server.Components;
import com.launchdarkly.sdk.server.LDConfig;
import com.launchdarkly.sdk.server.TestComponents;
import com.launchdarkly.sdk.server.integrations.BigSegmentsConfigurationBuilder;
import com.launchdarkly.sdk.server.integrations.HttpConfigurationBuilder;
import com.launchdarkly.sdk.server.integrations.LoggingConfigurationBuilder;
import com.launchdarkly.sdk.server.interfaces.BigSegmentsConfiguration;
import com.launchdarkly.sdk.server.subsystems.ClientContext;
import com.launchdarkly.sdk.server.subsystems.ComponentConfigurer;
import com.launchdarkly.sdk.server.subsystems.HttpConfiguration;
import com.launchdarkly.sdk.server.subsystems.LoggingConfiguration;
import java.time.Duration;
import org.junit.Assert;
import org.junit.Test;

public class LDConfigTest {
    private static final ClientContext BASIC_CONTEXT = new ClientContext("");

    @Test
    public void defaults() {
        LDConfig config = new LDConfig.Builder().build();
        Assert.assertNotNull((Object)config.bigSegments);
        Assert.assertNull((Object)((BigSegmentsConfiguration)config.bigSegments.build((ClientContext)TestComponents.clientContext("", config))).getStore());
        Assert.assertNotNull((Object)config.dataSource);
        Assert.assertEquals(Components.streamingDataSource().getClass(), config.dataSource.getClass());
        Assert.assertNotNull((Object)config.dataStore);
        Assert.assertEquals(Components.inMemoryDataStore().getClass(), config.dataStore.getClass());
        Assert.assertFalse((boolean)config.diagnosticOptOut);
        Assert.assertNotNull((Object)config.events);
        Assert.assertEquals(Components.sendEvents().getClass(), config.events.getClass());
        Assert.assertFalse((boolean)config.offline);
        Assert.assertNotNull((Object)config.http);
        HttpConfiguration httpConfig = (HttpConfiguration)config.http.build(BASIC_CONTEXT);
        Assert.assertEquals((Object)HttpConfigurationBuilder.DEFAULT_CONNECT_TIMEOUT, (Object)httpConfig.getConnectTimeout());
        Assert.assertNotNull((Object)config.logging);
        LoggingConfiguration loggingConfig = (LoggingConfiguration)config.logging.build(BASIC_CONTEXT);
        Assert.assertEquals((Object)LoggingConfigurationBuilder.DEFAULT_LOG_DATA_SOURCE_OUTAGE_AS_ERROR_AFTER, (Object)loggingConfig.getLogDataSourceOutageAsErrorAfter());
        Assert.assertEquals((Object)LDConfig.DEFAULT_START_WAIT, (Object)config.startWait);
        Assert.assertEquals((long)1L, (long)config.threadPriority);
    }

    @Test
    public void bigSegmentsConfigFactory() {
        BigSegmentsConfigurationBuilder f = Components.bigSegments(null);
        LDConfig config = new LDConfig.Builder().bigSegments((ComponentConfigurer)f).build();
        Assert.assertSame((Object)f, (Object)config.bigSegments);
    }

    @Test
    public void dataSourceFactory() {
        ComponentConfigurer<Object> f = TestComponents.specificComponent(null);
        LDConfig config = new LDConfig.Builder().dataSource(f).build();
        Assert.assertSame(f, (Object)config.dataSource);
    }

    @Test
    public void dataStoreFactory() {
        ComponentConfigurer<Object> f = TestComponents.specificComponent(null);
        LDConfig config = new LDConfig.Builder().dataStore(f).build();
        Assert.assertSame(f, (Object)config.dataStore);
    }

    @Test
    public void diagnosticOptOut() {
        LDConfig config = new LDConfig.Builder().diagnosticOptOut(true).build();
        Assert.assertTrue((boolean)config.diagnosticOptOut);
        LDConfig config1 = new LDConfig.Builder().diagnosticOptOut(true).diagnosticOptOut(false).build();
        Assert.assertFalse((boolean)config1.diagnosticOptOut);
    }

    @Test
    public void eventProcessorFactory() {
        ComponentConfigurer<Object> f = TestComponents.specificComponent(null);
        LDConfig config = new LDConfig.Builder().events(f).build();
        Assert.assertSame(f, (Object)config.events);
    }

    @Test
    public void offline() {
        LDConfig config1 = new LDConfig.Builder().offline(true).build();
        Assert.assertTrue((boolean)config1.offline);
        Assert.assertSame((Object)Components.externalUpdatesOnly(), (Object)config1.dataSource);
        Assert.assertSame((Object)Components.noEvents(), (Object)config1.events);
        LDConfig config2 = new LDConfig.Builder().offline(true).dataSource((ComponentConfigurer)Components.streamingDataSource()).build();
        Assert.assertTrue((boolean)config2.offline);
        Assert.assertSame((Object)Components.externalUpdatesOnly(), (Object)config2.dataSource);
        Assert.assertSame((Object)Components.noEvents(), (Object)config2.events);
        LDConfig config3 = new LDConfig.Builder().offline(true).offline(false).build();
        Assert.assertFalse((boolean)config3.offline);
    }

    @Test
    public void http() {
        HttpConfigurationBuilder b = Components.httpConfiguration().connectTimeout(Duration.ofSeconds(9L));
        LDConfig config = new LDConfig.Builder().http((ComponentConfigurer)b).build();
        Assert.assertEquals((Object)Duration.ofSeconds(9L), (Object)((HttpConfiguration)config.http.build(BASIC_CONTEXT)).getConnectTimeout());
    }

    @Test
    public void logging() {
        LoggingConfigurationBuilder b = Components.logging().logDataSourceOutageAsErrorAfter(Duration.ofSeconds(9L));
        LDConfig config = new LDConfig.Builder().logging((ComponentConfigurer)b).build();
        Assert.assertEquals((Object)Duration.ofSeconds(9L), (Object)((LoggingConfiguration)config.logging.build(BASIC_CONTEXT)).getLogDataSourceOutageAsErrorAfter());
    }

    @Test
    public void startWait() {
        LDConfig config = new LDConfig.Builder().startWait(Duration.ZERO).build();
        Assert.assertEquals((Object)Duration.ZERO, (Object)config.startWait);
        LDConfig config1 = new LDConfig.Builder().startWait(Duration.ZERO).startWait(null).build();
        Assert.assertEquals((Object)LDConfig.DEFAULT_START_WAIT, (Object)config1.startWait);
    }

    @Test
    public void threadPriority() {
        LDConfig config = new LDConfig.Builder().threadPriority(10).build();
        Assert.assertEquals((long)10L, (long)config.threadPriority);
    }

    @Test
    public void testHttpDefaults() {
        LDConfig config = new LDConfig.Builder().build();
        HttpConfiguration hc = (HttpConfiguration)config.http.build(BASIC_CONTEXT);
        HttpConfiguration defaults = (HttpConfiguration)Components.httpConfiguration().build(BASIC_CONTEXT);
        Assert.assertEquals((Object)defaults.getConnectTimeout(), (Object)hc.getConnectTimeout());
        Assert.assertNull((Object)hc.getProxy());
        Assert.assertNull((Object)hc.getProxyAuthentication());
        Assert.assertEquals((Object)defaults.getSocketTimeout(), (Object)hc.getSocketTimeout());
        Assert.assertNull((Object)hc.getSslSocketFactory());
        Assert.assertNull((Object)hc.getTrustManager());
        Assert.assertEquals((Object)ImmutableMap.copyOf((Iterable)defaults.getDefaultHeaders()), (Object)ImmutableMap.copyOf((Iterable)hc.getDefaultHeaders()));
    }
}

