/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.sdk.server;

import com.launchdarkly.sdk.server.BaseTest;
import com.launchdarkly.sdk.server.DataModel;
import com.launchdarkly.sdk.server.DataStoreTestTypes;
import com.launchdarkly.sdk.server.PersistentDataStoreWrapper;
import com.launchdarkly.sdk.server.TestComponents;
import com.launchdarkly.sdk.server.integrations.MockPersistentDataStore;
import com.launchdarkly.sdk.server.integrations.PersistentDataStoreBuilder;
import com.launchdarkly.sdk.server.subsystems.DataStoreTypes;
import com.launchdarkly.sdk.server.subsystems.PersistentDataStore;
import com.launchdarkly.testhelpers.TypeBehavior;
import java.time.Duration;
import java.util.ArrayList;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;

public class PersistentDataStoreWrapperOtherTest
extends BaseTest {
    private static final RuntimeException FAKE_ERROR = new RuntimeException("fake error");
    private final MockPersistentDataStore core = new MockPersistentDataStore();

    private PersistentDataStoreWrapper makeWrapper(Duration cacheTtl, PersistentDataStoreBuilder.StaleValuesPolicy policy) {
        return new PersistentDataStoreWrapper((PersistentDataStore)this.core, cacheTtl, policy, false, status -> {}, TestComponents.sharedExecutor, this.testLogger);
    }

    @Test
    public void cacheKeyEquality() {
        ArrayList<TypeBehavior.ValueFactory> allPermutations = new ArrayList<TypeBehavior.ValueFactory>();
        for (DataStoreTypes.DataKind kind : new DataStoreTypes.DataKind[]{DataModel.FEATURES, DataModel.SEGMENTS}) {
            for (String key : new String[]{"a", "b"}) {
                allPermutations.add(() -> PersistentDataStoreWrapper.CacheKey.forItem((DataStoreTypes.DataKind)kind, (String)key));
            }
        }
        TypeBehavior.checkEqualsAndHashCode(allPermutations);
    }

    @Test
    public void cacheInRefreshModeRefreshesExpiredItem() throws Exception {
        try (PersistentDataStoreWrapper wrapper = this.makeWrapper(Duration.ofMillis(20L), PersistentDataStoreBuilder.StaleValuesPolicy.REFRESH);){
            DataStoreTestTypes.TestItem itemv1 = new DataStoreTestTypes.TestItem("key", 1);
            DataStoreTestTypes.TestItem itemv2 = new DataStoreTestTypes.TestItem(itemv1.key, 2);
            this.core.forceSet(DataStoreTestTypes.TEST_ITEMS, itemv1);
            Assert.assertEquals((long)0L, (long)this.core.getQueryCount);
            DataStoreTypes.ItemDescriptor result1 = wrapper.get(DataStoreTestTypes.TEST_ITEMS, itemv1.key);
            MatcherAssert.assertThat((Object)result1, (Matcher)Matchers.equalTo((Object)itemv1.toItemDescriptor()));
            Assert.assertEquals((long)1L, (long)this.core.getQueryCount);
            this.core.forceSet(DataStoreTestTypes.TEST_ITEMS, itemv2);
            Thread.sleep(50L);
            Assert.assertEquals((long)1L, (long)this.core.getQueryCount);
            DataStoreTypes.ItemDescriptor result2 = wrapper.get(DataStoreTestTypes.TEST_ITEMS, itemv1.key);
            MatcherAssert.assertThat((Object)result2, (Matcher)Matchers.equalTo((Object)itemv2.toItemDescriptor()));
        }
    }

    @Test
    public void cacheInRefreshModeKeepsExpiredItemInCacheIfRefreshFails() throws Exception {
        try (PersistentDataStoreWrapper wrapper = this.makeWrapper(Duration.ofMillis(20L), PersistentDataStoreBuilder.StaleValuesPolicy.REFRESH);){
            DataStoreTestTypes.TestItem item = new DataStoreTestTypes.TestItem("key", 1);
            this.core.forceSet(DataStoreTestTypes.TEST_ITEMS, item);
            Assert.assertEquals((long)0L, (long)this.core.getQueryCount);
            DataStoreTypes.ItemDescriptor result1 = wrapper.get(DataStoreTestTypes.TEST_ITEMS, item.key);
            MatcherAssert.assertThat((Object)result1, (Matcher)Matchers.equalTo((Object)item.toItemDescriptor()));
            Assert.assertEquals((long)1L, (long)this.core.getQueryCount);
            this.core.fakeError = FAKE_ERROR;
            Thread.sleep(50L);
            Assert.assertEquals((long)1L, (long)this.core.getQueryCount);
            DataStoreTypes.ItemDescriptor result2 = wrapper.get(DataStoreTestTypes.TEST_ITEMS, item.key);
            MatcherAssert.assertThat((Object)result2, (Matcher)Matchers.equalTo((Object)item.toItemDescriptor()));
        }
    }
}

