/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.sdk.server;

import com.launchdarkly.sdk.EvaluationReason;
import com.launchdarkly.sdk.LDContext;
import com.launchdarkly.sdk.server.DataModel;
import com.launchdarkly.sdk.server.EvalResult;
import com.launchdarkly.sdk.server.EvaluatorBucketing;
import com.launchdarkly.sdk.server.EvaluatorTestUtil;
import com.launchdarkly.sdk.server.ModelBuilders;
import java.util.ArrayList;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;

public class RolloutRandomizationConsistencyTest {
    private Integer noSeed = null;

    private static DataModel.Rollout buildRollout(boolean isExperiment, boolean untrackedVariations) {
        ArrayList<DataModel.WeightedVariation> variations = new ArrayList<DataModel.WeightedVariation>();
        variations.add(new DataModel.WeightedVariation(0, 10000, untrackedVariations));
        variations.add(new DataModel.WeightedVariation(1, 20000, untrackedVariations));
        variations.add(new DataModel.WeightedVariation(0, 70000, true));
        DataModel.RolloutKind kind = isExperiment ? DataModel.RolloutKind.experiment : DataModel.RolloutKind.rollout;
        Integer seed = 61;
        DataModel.Rollout rollout = new DataModel.Rollout(null, variations, null, kind, seed);
        return rollout;
    }

    @Test
    public void variationIndexForUserInExperimentTest() {
        DataModel.Rollout rollout = RolloutRandomizationConsistencyTest.buildRollout(true, false);
        String key = "hashKey";
        String salt = "saltyA";
        LDContext user1 = LDContext.create((String)"userKeyA");
        RolloutRandomizationConsistencyTest.assertVariationIndexAndExperimentStateForRollout(0, true, rollout, user1, key, salt);
        LDContext user2 = LDContext.create((String)"userKeyB");
        RolloutRandomizationConsistencyTest.assertVariationIndexAndExperimentStateForRollout(1, true, rollout, user2, key, salt);
        LDContext user3 = LDContext.create((String)"userKeyC");
        RolloutRandomizationConsistencyTest.assertVariationIndexAndExperimentStateForRollout(0, false, rollout, user3, key, salt);
    }

    private static void assertVariationIndexAndExperimentStateForRollout(int expectedVariation, boolean expectedInExperiment, DataModel.Rollout rollout, LDContext context, String flagKey, String salt) {
        DataModel.FeatureFlag flag = ModelBuilders.flagBuilder(flagKey).on(true).generatedVariations(3).fallthrough(rollout).salt(salt).build();
        EvalResult result = EvaluatorTestUtil.BASE_EVALUATOR.evaluate(flag, context, EvaluatorTestUtil.expectNoPrerequisiteEvals());
        MatcherAssert.assertThat((Object)result.getVariationIndex(), (Matcher)Matchers.equalTo((Object)expectedVariation));
        MatcherAssert.assertThat((Object)result.getReason().getKind(), (Matcher)Matchers.equalTo((Object)EvaluationReason.Kind.FALLTHROUGH));
        MatcherAssert.assertThat((Object)result.getReason().isInExperiment(), (Matcher)Matchers.equalTo((Object)expectedInExperiment));
    }

    @Test
    public void bucketUserByKeyTest() {
        LDContext user1 = LDContext.create((String)"userKeyA");
        float point1 = EvaluatorBucketing.computeBucketValue((boolean)false, (Integer)this.noSeed, (LDContext)user1, null, (String)"hashKey", null, (String)"saltyA");
        Assert.assertEquals((double)0.42157587, (double)point1, (double)1.0E-7);
        LDContext user2 = LDContext.create((String)"userKeyB");
        float point2 = EvaluatorBucketing.computeBucketValue((boolean)false, (Integer)this.noSeed, (LDContext)user2, null, (String)"hashKey", null, (String)"saltyA");
        Assert.assertEquals((double)0.6708485, (double)point2, (double)1.0E-7);
        LDContext user3 = LDContext.create((String)"userKeyC");
        float point3 = EvaluatorBucketing.computeBucketValue((boolean)false, (Integer)this.noSeed, (LDContext)user3, null, (String)"hashKey", null, (String)"saltyA");
        Assert.assertEquals((double)0.10343106, (double)point3, (double)1.0E-7);
    }

    @Test
    public void bucketUserWithSeedTest() {
        Integer seed = 61;
        LDContext user1 = LDContext.create((String)"userKeyA");
        Float point1 = Float.valueOf(EvaluatorBucketing.computeBucketValue((boolean)true, (Integer)seed, (LDContext)user1, null, (String)"hashKey", null, (String)"saltyA"));
        Assert.assertEquals((double)0.09801207, (double)point1.floatValue(), (double)1.0E-7);
        LDContext user2 = LDContext.create((String)"userKeyB");
        Float point2 = Float.valueOf(EvaluatorBucketing.computeBucketValue((boolean)true, (Integer)seed, (LDContext)user2, null, (String)"hashKey", null, (String)"saltyA"));
        Assert.assertEquals((double)0.14483777, (double)point2.floatValue(), (double)1.0E-7);
        LDContext user3 = LDContext.create((String)"userKeyC");
        Float point3 = Float.valueOf(EvaluatorBucketing.computeBucketValue((boolean)true, (Integer)seed, (LDContext)user3, null, (String)"hashKey", null, (String)"saltyA"));
        Assert.assertEquals((double)0.9242641, (double)point3.floatValue(), (double)1.0E-7);
    }
}

