/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.sdk.server;

import com.launchdarkly.sdk.server.SemanticVersion;
import org.junit.Assert;
import org.junit.Test;

public class SemanticVersionTest {
    @Test
    public void canParseSimpleCompleteVersion() throws Exception {
        SemanticVersion sv = SemanticVersion.parse((String)"2.3.4");
        Assert.assertEquals((long)2L, (long)sv.getMajor());
        Assert.assertEquals((long)3L, (long)sv.getMinor());
        Assert.assertEquals((long)4L, (long)sv.getPatch());
        Assert.assertNull((Object)sv.getPrerelease());
        Assert.assertNull((Object)sv.getBuild());
    }

    @Test
    public void canParseVersionWithPrerelease() throws Exception {
        SemanticVersion sv = SemanticVersion.parse((String)"2.3.4-beta1.rc2");
        Assert.assertEquals((long)2L, (long)sv.getMajor());
        Assert.assertEquals((long)3L, (long)sv.getMinor());
        Assert.assertEquals((long)4L, (long)sv.getPatch());
        Assert.assertEquals((Object)"beta1.rc2", (Object)sv.getPrerelease());
        Assert.assertNull((Object)sv.getBuild());
    }

    @Test
    public void canParseVersionWithBuild() throws Exception {
        SemanticVersion sv = SemanticVersion.parse((String)"2.3.4+build2.4");
        Assert.assertEquals((long)2L, (long)sv.getMajor());
        Assert.assertEquals((long)3L, (long)sv.getMinor());
        Assert.assertEquals((long)4L, (long)sv.getPatch());
        Assert.assertNull((Object)sv.getPrerelease());
        Assert.assertEquals((Object)"build2.4", (Object)sv.getBuild());
    }

    @Test
    public void canParseVersionWithPrereleaseAndBuild() throws Exception {
        SemanticVersion sv = SemanticVersion.parse((String)"2.3.4-beta1.rc2+build2.4");
        Assert.assertEquals((long)2L, (long)sv.getMajor());
        Assert.assertEquals((long)3L, (long)sv.getMinor());
        Assert.assertEquals((long)4L, (long)sv.getPatch());
        Assert.assertEquals((Object)"beta1.rc2", (Object)sv.getPrerelease());
        Assert.assertEquals((Object)"build2.4", (Object)sv.getBuild());
    }

    @Test(expected=SemanticVersion.InvalidVersionException.class)
    public void leadingZeroNotAllowedInMajor() throws Exception {
        SemanticVersion.parse((String)"02.3.4");
    }

    @Test(expected=SemanticVersion.InvalidVersionException.class)
    public void leadingZeroNotAllowedInMinor() throws Exception {
        SemanticVersion.parse((String)"2.03.4");
    }

    @Test(expected=SemanticVersion.InvalidVersionException.class)
    public void leadingZeroNotAllowedInPatch() throws Exception {
        SemanticVersion.parse((String)"2.3.04");
    }

    @Test
    public void zeroByItselfIsAllowed() throws Exception {
        Assert.assertEquals((long)0L, (long)SemanticVersion.parse((String)"0.3.4").getMajor());
        Assert.assertEquals((long)0L, (long)SemanticVersion.parse((String)"2.0.4").getMinor());
        Assert.assertEquals((long)0L, (long)SemanticVersion.parse((String)"2.3.0").getPatch());
    }

    @Test
    public void canParseVersionWithMajorOnly() throws Exception {
        SemanticVersion sv = SemanticVersion.parse((String)"2", (boolean)true);
        Assert.assertEquals((long)2L, (long)sv.getMajor());
        Assert.assertEquals((long)0L, (long)sv.getMinor());
        Assert.assertEquals((long)0L, (long)sv.getPatch());
        Assert.assertNull((Object)sv.getPrerelease());
        Assert.assertNull((Object)sv.getBuild());
    }

    @Test(expected=SemanticVersion.InvalidVersionException.class)
    public void cannotParseVersionWithMajorOnlyIfFlagNotSet() throws Exception {
        SemanticVersion.parse((String)"2");
    }

    @Test
    public void canParseVersionWithMajorAndMinorOnly() throws Exception {
        SemanticVersion sv = SemanticVersion.parse((String)"2.3", (boolean)true);
        Assert.assertEquals((long)2L, (long)sv.getMajor());
        Assert.assertEquals((long)3L, (long)sv.getMinor());
        Assert.assertEquals((long)0L, (long)sv.getPatch());
        Assert.assertNull((Object)sv.getPrerelease());
        Assert.assertNull((Object)sv.getBuild());
    }

    @Test(expected=SemanticVersion.InvalidVersionException.class)
    public void cannotParseVersionWithMajorAndMinorOnlyIfFlagNotSet() throws Exception {
        SemanticVersion.parse((String)"2.3");
    }

    @Test
    public void canParseVersionWithMajorAndPrereleaseOnly() throws Exception {
        SemanticVersion sv = SemanticVersion.parse((String)"2-beta1", (boolean)true);
        Assert.assertEquals((long)2L, (long)sv.getMajor());
        Assert.assertEquals((long)0L, (long)sv.getMinor());
        Assert.assertEquals((long)0L, (long)sv.getPatch());
        Assert.assertEquals((Object)"beta1", (Object)sv.getPrerelease());
        Assert.assertNull((Object)sv.getBuild());
    }

    @Test
    public void canParseVersionWithMajorMinorAndPrereleaseOnly() throws Exception {
        SemanticVersion sv = SemanticVersion.parse((String)"2.3-beta1", (boolean)true);
        Assert.assertEquals((long)2L, (long)sv.getMajor());
        Assert.assertEquals((long)3L, (long)sv.getMinor());
        Assert.assertEquals((long)0L, (long)sv.getPatch());
        Assert.assertEquals((Object)"beta1", (Object)sv.getPrerelease());
        Assert.assertNull((Object)sv.getBuild());
    }

    @Test
    public void canParseVersionWithMajorAndBuildOnly() throws Exception {
        SemanticVersion sv = SemanticVersion.parse((String)"2+build1", (boolean)true);
        Assert.assertEquals((long)2L, (long)sv.getMajor());
        Assert.assertEquals((long)0L, (long)sv.getMinor());
        Assert.assertEquals((long)0L, (long)sv.getPatch());
        Assert.assertNull((Object)sv.getPrerelease());
        Assert.assertEquals((Object)"build1", (Object)sv.getBuild());
    }

    @Test
    public void canParseVersionWithMajorMinorAndBuildOnly() throws Exception {
        SemanticVersion sv = SemanticVersion.parse((String)"2.3+build1", (boolean)true);
        Assert.assertEquals((long)2L, (long)sv.getMajor());
        Assert.assertEquals((long)3L, (long)sv.getMinor());
        Assert.assertEquals((long)0L, (long)sv.getPatch());
        Assert.assertNull((Object)sv.getPrerelease());
        Assert.assertEquals((Object)"build1", (Object)sv.getBuild());
    }

    @Test(expected=SemanticVersion.InvalidVersionException.class)
    public void majorVersionMustBeNumeric() throws Exception {
        SemanticVersion.parse((String)"x.0.0");
    }

    @Test(expected=SemanticVersion.InvalidVersionException.class)
    public void minorVersionMustBeNumeric() throws Exception {
        SemanticVersion.parse((String)"0.x.0");
    }

    @Test(expected=SemanticVersion.InvalidVersionException.class)
    public void patchVersionMustBeNumeric() throws Exception {
        SemanticVersion.parse((String)"0.0.x");
    }

    @Test
    public void equalVersionsHaveEqualPrecedence() throws Exception {
        SemanticVersion sv1 = SemanticVersion.parse((String)"2.3.4-beta1");
        SemanticVersion sv2 = SemanticVersion.parse((String)"2.3.4-beta1");
        Assert.assertEquals((long)0L, (long)sv1.comparePrecedence(sv2));
        SemanticVersion sv3 = SemanticVersion.parse((String)"2.3.4");
        SemanticVersion sv4 = SemanticVersion.parse((String)"2.3.4");
        Assert.assertEquals((long)0L, (long)sv3.comparePrecedence(sv4));
    }

    @Test
    public void lowerMajorVersionHasLowerPrecedence() throws Exception {
        SemanticVersion sv1 = SemanticVersion.parse((String)"1.3.4-beta1");
        SemanticVersion sv2 = SemanticVersion.parse((String)"2.3.4-beta1");
        Assert.assertEquals((long)-1L, (long)sv1.comparePrecedence(sv2));
        Assert.assertEquals((long)1L, (long)sv2.comparePrecedence(sv1));
    }

    @Test
    public void lowerMinorVersionHasLowerPrecedence() throws Exception {
        SemanticVersion sv1 = SemanticVersion.parse((String)"2.2.4-beta1");
        SemanticVersion sv2 = SemanticVersion.parse((String)"2.3.4-beta1");
        Assert.assertEquals((long)-1L, (long)sv1.comparePrecedence(sv2));
        Assert.assertEquals((long)1L, (long)sv2.comparePrecedence(sv1));
    }

    @Test
    public void lowerPatchVersionHasLowerPrecedence() throws Exception {
        SemanticVersion sv1 = SemanticVersion.parse((String)"2.3.3-beta1");
        SemanticVersion sv2 = SemanticVersion.parse((String)"2.3.4-beta1");
        Assert.assertEquals((long)-1L, (long)sv1.comparePrecedence(sv2));
        Assert.assertEquals((long)1L, (long)sv2.comparePrecedence(sv1));
    }

    @Test
    public void prereleaseVersionHasLowerPrecedenceThanRelease() throws Exception {
        SemanticVersion sv1 = SemanticVersion.parse((String)"2.3.4-beta1");
        SemanticVersion sv2 = SemanticVersion.parse((String)"2.3.4");
        Assert.assertEquals((long)-1L, (long)sv1.comparePrecedence(sv2));
        Assert.assertEquals((long)1L, (long)sv2.comparePrecedence(sv1));
    }

    @Test
    public void shorterSubsetOfPrereleaseIdentifiersHasLowerPrecedence() throws Exception {
        SemanticVersion sv1 = SemanticVersion.parse((String)"2.3.4-beta1");
        SemanticVersion sv2 = SemanticVersion.parse((String)"2.3.4-beta1.rc1");
        Assert.assertEquals((long)-1L, (long)sv1.comparePrecedence(sv2));
        Assert.assertEquals((long)1L, (long)sv2.comparePrecedence(sv1));
    }

    @Test
    public void numericPrereleaseIdentifiersAreSortedNumerically() throws Exception {
        SemanticVersion sv1 = SemanticVersion.parse((String)"2.3.4-beta1.3");
        SemanticVersion sv2 = SemanticVersion.parse((String)"2.3.4-beta1.23");
        Assert.assertEquals((long)-1L, (long)sv1.comparePrecedence(sv2));
        Assert.assertEquals((long)1L, (long)sv2.comparePrecedence(sv1));
    }

    @Test
    public void nonNumericPrereleaseIdentifiersAreSortedAsStrings() throws Exception {
        SemanticVersion sv1 = SemanticVersion.parse((String)"2.3.4-beta1.x3");
        SemanticVersion sv2 = SemanticVersion.parse((String)"2.3.4-beta1.x23");
        Assert.assertEquals((long)1L, (long)sv1.comparePrecedence(sv2));
        Assert.assertEquals((long)-1L, (long)sv2.comparePrecedence(sv1));
    }

    @Test
    public void numericPrereleaseIdentifiersAreLowerThanStrings() throws Exception {
        SemanticVersion sv1 = SemanticVersion.parse((String)"2.3.4-beta1.x.100");
        SemanticVersion sv2 = SemanticVersion.parse((String)"2.3.4-beta1.3.100");
        Assert.assertEquals((long)1L, (long)sv1.comparePrecedence(sv2));
        Assert.assertEquals((long)-1L, (long)sv2.comparePrecedence(sv1));
    }

    @Test
    public void buildIdentifierDoesNotAffectPrecedence() throws Exception {
        SemanticVersion sv1 = SemanticVersion.parse((String)"2.3.4-beta1+build1");
        SemanticVersion sv2 = SemanticVersion.parse((String)"2.3.4-beta1+build2");
        Assert.assertEquals((long)0L, (long)sv1.comparePrecedence(sv2));
        Assert.assertEquals((long)0L, (long)sv2.comparePrecedence(sv1));
    }

    @Test
    public void anyVersionIsGreaterThanNull() throws Exception {
        SemanticVersion sv = SemanticVersion.parse((String)"0.0.0");
        Assert.assertEquals((long)1L, (long)sv.comparePrecedence(null));
        Assert.assertEquals((long)1L, (long)sv.compareTo(null));
    }
}

