/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.sdk.server;

import com.launchdarkly.sdk.LDValue;
import com.launchdarkly.sdk.ObjectBuilder;
import com.launchdarkly.sdk.internal.events.DiagnosticStore;
import com.launchdarkly.sdk.server.ClientContextImpl;
import com.launchdarkly.sdk.server.Components;
import com.launchdarkly.sdk.server.LDConfig;
import com.launchdarkly.sdk.server.ServerSideDiagnosticEvents;
import com.launchdarkly.sdk.server.TestComponents;
import com.launchdarkly.sdk.server.TestUtil;
import com.launchdarkly.sdk.server.integrations.PollingDataSourceBuilder;
import com.launchdarkly.sdk.server.subsystems.ClientContext;
import com.launchdarkly.sdk.server.subsystems.ComponentConfigurer;
import com.launchdarkly.sdk.server.subsystems.DataSource;
import com.launchdarkly.sdk.server.subsystems.DataStore;
import com.launchdarkly.sdk.server.subsystems.DiagnosticDescription;
import com.launchdarkly.sdk.server.subsystems.PersistentDataStore;
import com.launchdarkly.testhelpers.JsonAssertions;
import com.launchdarkly.testhelpers.JsonTestValue;
import java.net.URI;
import java.time.Duration;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;

public class ServerSideDiagnosticEventsTest {
    private static final URI CUSTOM_URI = URI.create("http://1.1.1.1");

    @Test
    public void sdkDataProperties() {
        LDValue sdkData = ServerSideDiagnosticEventsTest.makeSdkData(LDConfig.DEFAULT);
        MatcherAssert.assertThat((Object)JsonTestValue.jsonFromValue((Object)sdkData), (Matcher)Matchers.allOf((Matcher)JsonAssertions.jsonProperty((String)"name", (Matcher)JsonAssertions.jsonEqualsValue((Object)"java-server-sdk")), (Matcher)JsonAssertions.jsonProperty((String)"version", (Matcher)JsonAssertions.jsonEqualsValue((Object)"6.3.0")), (Matcher)JsonAssertions.jsonProperty((String)"wrapperName", (Matcher)JsonAssertions.jsonUndefined()), (Matcher)JsonAssertions.jsonProperty((String)"wrapperVersion", (Matcher)JsonAssertions.jsonUndefined())));
    }

    @Test
    public void sdkDataWrapperProperties() {
        LDConfig config1 = new LDConfig.Builder().http((ComponentConfigurer)Components.httpConfiguration().wrapper("Scala", "0.1.0")).build();
        LDValue sdkData1 = ServerSideDiagnosticEventsTest.makeSdkData(config1);
        MatcherAssert.assertThat((Object)JsonTestValue.jsonFromValue((Object)sdkData1), (Matcher)Matchers.allOf((Matcher)JsonAssertions.jsonProperty((String)"wrapperName", (Matcher)JsonAssertions.jsonEqualsValue((Object)"Scala")), (Matcher)JsonAssertions.jsonProperty((String)"wrapperVersion", (Matcher)JsonAssertions.jsonEqualsValue((Object)"0.1.0"))));
        LDConfig config2 = new LDConfig.Builder().http((ComponentConfigurer)Components.httpConfiguration().wrapper("Scala", null)).build();
        LDValue sdkData2 = ServerSideDiagnosticEventsTest.makeSdkData(config2);
        MatcherAssert.assertThat((Object)JsonTestValue.jsonFromValue((Object)sdkData2), (Matcher)Matchers.allOf((Matcher)JsonAssertions.jsonProperty((String)"wrapperName", (Matcher)JsonAssertions.jsonEqualsValue((Object)"Scala")), (Matcher)JsonAssertions.jsonProperty((String)"wrapperVersion", (Matcher)JsonAssertions.jsonUndefined())));
    }

    @Test
    public void platformDataOsNames() {
        String realOsName = System.getProperty("os.name");
        try {
            System.setProperty("os.name", "Mac OS X");
            MatcherAssert.assertThat((Object)JsonTestValue.jsonFromValue((Object)ServerSideDiagnosticEventsTest.makePlatformData()), (Matcher)JsonAssertions.jsonProperty((String)"osName", (Matcher)JsonAssertions.jsonEqualsValue((Object)"MacOS")));
            System.setProperty("os.name", "Windows 10");
            MatcherAssert.assertThat((Object)JsonTestValue.jsonFromValue((Object)ServerSideDiagnosticEventsTest.makePlatformData()), (Matcher)JsonAssertions.jsonProperty((String)"osName", (Matcher)JsonAssertions.jsonEqualsValue((Object)"Windows")));
            System.setProperty("os.name", "Linux");
            MatcherAssert.assertThat((Object)JsonTestValue.jsonFromValue((Object)ServerSideDiagnosticEventsTest.makePlatformData()), (Matcher)JsonAssertions.jsonProperty((String)"osName", (Matcher)JsonAssertions.jsonEqualsValue((Object)"Linux")));
            System.clearProperty("os.name");
            MatcherAssert.assertThat((Object)JsonTestValue.jsonFromValue((Object)ServerSideDiagnosticEventsTest.makePlatformData()), (Matcher)JsonAssertions.jsonProperty((String)"osName", (Matcher)JsonAssertions.jsonUndefined()));
        }
        finally {
            System.setProperty("os.name", realOsName);
        }
    }

    private ObjectBuilder expectedDefaultProperties() {
        return this.expectedDefaultPropertiesWithoutStreaming().put("reconnectTimeMillis", 1000);
    }

    private ObjectBuilder expectedDefaultPropertiesWithoutStreaming() {
        return LDValue.buildObject().put("allAttributesPrivate", false).put("connectTimeoutMillis", 2000).put("customBaseURI", false).put("customEventsURI", false).put("customStreamURI", false).put("dataStoreType", "memory").put("diagnosticRecordingIntervalMillis", 900000).put("eventsCapacity", 10000).put("eventsFlushIntervalMillis", 5000).put("samplingInterval", 0).put("socketTimeoutMillis", 10000).put("startWaitMillis", 5000).put("streamingDisabled", false).put("userKeysCapacity", 1000).put("userKeysFlushIntervalMillis", 300000).put("usingProxy", false).put("usingProxyAuthenticator", false).put("usingRelayDaemon", false);
    }

    private static LDValue makeSdkData(LDConfig config) {
        return ServerSideDiagnosticEventsTest.makeDiagnosticInitEvent(config).get("sdk");
    }

    private static LDValue makePlatformData() {
        return ServerSideDiagnosticEventsTest.makeDiagnosticInitEvent(LDConfig.DEFAULT).get("platform");
    }

    private static LDValue makeConfigData(LDConfig config) {
        return ServerSideDiagnosticEventsTest.makeDiagnosticInitEvent(config).get("configuration");
    }

    private static LDValue makeDiagnosticInitEvent(LDConfig config) {
        ClientContextImpl context = TestComponents.clientContext("SDK_KEY", config);
        DiagnosticStore diagnosticStore = new DiagnosticStore(ServerSideDiagnosticEvents.getSdkDiagnosticParams((ClientContext)context, (LDConfig)config));
        return diagnosticStore.getInitEvent().getJsonValue();
    }

    @Test
    public void testDefaultDiagnosticConfiguration() {
        LDConfig ldConfig = new LDConfig.Builder().build();
        LDValue diagnosticJson = ServerSideDiagnosticEventsTest.makeConfigData(ldConfig);
        LDValue expected = this.expectedDefaultProperties().build();
        Assert.assertEquals((Object)expected, (Object)diagnosticJson);
    }

    @Test
    public void testCustomDiagnosticConfigurationGeneralProperties() {
        LDConfig ldConfig = new LDConfig.Builder().startWait(Duration.ofSeconds(10L)).build();
        LDValue diagnosticJson = ServerSideDiagnosticEventsTest.makeConfigData(ldConfig);
        LDValue expected = this.expectedDefaultProperties().put("startWaitMillis", 10000).build();
        TestUtil.assertJsonEquals(expected, diagnosticJson);
    }

    @Test
    public void testCustomDiagnosticConfigurationForServiceEndpoints() {
        LDConfig ldConfig1 = new LDConfig.Builder().serviceEndpoints(Components.serviceEndpoints().streaming(CUSTOM_URI).events(CUSTOM_URI).polling(CUSTOM_URI)).build();
        LDValue expected1 = this.expectedDefaultProperties().put("customStreamURI", true).put("customEventsURI", true).build();
        TestUtil.assertJsonEquals(expected1, ServerSideDiagnosticEventsTest.makeConfigData(ldConfig1));
        LDConfig ldConfig2 = new LDConfig.Builder().serviceEndpoints(Components.serviceEndpoints().events(CUSTOM_URI).polling(CUSTOM_URI)).dataSource((ComponentConfigurer)Components.pollingDataSource()).events((ComponentConfigurer)Components.sendEvents()).build();
        LDValue expected2 = this.expectedDefaultPropertiesWithoutStreaming().put("customBaseURI", true).put("customEventsURI", true).put("customStreamURI", false).put("pollingIntervalMillis", PollingDataSourceBuilder.DEFAULT_POLL_INTERVAL.toMillis()).put("streamingDisabled", true).build();
        TestUtil.assertJsonEquals(expected2, ServerSideDiagnosticEventsTest.makeConfigData(ldConfig2));
    }

    @Test
    public void testCustomDiagnosticConfigurationForStreaming() {
        LDConfig ldConfig1 = new LDConfig.Builder().dataSource((ComponentConfigurer)Components.streamingDataSource().initialReconnectDelay(Duration.ofSeconds(2L))).build();
        LDValue expected1 = this.expectedDefaultPropertiesWithoutStreaming().put("reconnectTimeMillis", 2000).build();
        TestUtil.assertJsonEquals(expected1, ServerSideDiagnosticEventsTest.makeConfigData(ldConfig1));
        LDConfig ldConfig2 = new LDConfig.Builder().dataSource((ComponentConfigurer)Components.streamingDataSource()).build();
        LDValue expected2 = this.expectedDefaultProperties().build();
        Assert.assertEquals((Object)expected2, (Object)ServerSideDiagnosticEventsTest.makeConfigData(ldConfig2));
    }

    @Test
    public void testCustomDiagnosticConfigurationForPolling() {
        LDConfig ldConfig1 = new LDConfig.Builder().dataSource((ComponentConfigurer)Components.pollingDataSource().pollInterval(Duration.ofSeconds(60L))).build();
        LDValue expected1 = this.expectedDefaultPropertiesWithoutStreaming().put("pollingIntervalMillis", 60000).put("streamingDisabled", true).build();
        TestUtil.assertJsonEquals(expected1, ServerSideDiagnosticEventsTest.makeConfigData(ldConfig1));
        LDConfig ldConfig2 = new LDConfig.Builder().dataSource((ComponentConfigurer)Components.pollingDataSource()).build();
        LDValue expected2 = this.expectedDefaultPropertiesWithoutStreaming().put("pollingIntervalMillis", PollingDataSourceBuilder.DEFAULT_POLL_INTERVAL.toMillis()).put("streamingDisabled", true).build();
        TestUtil.assertJsonEquals(expected2, ServerSideDiagnosticEventsTest.makeConfigData(ldConfig2));
    }

    @Test
    public void testCustomDiagnosticConfigurationForCustomDataStore() {
        LDConfig ldConfig1 = new LDConfig.Builder().dataStore((ComponentConfigurer)new DataStoreFactoryWithDiagnosticDescription(LDValue.of((String)"my-test-store"))).build();
        LDValue expected1 = this.expectedDefaultProperties().put("dataStoreType", "my-test-store").build();
        TestUtil.assertJsonEquals(expected1, ServerSideDiagnosticEventsTest.makeConfigData(ldConfig1));
        LDConfig ldConfig2 = new LDConfig.Builder().dataStore((ComponentConfigurer)new DataStoreFactoryWithoutDiagnosticDescription()).build();
        LDValue expected2 = this.expectedDefaultProperties().put("dataStoreType", "custom").build();
        TestUtil.assertJsonEquals(expected2, ServerSideDiagnosticEventsTest.makeConfigData(ldConfig2));
        LDConfig ldConfig3 = new LDConfig.Builder().dataStore((ComponentConfigurer)new DataStoreFactoryWithDiagnosticDescription(null)).build();
        LDValue expected3 = this.expectedDefaultProperties().put("dataStoreType", "custom").build();
        TestUtil.assertJsonEquals(expected3, ServerSideDiagnosticEventsTest.makeConfigData(ldConfig3));
        LDConfig ldConfig4 = new LDConfig.Builder().dataStore((ComponentConfigurer)new DataStoreFactoryWithDiagnosticDescription(LDValue.of((int)4))).build();
        LDValue expected4 = this.expectedDefaultProperties().put("dataStoreType", "custom").build();
        TestUtil.assertJsonEquals(expected4, ServerSideDiagnosticEventsTest.makeConfigData(ldConfig4));
    }

    @Test
    public void testCustomDiagnosticConfigurationForPersistentDataStore() {
        LDConfig ldConfig1 = new LDConfig.Builder().dataStore((ComponentConfigurer)Components.persistentDataStore((ComponentConfigurer)new PersistentDataStoreFactoryWithComponentName())).build();
        LDValue diagnosticJson1 = ServerSideDiagnosticEventsTest.makeConfigData(ldConfig1);
        LDValue expected1 = this.expectedDefaultProperties().put("dataStoreType", "my-test-store").build();
        TestUtil.assertJsonEquals(expected1, diagnosticJson1);
        LDConfig ldConfig2 = new LDConfig.Builder().dataStore((ComponentConfigurer)Components.persistentDataStore((ComponentConfigurer)new PersistentDataStoreFactoryWithoutComponentName())).build();
        LDValue diagnosticJson2 = ServerSideDiagnosticEventsTest.makeConfigData(ldConfig2);
        LDValue expected2 = this.expectedDefaultProperties().put("dataStoreType", "custom").build();
        TestUtil.assertJsonEquals(expected2, diagnosticJson2);
    }

    @Test
    public void testCustomDiagnosticConfigurationForEvents() {
        LDConfig ldConfig1 = new LDConfig.Builder().events((ComponentConfigurer)Components.sendEvents().allAttributesPrivate(true).capacity(20000).diagnosticRecordingInterval(Duration.ofSeconds(1800L)).flushInterval(Duration.ofSeconds(10L)).userKeysCapacity(2000).userKeysFlushInterval(Duration.ofSeconds(600L))).build();
        LDValue diagnosticJson1 = ServerSideDiagnosticEventsTest.makeConfigData(ldConfig1);
        LDValue expected1 = this.expectedDefaultProperties().put("allAttributesPrivate", true).put("diagnosticRecordingIntervalMillis", 1800000).put("eventsCapacity", 20000).put("eventsFlushIntervalMillis", 10000).put("userKeysCapacity", 2000).put("userKeysFlushIntervalMillis", 600000).build();
        TestUtil.assertJsonEquals(expected1, diagnosticJson1);
        LDConfig ldConfig2 = new LDConfig.Builder().events((ComponentConfigurer)Components.sendEvents()).build();
        LDValue diagnosticJson2 = ServerSideDiagnosticEventsTest.makeConfigData(ldConfig2);
        LDValue expected2 = this.expectedDefaultProperties().build();
        TestUtil.assertJsonEquals(expected2, diagnosticJson2);
    }

    @Test
    public void testCustomDiagnosticConfigurationForDaemonMode() {
        LDConfig ldConfig = new LDConfig.Builder().dataSource(Components.externalUpdatesOnly()).build();
        LDValue diagnosticJson = ServerSideDiagnosticEventsTest.makeConfigData(ldConfig);
        LDValue expected = this.expectedDefaultPropertiesWithoutStreaming().put("usingRelayDaemon", true).build();
        TestUtil.assertJsonEquals(expected, diagnosticJson);
    }

    @Test
    public void testCustomDiagnosticConfigurationHttpProperties() {
        LDConfig ldConfig = new LDConfig.Builder().http((ComponentConfigurer)Components.httpConfiguration().connectTimeout(Duration.ofSeconds(5L)).socketTimeout(Duration.ofSeconds(20L)).proxyHostAndPort("localhost", 1234).proxyAuth(Components.httpBasicAuthentication((String)"username", (String)"password"))).build();
        LDValue diagnosticJson = ServerSideDiagnosticEventsTest.makeConfigData(ldConfig);
        LDValue expected = this.expectedDefaultProperties().put("connectTimeoutMillis", 5000).put("socketTimeoutMillis", 20000).put("usingProxy", true).put("usingProxyAuthenticator", true).build();
        TestUtil.assertJsonEquals(expected, diagnosticJson);
    }

    @Test
    public void customComponentCannotInjectUnsupportedConfigProperty() {
        String unsupportedPropertyName = "fake";
        LDValue description = LDValue.buildObject().put(unsupportedPropertyName, true).build();
        LDConfig config = new LDConfig.Builder().dataSource((ComponentConfigurer)new DataSourceFactoryWithDiagnosticDescription(description)).build();
        LDValue diagnosticJson = ServerSideDiagnosticEventsTest.makeConfigData(config);
        MatcherAssert.assertThat((Object)JsonTestValue.jsonFromValue((Object)diagnosticJson), (Matcher)JsonAssertions.jsonProperty((String)unsupportedPropertyName, (Matcher)JsonAssertions.jsonUndefined()));
    }

    @Test
    public void customComponentCannotInjectSupportedConfigPropertyWithWrongType() {
        LDValue description = LDValue.buildObject().put("streamingDisabled", 3).build();
        LDConfig config = new LDConfig.Builder().dataSource((ComponentConfigurer)new DataSourceFactoryWithDiagnosticDescription(description)).build();
        LDValue diagnosticJson = ServerSideDiagnosticEventsTest.makeConfigData(config);
        MatcherAssert.assertThat((Object)JsonTestValue.jsonFromValue((Object)diagnosticJson), (Matcher)JsonAssertions.jsonProperty((String)"streamingDisabled", (Matcher)JsonAssertions.jsonUndefined()));
    }

    @Test
    public void customComponentDescriptionOfUnsupportedTypeIsIgnored() {
        LDConfig config1 = new LDConfig.Builder().dataSource((ComponentConfigurer)new DataSourceFactoryWithDiagnosticDescription(LDValue.of((int)3))).build();
        LDConfig config2 = new LDConfig.Builder().dataSource((ComponentConfigurer)new DataSourceFactoryWithoutDiagnosticDescription()).build();
        LDValue diagnosticJson1 = ServerSideDiagnosticEventsTest.makeConfigData(config1);
        LDValue diagnosticJson2 = ServerSideDiagnosticEventsTest.makeConfigData(config2);
        TestUtil.assertJsonEquals(diagnosticJson1, diagnosticJson2);
    }

    private static class PersistentDataStoreFactoryWithoutComponentName
    implements ComponentConfigurer<PersistentDataStore> {
        private PersistentDataStoreFactoryWithoutComponentName() {
        }

        public PersistentDataStore build(ClientContext context) {
            return null;
        }
    }

    private static class PersistentDataStoreFactoryWithComponentName
    implements ComponentConfigurer<PersistentDataStore>,
    DiagnosticDescription {
        private PersistentDataStoreFactoryWithComponentName() {
        }

        public LDValue describeConfiguration(ClientContext clientContext) {
            return LDValue.of((String)"my-test-store");
        }

        public PersistentDataStore build(ClientContext context) {
            return null;
        }
    }

    private static class DataStoreFactoryWithoutDiagnosticDescription
    implements ComponentConfigurer<DataStore> {
        private DataStoreFactoryWithoutDiagnosticDescription() {
        }

        public DataStore build(ClientContext context) {
            return null;
        }
    }

    private static class DataStoreFactoryWithDiagnosticDescription
    implements ComponentConfigurer<DataStore>,
    DiagnosticDescription {
        private final LDValue value;

        DataStoreFactoryWithDiagnosticDescription(LDValue value) {
            this.value = value;
        }

        public LDValue describeConfiguration(ClientContext clientContext) {
            return this.value;
        }

        public DataStore build(ClientContext context) {
            return null;
        }
    }

    private static class DataSourceFactoryWithoutDiagnosticDescription
    implements ComponentConfigurer<DataSource> {
        private DataSourceFactoryWithoutDiagnosticDescription() {
        }

        public DataSource build(ClientContext context) {
            return null;
        }
    }

    private static class DataSourceFactoryWithDiagnosticDescription
    implements ComponentConfigurer<DataSource>,
    DiagnosticDescription {
        private final LDValue value;

        DataSourceFactoryWithDiagnosticDescription(LDValue value) {
            this.value = value;
        }

        public LDValue describeConfiguration(ClientContext clientContext) {
            return this.value;
        }

        public DataSource build(ClientContext context) {
            return null;
        }
    }
}

