/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.sdk.server;

import com.launchdarkly.sdk.ContextKind;
import com.launchdarkly.sdk.LDContext;
import com.launchdarkly.sdk.server.ServerSideEventContextDeduplicator;
import java.time.Duration;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Test;

public class ServerSideEventContextDeduplicatorTest {
    private static final Duration LONG_INTERVAL = Duration.ofHours(3L);

    @Test
    public void configuredFlushIntervalIsReturned() {
        ServerSideEventContextDeduplicator ecd = new ServerSideEventContextDeduplicator(1000, LONG_INTERVAL);
        MatcherAssert.assertThat((Object)ecd.getFlushInterval(), (Matcher)Matchers.equalTo((Object)LONG_INTERVAL.toMillis()));
    }

    @Test
    public void singleKindContextKeysAreDeduplicated() {
        ServerSideEventContextDeduplicator ecd = new ServerSideEventContextDeduplicator(1000, LONG_INTERVAL);
        MatcherAssert.assertThat((Object)ecd.processContext(LDContext.create((String)"a")), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)ecd.processContext(LDContext.create((String)"b")), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)ecd.processContext(LDContext.create((String)"a")), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)ecd.processContext(LDContext.create((String)"c")), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)ecd.processContext(LDContext.create((String)"c")), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)ecd.processContext(LDContext.create((String)"b")), (Matcher)Matchers.is((Object)false));
    }

    @Test
    public void keysAreDisambiguatedByKind() {
        ServerSideEventContextDeduplicator ecd = new ServerSideEventContextDeduplicator(1000, LONG_INTERVAL);
        ContextKind kind1 = ContextKind.of((String)"kind1");
        ContextKind kind2 = ContextKind.of((String)"kind2");
        MatcherAssert.assertThat((Object)ecd.processContext(LDContext.create((ContextKind)kind1, (String)"a")), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)ecd.processContext(LDContext.create((ContextKind)kind1, (String)"b")), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)ecd.processContext(LDContext.create((ContextKind)kind1, (String)"a")), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)ecd.processContext(LDContext.create((ContextKind)kind2, (String)"a")), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)ecd.processContext(LDContext.create((ContextKind)kind2, (String)"a")), (Matcher)Matchers.is((Object)false));
    }

    @Test
    public void multiKindContextIsDisambiguatedFromSingleKinds() {
        ServerSideEventContextDeduplicator ecd = new ServerSideEventContextDeduplicator(1000, LONG_INTERVAL);
        ContextKind kind1 = ContextKind.of((String)"kind1");
        ContextKind kind2 = ContextKind.of((String)"kind2");
        LDContext c1 = LDContext.create((ContextKind)kind1, (String)"a");
        LDContext c2 = LDContext.create((ContextKind)kind2, (String)"a");
        LDContext mc = LDContext.createMulti((LDContext[])new LDContext[]{c1, c2});
        MatcherAssert.assertThat((Object)ecd.processContext(c1), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)ecd.processContext(c2), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)ecd.processContext(c1), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)ecd.processContext(c2), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)ecd.processContext(mc), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)ecd.processContext(mc), (Matcher)Matchers.is((Object)false));
    }
}

