/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.sdk.server;

import com.launchdarkly.sdk.server.SimpleLRUCache;
import org.junit.Assert;
import org.junit.Test;

public class SimpleLRUCacheTest {
    @Test
    public void getReturnsNullForNeverSeenValue() {
        SimpleLRUCache cache = new SimpleLRUCache(10);
        Assert.assertNull((Object)cache.get((Object)"a"));
    }

    @Test
    public void putReturnsNullForNeverSeenValue() {
        SimpleLRUCache cache = new SimpleLRUCache(10);
        Assert.assertNull((Object)cache.put((Object)"a", (Object)"1"));
    }

    @Test
    public void putReturnsPreviousValueForAlreadySeenValue() {
        SimpleLRUCache cache = new SimpleLRUCache(10);
        cache.put((Object)"a", (Object)"1");
        Assert.assertEquals((Object)"1", (Object)cache.put((Object)"a", (Object)"2"));
    }

    @Test
    public void oldestValueIsDiscardedWhenCapacityIsExceeded() {
        SimpleLRUCache cache = new SimpleLRUCache(2);
        cache.put((Object)"a", (Object)"1");
        cache.put((Object)"b", (Object)"2");
        cache.put((Object)"c", (Object)"3");
        Assert.assertEquals((Object)"3", (Object)cache.get((Object)"c"));
        Assert.assertEquals((Object)"2", (Object)cache.get((Object)"b"));
        Assert.assertNull((Object)cache.get((Object)"a"));
    }

    @Test
    public void reAddingValueMakesItNewAgain() {
        SimpleLRUCache cache = new SimpleLRUCache(2);
        cache.put((Object)"a", (Object)"1");
        cache.put((Object)"b", (Object)"2");
        cache.put((Object)"c", (Object)"3");
        cache.put((Object)"a", (Object)"1");
        Assert.assertEquals((Object)"3", (Object)cache.get((Object)"c"));
        Assert.assertEquals((Object)"1", (Object)cache.get((Object)"a"));
        Assert.assertNull((Object)cache.get((Object)"b"));
    }

    @Test
    public void zeroLengthCacheTreatsValuesAsNew() {
        SimpleLRUCache cache = new SimpleLRUCache(0);
        cache.put((Object)"a", (Object)"1");
        Assert.assertNull((Object)cache.put((Object)"a", (Object)"2"));
    }
}

