/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.sdk.server;

import com.launchdarkly.logging.LDLogger;
import com.launchdarkly.sdk.server.BaseTest;
import com.launchdarkly.sdk.server.Components;
import com.launchdarkly.sdk.server.Util;
import com.launchdarkly.sdk.server.interfaces.ApplicationInfo;
import com.launchdarkly.sdk.server.interfaces.HttpAuthentication;
import java.time.Duration;
import okhttp3.Authenticator;
import okhttp3.Protocol;
import okhttp3.Request;
import okhttp3.Response;
import org.junit.Assert;
import org.junit.Test;

public class UtilTest
extends BaseTest {
    @Test
    public void useOurBasicAuthenticatorAsOkhttpProxyAuthenticator() throws Exception {
        HttpAuthentication ourAuth = Components.httpBasicAuthentication((String)"user", (String)"pass");
        Authenticator okhttpAuth = Util.okhttpAuthenticatorFromHttpAuthStrategy((HttpAuthentication)ourAuth);
        Request originalRequest = new Request.Builder().url("http://proxy").build();
        Response resp1 = new Response.Builder().request(originalRequest).message("").protocol(Protocol.HTTP_1_1).header("Proxy-Authentication", "Basic realm=x").code(407).build();
        Request newRequest = okhttpAuth.authenticate(null, resp1);
        Assert.assertEquals((Object)"Basic dXNlcjpwYXNz", (Object)newRequest.header("Proxy-Authorization"));
        Response resp2 = new Response.Builder().request(newRequest).message("").protocol(Protocol.HTTP_1_1).header("Proxy-Authentication", "Basic realm=x").code(407).build();
        Assert.assertNull((Object)okhttpAuth.authenticate(null, resp2));
    }

    @Test
    public void describeDuration() {
        Assert.assertEquals((Object)"15 milliseconds", (Object)Util.describeDuration((Duration)Duration.ofMillis(15L)));
        Assert.assertEquals((Object)"1500 milliseconds", (Object)Util.describeDuration((Duration)Duration.ofMillis(1500L)));
        Assert.assertEquals((Object)"1 second", (Object)Util.describeDuration((Duration)Duration.ofMillis(1000L)));
        Assert.assertEquals((Object)"2 seconds", (Object)Util.describeDuration((Duration)Duration.ofMillis(2000L)));
        Assert.assertEquals((Object)"70 seconds", (Object)Util.describeDuration((Duration)Duration.ofMillis(70000L)));
        Assert.assertEquals((Object)"1 minute", (Object)Util.describeDuration((Duration)Duration.ofMillis(60000L)));
        Assert.assertEquals((Object)"2 minutes", (Object)Util.describeDuration((Duration)Duration.ofMillis(120000L)));
    }

    @Test
    public void testApplicationTagHeader() {
        Assert.assertEquals((Object)"", (Object)Util.applicationTagHeader((ApplicationInfo)new ApplicationInfo(null, null), (LDLogger)this.testLogger));
        Assert.assertEquals((Object)"application-id/foo", (Object)Util.applicationTagHeader((ApplicationInfo)new ApplicationInfo("foo", null), (LDLogger)this.testLogger));
        Assert.assertEquals((Object)"application-version/1.0.0", (Object)Util.applicationTagHeader((ApplicationInfo)new ApplicationInfo(null, "1.0.0"), (LDLogger)this.testLogger));
        Assert.assertEquals((Object)"application-id/foo application-version/1.0.0", (Object)Util.applicationTagHeader((ApplicationInfo)new ApplicationInfo("foo", "1.0.0"), (LDLogger)this.testLogger));
        Assert.assertEquals((Object)"", (Object)Util.applicationTagHeader((ApplicationInfo)new ApplicationInfo("invalid name", "lol!"), (LDLogger)this.testLogger));
        Assert.assertEquals((Object)"", (Object)Util.applicationTagHeader((ApplicationInfo)new ApplicationInfo("look-at-this-incredibly-long-application-id-like-wow-it-sure-is-verbose", null), (LDLogger)this.testLogger));
        Assert.assertEquals((Object)"", (Object)Util.applicationTagHeader((ApplicationInfo)new ApplicationInfo("", ""), (LDLogger)this.testLogger));
    }
}

