/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.sdk.server.integrations;

import com.launchdarkly.sdk.LDContext;
import com.launchdarkly.sdk.LDValue;
import com.launchdarkly.sdk.server.Components;
import com.launchdarkly.sdk.server.LDClient;
import com.launchdarkly.sdk.server.LDConfig;
import com.launchdarkly.sdk.server.integrations.FileData;
import com.launchdarkly.sdk.server.integrations.FileDataSourceBuilder;
import com.launchdarkly.sdk.server.integrations.FileDataSourceTestData;
import com.launchdarkly.sdk.server.subsystems.ComponentConfigurer;
import java.nio.file.Path;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Test;

public class ClientWithFileDataSourceTest {
    private static final LDContext user = LDContext.create((String)"userkey");

    private LDClient makeClient() throws Exception {
        FileDataSourceBuilder fdsb = FileData.dataSource().filePaths(new Path[]{FileDataSourceTestData.resourceFilePath("all-properties.json")});
        LDConfig config = new LDConfig.Builder().dataSource((ComponentConfigurer)fdsb).events(Components.noEvents()).build();
        return new LDClient("sdkKey", config);
    }

    @Test
    public void fullFlagDefinitionEvaluatesAsExpected() throws Exception {
        try (LDClient client = this.makeClient();){
            MatcherAssert.assertThat((Object)client.jsonValueVariation("flag1", user, LDValue.of((String)"default")), (Matcher)Matchers.equalTo((Object)FileDataSourceTestData.FULL_FLAG_1_VALUE));
        }
    }

    @Test
    public void simplifiedFlagEvaluatesAsExpected() throws Exception {
        try (LDClient client = this.makeClient();){
            MatcherAssert.assertThat((Object)client.jsonValueVariation("flag2", user, LDValue.of((String)"default")), (Matcher)Matchers.equalTo((Object)FileDataSourceTestData.FLAG_VALUE_1));
        }
    }
}

