/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.sdk.server.integrations;

import com.launchdarkly.sdk.LDValue;
import com.launchdarkly.sdk.server.DataModel;
import com.launchdarkly.sdk.server.DataStoreTestTypes;
import com.launchdarkly.sdk.server.integrations.FileData;
import com.launchdarkly.sdk.server.integrations.FileDataSourceImpl;
import com.launchdarkly.sdk.server.integrations.FileDataSourceParsing;
import com.launchdarkly.sdk.server.integrations.FileDataSourceTestData;
import com.launchdarkly.sdk.server.subsystems.DataStoreTypes;
import com.launchdarkly.testhelpers.JsonAssertions;
import com.launchdarkly.testhelpers.JsonTestValue;
import java.nio.file.Path;
import java.util.Map;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;

public class DataLoaderTest {
    private FileDataSourceImpl.DataBuilder builder = new FileDataSourceImpl.DataBuilder(FileData.DuplicateKeysHandling.FAIL);

    @Test
    public void canLoadFromFilePath() throws Exception {
        FileDataSourceImpl.DataLoader ds = new FileDataSourceImpl.DataLoader(FileData.dataSource().filePaths((Path[])new Path[]{FileDataSourceTestData.resourceFilePath((String)"flag-only.json")}).sources);
        ds.load(this.builder);
        this.assertDataHasItemsOfKind(DataModel.FEATURES);
    }

    @Test
    public void canLoadFromClasspath() throws Exception {
        FileDataSourceImpl.DataLoader ds = new FileDataSourceImpl.DataLoader(FileData.dataSource().classpathResources((String[])new String[]{FileDataSourceTestData.resourceLocation((String)"flag-only.json")}).sources);
        ds.load(this.builder);
        this.assertDataHasItemsOfKind(DataModel.FEATURES);
    }

    @Test
    public void yamlFileIsAutoDetected() throws Exception {
        FileDataSourceImpl.DataLoader ds = new FileDataSourceImpl.DataLoader(FileData.dataSource().filePaths((Path[])new Path[]{FileDataSourceTestData.resourceFilePath((String)"flag-only.yml")}).sources);
        ds.load(this.builder);
        this.assertDataHasItemsOfKind(DataModel.FEATURES);
    }

    @Test
    public void jsonFileIsAutoDetected() throws Exception {
        FileDataSourceImpl.DataLoader ds = new FileDataSourceImpl.DataLoader(FileData.dataSource().filePaths((Path[])new Path[]{FileDataSourceTestData.resourceFilePath((String)"segment-only.json")}).sources);
        ds.load(this.builder);
        this.assertDataHasItemsOfKind(DataModel.SEGMENTS);
    }

    @Test
    public void canLoadMultipleFiles() throws Exception {
        FileDataSourceImpl.DataLoader ds = new FileDataSourceImpl.DataLoader(FileData.dataSource().filePaths((Path[])new Path[]{FileDataSourceTestData.resourceFilePath((String)"flag-only.json"), FileDataSourceTestData.resourceFilePath((String)"segment-only.yml")}).sources);
        ds.load(this.builder);
        this.assertDataHasItemsOfKind(DataModel.FEATURES);
        this.assertDataHasItemsOfKind(DataModel.SEGMENTS);
    }

    @Test
    public void flagValueIsConvertedToFlag() throws Exception {
        FileDataSourceImpl.DataLoader ds = new FileDataSourceImpl.DataLoader(FileData.dataSource().filePaths((Path[])new Path[]{FileDataSourceTestData.resourceFilePath((String)"value-only.json")}).sources);
        String expected = "{\"key\":\"flag2\",\"on\":true,\"fallthrough\":{\"variation\":0},\"variations\":[\"value2\"],\"trackEvents\":false,\"deleted\":false,\"version\":1}";
        ds.load(this.builder);
        MatcherAssert.assertThat((Object)this.getItemAsJson(this.builder, DataModel.FEATURES, "flag2"), (Matcher)JsonAssertions.jsonIncludes((String)expected));
    }

    @Test
    public void duplicateFlagKeyInFlagsThrowsExceptionByDefault() throws Exception {
        try {
            FileDataSourceImpl.DataLoader ds = new FileDataSourceImpl.DataLoader(FileData.dataSource().filePaths((Path[])new Path[]{FileDataSourceTestData.resourceFilePath((String)"flag-only.json"), FileDataSourceTestData.resourceFilePath((String)"flag-with-duplicate-key.json")}).sources);
            ds.load(this.builder);
        }
        catch (FileDataSourceParsing.FileDataException e) {
            MatcherAssert.assertThat((Object)e.getMessage(), (Matcher)Matchers.containsString((String)"key \"flag1\" was already defined"));
        }
    }

    @Test
    public void duplicateFlagKeyInFlagsAndFlagValuesThrowsExceptionByDefault() throws Exception {
        try {
            FileDataSourceImpl.DataLoader ds = new FileDataSourceImpl.DataLoader(FileData.dataSource().filePaths((Path[])new Path[]{FileDataSourceTestData.resourceFilePath((String)"flag-only.json"), FileDataSourceTestData.resourceFilePath((String)"value-with-duplicate-key.json")}).sources);
            ds.load(this.builder);
        }
        catch (FileDataSourceParsing.FileDataException e) {
            MatcherAssert.assertThat((Object)e.getMessage(), (Matcher)Matchers.containsString((String)"key \"flag1\" was already defined"));
        }
    }

    @Test
    public void duplicateSegmentKeyThrowsExceptionByDefault() throws Exception {
        try {
            FileDataSourceImpl.DataLoader ds = new FileDataSourceImpl.DataLoader(FileData.dataSource().filePaths((Path[])new Path[]{FileDataSourceTestData.resourceFilePath((String)"segment-only.json"), FileDataSourceTestData.resourceFilePath((String)"segment-with-duplicate-key.json")}).sources);
            ds.load(this.builder);
        }
        catch (FileDataSourceParsing.FileDataException e) {
            MatcherAssert.assertThat((Object)e.getMessage(), (Matcher)Matchers.containsString((String)"key \"seg1\" was already defined"));
        }
    }

    @Test
    public void duplicateKeysCanBeAllowed() throws Exception {
        FileDataSourceImpl.DataBuilder data1 = new FileDataSourceImpl.DataBuilder(FileData.DuplicateKeysHandling.IGNORE);
        FileDataSourceImpl.DataLoader loader1 = new FileDataSourceImpl.DataLoader(FileData.dataSource().filePaths((Path[])new Path[]{FileDataSourceTestData.resourceFilePath((String)"flag-only.json"), FileDataSourceTestData.resourceFilePath((String)"flag-with-duplicate-key.json")}).sources);
        loader1.load(data1);
        MatcherAssert.assertThat((Object)this.getItemAsJson(data1, DataModel.FEATURES, "flag1"), (Matcher)JsonAssertions.jsonIncludes((String)"{\"on\":true}"));
        FileDataSourceImpl.DataBuilder data2 = new FileDataSourceImpl.DataBuilder(FileData.DuplicateKeysHandling.IGNORE);
        FileDataSourceImpl.DataLoader loader2 = new FileDataSourceImpl.DataLoader(FileData.dataSource().filePaths((Path[])new Path[]{FileDataSourceTestData.resourceFilePath((String)"value-with-duplicate-key.json"), FileDataSourceTestData.resourceFilePath((String)"flag-only.json")}).sources);
        loader2.load(data2);
        MatcherAssert.assertThat((Object)this.getItemAsJson(data2, DataModel.FEATURES, "flag2"), (Matcher)JsonAssertions.jsonIncludes((String)"{\"variations\":[\"value2a\"]}"));
        FileDataSourceImpl.DataBuilder data3 = new FileDataSourceImpl.DataBuilder(FileData.DuplicateKeysHandling.IGNORE);
        FileDataSourceImpl.DataLoader loader3 = new FileDataSourceImpl.DataLoader(FileData.dataSource().filePaths((Path[])new Path[]{FileDataSourceTestData.resourceFilePath((String)"segment-only.json"), FileDataSourceTestData.resourceFilePath((String)"segment-with-duplicate-key.json")}).sources);
        loader3.load(data3);
        MatcherAssert.assertThat((Object)this.getItemAsJson(data3, DataModel.SEGMENTS, "seg1"), (Matcher)JsonAssertions.jsonIncludes((String)"{\"included\":[\"user1\"]}"));
    }

    @Test
    public void versionsAreIncrementedForEachLoad() throws Exception {
        FileDataSourceImpl.DataLoader ds = new FileDataSourceImpl.DataLoader(FileData.dataSource().filePaths((Path[])new Path[]{FileDataSourceTestData.resourceFilePath((String)"flag-only.json"), FileDataSourceTestData.resourceFilePath((String)"segment-only.json"), FileDataSourceTestData.resourceFilePath((String)"value-only.json")}).sources);
        FileDataSourceImpl.DataBuilder data1 = new FileDataSourceImpl.DataBuilder(FileData.DuplicateKeysHandling.FAIL);
        ds.load(data1);
        this.assertVersionsMatch((DataStoreTypes.FullDataSet<DataStoreTypes.ItemDescriptor>)data1.build(), 1);
        FileDataSourceImpl.DataBuilder data2 = new FileDataSourceImpl.DataBuilder(FileData.DuplicateKeysHandling.FAIL);
        ds.load(data2);
        this.assertVersionsMatch((DataStoreTypes.FullDataSet<DataStoreTypes.ItemDescriptor>)data2.build(), 2);
    }

    private void assertDataHasItemsOfKind(DataStoreTypes.DataKind kind) {
        Map items = DataStoreTestTypes.toDataMap(this.builder.build()).get(kind);
        if (items == null || items.size() == 0) {
            Assert.fail((String)("expected at least one item in \"" + kind.getName() + "\", received: " + this.builder.build()));
        }
    }

    private void assertVersionsMatch(DataStoreTypes.FullDataSet<DataStoreTypes.ItemDescriptor> data, int expectedVersion) {
        for (Map.Entry kv1 : data.getData()) {
            DataStoreTypes.DataKind kind = (DataStoreTypes.DataKind)kv1.getKey();
            for (Map.Entry kv2 : ((DataStoreTypes.KeyedItems)kv1.getValue()).getItems()) {
                DataStoreTypes.ItemDescriptor item = (DataStoreTypes.ItemDescriptor)kv2.getValue();
                String jsonData = kind.serialize(item);
                MatcherAssert.assertThat((String)("descriptor version of " + (String)kv2.getKey()), (Object)item.getVersion(), (Matcher)Matchers.equalTo((Object)expectedVersion));
                MatcherAssert.assertThat((String)("version in data model object of " + (String)kv2.getKey()), (Object)LDValue.parse((String)jsonData).get("version"), (Matcher)Matchers.equalTo((Object)LDValue.of((int)expectedVersion)));
            }
        }
    }

    private JsonTestValue getItemAsJson(FileDataSourceImpl.DataBuilder builder, DataStoreTypes.DataKind kind, String key) {
        DataStoreTypes.ItemDescriptor flag = (DataStoreTypes.ItemDescriptor)DataStoreTestTypes.toDataMap(builder.build()).get(kind).get(key);
        return JsonTestValue.jsonOf((String)kind.serialize(flag));
    }
}

