/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.sdk.server.integrations;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.launchdarkly.sdk.server.BaseTest;
import com.launchdarkly.sdk.server.DataModel;
import com.launchdarkly.sdk.server.DataStoreTestTypes;
import com.launchdarkly.sdk.server.LDConfig;
import com.launchdarkly.sdk.server.TestComponents;
import com.launchdarkly.sdk.server.TestUtil;
import com.launchdarkly.sdk.server.integrations.FileData;
import com.launchdarkly.sdk.server.integrations.FileDataSourceBuilder;
import com.launchdarkly.sdk.server.integrations.FileDataSourceTestData;
import com.launchdarkly.sdk.server.interfaces.DataSourceStatusProvider;
import com.launchdarkly.sdk.server.subsystems.ClientContext;
import com.launchdarkly.sdk.server.subsystems.DataSource;
import com.launchdarkly.sdk.server.subsystems.DataStore;
import com.launchdarkly.testhelpers.TempFile;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;

public class FileDataSourceTest
extends BaseTest {
    private static final Path badFilePath = Paths.get("no-such-file.json", new String[0]);
    private final DataStore store;
    private TestComponents.MockDataSourceUpdates dataSourceUpdates;
    private final LDConfig config = this.baseConfig().build();

    public FileDataSourceTest() throws Exception {
        this.store = TestComponents.inMemoryDataStore();
        this.dataSourceUpdates = TestComponents.dataSourceUpdates(this.store);
    }

    private static FileDataSourceBuilder makeFactoryWithFile(Path path) {
        return FileData.dataSource().filePaths(new Path[]{path});
    }

    private DataSource makeDataSource(FileDataSourceBuilder builder) {
        return builder.build((ClientContext)TestComponents.clientContext("", this.config, this.dataSourceUpdates));
    }

    @Test
    public void flagsAreNotLoadedUntilStart() throws Exception {
        FileDataSourceBuilder factory = FileDataSourceTest.makeFactoryWithFile(FileDataSourceTestData.resourceFilePath("all-properties.json"));
        try (DataSource fp = this.makeDataSource(factory);){
            MatcherAssert.assertThat((Object)this.store.isInitialized(), (Matcher)Matchers.equalTo((Object)false));
            MatcherAssert.assertThat((Object)Iterables.size((Iterable)this.store.getAll(DataModel.FEATURES).getItems()), (Matcher)Matchers.equalTo((Object)0));
            MatcherAssert.assertThat((Object)Iterables.size((Iterable)this.store.getAll(DataModel.SEGMENTS).getItems()), (Matcher)Matchers.equalTo((Object)0));
        }
    }

    @Test
    public void flagsAreLoadedOnStart() throws Exception {
        FileDataSourceBuilder factory = FileDataSourceTest.makeFactoryWithFile(FileDataSourceTestData.resourceFilePath("all-properties.json"));
        try (DataSource fp = this.makeDataSource(factory);){
            this.verifySuccessfulStart(fp);
            MatcherAssert.assertThat(DataStoreTestTypes.toItemsMap(this.store.getAll(DataModel.FEATURES)).keySet(), (Matcher)Matchers.equalTo(FileDataSourceTestData.ALL_FLAG_KEYS));
            MatcherAssert.assertThat(DataStoreTestTypes.toItemsMap(this.store.getAll(DataModel.SEGMENTS)).keySet(), (Matcher)Matchers.equalTo(FileDataSourceTestData.ALL_SEGMENT_KEYS));
        }
    }

    @Test
    public void filePathsCanBeSpecifiedAsStrings() throws Exception {
        FileDataSourceBuilder factory = FileData.dataSource().filePaths(new String[]{FileDataSourceTestData.resourceFilePath("all-properties.json").toString()});
        try (DataSource fp = this.makeDataSource(factory);){
            this.verifySuccessfulStart(fp);
            MatcherAssert.assertThat(DataStoreTestTypes.toItemsMap(this.store.getAll(DataModel.FEATURES)).keySet(), (Matcher)Matchers.equalTo(FileDataSourceTestData.ALL_FLAG_KEYS));
            MatcherAssert.assertThat(DataStoreTestTypes.toItemsMap(this.store.getAll(DataModel.SEGMENTS)).keySet(), (Matcher)Matchers.equalTo(FileDataSourceTestData.ALL_SEGMENT_KEYS));
        }
    }

    @Test
    public void flagsAreLoadedOnStartFromYamlFile() throws Exception {
        FileDataSourceBuilder factory = FileDataSourceTest.makeFactoryWithFile(FileDataSourceTestData.resourceFilePath("all-properties.yml"));
        try (DataSource fp = this.makeDataSource(factory);){
            this.verifySuccessfulStart(fp);
            MatcherAssert.assertThat(DataStoreTestTypes.toItemsMap(this.store.getAll(DataModel.FEATURES)).keySet(), (Matcher)Matchers.equalTo(FileDataSourceTestData.ALL_FLAG_KEYS));
            MatcherAssert.assertThat(DataStoreTestTypes.toItemsMap(this.store.getAll(DataModel.SEGMENTS)).keySet(), (Matcher)Matchers.equalTo(FileDataSourceTestData.ALL_SEGMENT_KEYS));
        }
    }

    @Test
    public void startSucceedsWithEmptyFile() throws Exception {
        try (DataSource fp = this.makeDataSource(FileDataSourceTest.makeFactoryWithFile(FileDataSourceTestData.resourceFilePath("no-data.json")));){
            this.verifySuccessfulStart(fp);
            MatcherAssert.assertThat(DataStoreTestTypes.toItemsMap(this.store.getAll(DataModel.FEATURES)).keySet(), (Matcher)Matchers.equalTo((Object)ImmutableSet.of()));
            MatcherAssert.assertThat(DataStoreTestTypes.toItemsMap(this.store.getAll(DataModel.SEGMENTS)).keySet(), (Matcher)Matchers.equalTo((Object)ImmutableSet.of()));
        }
    }

    private void verifySuccessfulStart(DataSource fp) {
        LinkedBlockingQueue<DataSourceStatusProvider.Status> statuses = new LinkedBlockingQueue<DataSourceStatusProvider.Status>();
        this.dataSourceUpdates.register(statuses::add);
        Future future = fp.start();
        MatcherAssert.assertThat((Object)future.isDone(), (Matcher)Matchers.equalTo((Object)true));
        MatcherAssert.assertThat((Object)this.store.isInitialized(), (Matcher)Matchers.equalTo((Object)true));
        TestUtil.requireDataSourceStatus(statuses, DataSourceStatusProvider.State.VALID);
    }

    @Test
    public void startFailsWithNonexistentFile() throws Exception {
        try (DataSource fp = this.makeDataSource(FileDataSourceTest.makeFactoryWithFile(badFilePath));){
            this.verifyUnsuccessfulStart(fp);
        }
    }

    @Test
    public void startFailsWithNonexistentClasspathResource() throws Exception {
        FileDataSourceBuilder factory = FileData.dataSource().classpathResources(new String[]{"we-have-no-such-thing"});
        try (DataSource fp = this.makeDataSource(factory);){
            this.verifyUnsuccessfulStart(fp);
        }
    }

    private void verifyUnsuccessfulStart(DataSource fp) {
        LinkedBlockingQueue<DataSourceStatusProvider.Status> statuses = new LinkedBlockingQueue<DataSourceStatusProvider.Status>();
        this.dataSourceUpdates.register(statuses::add);
        Future future = fp.start();
        MatcherAssert.assertThat((Object)future.isDone(), (Matcher)Matchers.equalTo((Object)true));
        MatcherAssert.assertThat((Object)this.store.isInitialized(), (Matcher)Matchers.equalTo((Object)false));
        DataSourceStatusProvider.Status status = TestUtil.requireDataSourceStatus(statuses, DataSourceStatusProvider.State.INITIALIZING);
        Assert.assertEquals((Object)DataSourceStatusProvider.ErrorKind.INVALID_DATA, (Object)status.getLastError().getKind());
    }

    @Test
    public void instantiationOfArbitraryTypeIsNotAllowed() throws Exception {
        String className = SimulatedMaliciousType.class.getName();
        Class.forName(this.getClass().getName());
        Class.forName(className);
        try (TempFile f = TempFile.create();){
            f.setContents("---\nbad_thing: !!" + className + " [value]\n");
            try (DataSource fp = this.makeDataSource(FileData.dataSource().filePaths(new Path[]{f.getPath()}));){
                this.verifyUnsuccessfulStart(fp);
                MatcherAssert.assertThat((Object)SimulatedMaliciousType.wasInstantiated, (Matcher)Matchers.is((Object)false));
            }
        }
    }

    public static class SimulatedMaliciousType {
        static volatile boolean wasInstantiated = false;

        public SimulatedMaliciousType(String value) {
            wasInstantiated = true;
        }
    }
}

