/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.sdk.server.integrations;

import com.google.common.collect.ImmutableMap;
import com.launchdarkly.sdk.server.Components;
import com.launchdarkly.sdk.server.TestUtil;
import com.launchdarkly.sdk.server.integrations.HttpConfigurationBuilder;
import com.launchdarkly.sdk.server.interfaces.ApplicationInfo;
import com.launchdarkly.sdk.server.subsystems.ClientContext;
import com.launchdarkly.sdk.server.subsystems.HttpConfiguration;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.Socket;
import java.net.UnknownHostException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.time.Duration;
import javax.net.SocketFactory;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.X509TrustManager;
import org.junit.Assert;
import org.junit.Test;

public class HttpConfigurationBuilderTest {
    private static final String SDK_KEY = "sdk-key";
    private static final ClientContext BASIC_CONTEXT = new ClientContext("sdk-key");

    private static ImmutableMap.Builder<String, String> buildBasicHeaders() {
        return ImmutableMap.builder().put((Object)"Authorization", (Object)SDK_KEY).put((Object)"User-Agent", (Object)("JavaClient/" + TestUtil.getSdkVersion()));
    }

    @Test
    public void testDefaults() {
        HttpConfiguration hc = (HttpConfiguration)Components.httpConfiguration().build(BASIC_CONTEXT);
        Assert.assertEquals((Object)HttpConfigurationBuilder.DEFAULT_CONNECT_TIMEOUT, (Object)hc.getConnectTimeout());
        Assert.assertNull((Object)hc.getProxy());
        Assert.assertNull((Object)hc.getProxyAuthentication());
        Assert.assertEquals((Object)HttpConfigurationBuilder.DEFAULT_SOCKET_TIMEOUT, (Object)hc.getSocketTimeout());
        Assert.assertNull((Object)hc.getSocketFactory());
        Assert.assertNull((Object)hc.getSslSocketFactory());
        Assert.assertNull((Object)hc.getTrustManager());
        Assert.assertEquals((Object)HttpConfigurationBuilderTest.buildBasicHeaders().build(), (Object)ImmutableMap.copyOf((Iterable)hc.getDefaultHeaders()));
    }

    @Test
    public void testCanSetCustomHeaders() {
        HttpConfiguration hc = (HttpConfiguration)Components.httpConfiguration().addCustomHeader("X-LaunchDarkly-Test-Label", "my-cool-label").addCustomHeader("X-Header-Message", "Java FTW").addCustomHeader("Authorization", "I can override this").addCustomHeader("User-Agent", "This too").build(BASIC_CONTEXT);
        ImmutableMap expectedHeaders = ImmutableMap.builder().put((Object)"X-LaunchDarkly-Test-Label", (Object)"my-cool-label").put((Object)"X-Header-Message", (Object)"Java FTW").put((Object)"Authorization", (Object)"I can override this").put((Object)"User-Agent", (Object)"This too").build();
        Assert.assertEquals((Object)expectedHeaders, (Object)ImmutableMap.copyOf((Iterable)hc.getDefaultHeaders()));
    }

    @Test
    public void testConnectTimeout() {
        HttpConfiguration hc = (HttpConfiguration)Components.httpConfiguration().connectTimeout(Duration.ofMillis(999L)).build(BASIC_CONTEXT);
        Assert.assertEquals((long)999L, (long)hc.getConnectTimeout().toMillis());
        HttpConfiguration hc2 = (HttpConfiguration)Components.httpConfiguration().connectTimeout(Duration.ofMillis(999L)).connectTimeout(null).build(BASIC_CONTEXT);
        Assert.assertEquals((Object)HttpConfigurationBuilder.DEFAULT_CONNECT_TIMEOUT, (Object)hc2.getConnectTimeout());
    }

    @Test
    public void testProxy() {
        HttpConfiguration hc = (HttpConfiguration)Components.httpConfiguration().proxyHostAndPort("my-proxy", 1234).build(BASIC_CONTEXT);
        Assert.assertEquals((Object)new Proxy(Proxy.Type.HTTP, new InetSocketAddress("my-proxy", 1234)), (Object)hc.getProxy());
        Assert.assertNull((Object)hc.getProxyAuthentication());
    }

    @Test
    public void testProxyBasicAuth() {
        HttpConfiguration hc = (HttpConfiguration)Components.httpConfiguration().proxyHostAndPort("my-proxy", 1234).proxyAuth(Components.httpBasicAuthentication((String)"user", (String)"pass")).build(BASIC_CONTEXT);
        Assert.assertEquals((Object)new Proxy(Proxy.Type.HTTP, new InetSocketAddress("my-proxy", 1234)), (Object)hc.getProxy());
        Assert.assertNotNull((Object)hc.getProxyAuthentication());
        Assert.assertEquals((Object)"Basic dXNlcjpwYXNz", (Object)hc.getProxyAuthentication().provideAuthorization(null));
    }

    @Test
    public void testSocketTimeout() {
        HttpConfiguration hc1 = (HttpConfiguration)Components.httpConfiguration().socketTimeout(Duration.ofMillis(999L)).build(BASIC_CONTEXT);
        Assert.assertEquals((long)999L, (long)hc1.getSocketTimeout().toMillis());
        HttpConfiguration hc2 = (HttpConfiguration)Components.httpConfiguration().socketTimeout(Duration.ofMillis(999L)).socketTimeout(null).build(BASIC_CONTEXT);
        Assert.assertEquals((Object)HttpConfigurationBuilder.DEFAULT_SOCKET_TIMEOUT, (Object)hc2.getSocketTimeout());
    }

    @Test
    public void testSocketFactory() {
        StubSocketFactory sf = new StubSocketFactory();
        HttpConfiguration hc = (HttpConfiguration)Components.httpConfiguration().socketFactory((SocketFactory)sf).build(BASIC_CONTEXT);
        Assert.assertSame((Object)sf, (Object)hc.getSocketFactory());
    }

    @Test
    public void testSslOptions() {
        StubSSLSocketFactory sf = new StubSSLSocketFactory();
        StubX509TrustManager tm = new StubX509TrustManager();
        HttpConfiguration hc = (HttpConfiguration)Components.httpConfiguration().sslSocketFactory((SSLSocketFactory)sf, (X509TrustManager)tm).build(BASIC_CONTEXT);
        Assert.assertSame((Object)sf, (Object)hc.getSslSocketFactory());
        Assert.assertSame((Object)tm, (Object)hc.getTrustManager());
    }

    @Test
    public void testWrapperNameOnly() {
        HttpConfiguration hc = (HttpConfiguration)Components.httpConfiguration().wrapper("Scala", null).build(BASIC_CONTEXT);
        Assert.assertEquals((Object)"Scala", (Object)ImmutableMap.copyOf((Iterable)hc.getDefaultHeaders()).get((Object)"X-LaunchDarkly-Wrapper"));
    }

    @Test
    public void testWrapperWithVersion() {
        HttpConfiguration hc = (HttpConfiguration)Components.httpConfiguration().wrapper("Scala", "0.1.0").build(BASIC_CONTEXT);
        Assert.assertEquals((Object)"Scala/0.1.0", (Object)ImmutableMap.copyOf((Iterable)hc.getDefaultHeaders()).get((Object)"X-LaunchDarkly-Wrapper"));
    }

    @Test
    public void testApplicationTags() {
        ApplicationInfo info = new ApplicationInfo("authentication-service", "1.0.0");
        ClientContext contextWithTags = new ClientContext(SDK_KEY, info, null, null, false, null, 0);
        HttpConfiguration hc = (HttpConfiguration)Components.httpConfiguration().build(contextWithTags);
        Assert.assertEquals((Object)"application-id/authentication-service application-version/1.0.0", (Object)ImmutableMap.copyOf((Iterable)hc.getDefaultHeaders()).get((Object)"X-LaunchDarkly-Tags"));
    }

    public static class StubX509TrustManager
    implements X509TrustManager {
        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return null;
        }

        @Override
        public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        }

        @Override
        public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        }
    }

    public static class StubSSLSocketFactory
    extends SSLSocketFactory {
        @Override
        public Socket createSocket(InetAddress address, int port, InetAddress localAddress, int localPort) throws IOException {
            return null;
        }

        @Override
        public Socket createSocket(String host, int port, InetAddress localHost, int localPort) throws IOException, UnknownHostException {
            return null;
        }

        @Override
        public Socket createSocket(InetAddress host, int port) throws IOException {
            return null;
        }

        @Override
        public Socket createSocket(String host, int port) throws IOException, UnknownHostException {
            return null;
        }

        @Override
        public String[] getSupportedCipherSuites() {
            return null;
        }

        @Override
        public String[] getDefaultCipherSuites() {
            return null;
        }

        @Override
        public Socket createSocket(Socket s, String host, int port, boolean autoClose) throws IOException {
            return null;
        }
    }

    public static class StubSocketFactory
    extends SocketFactory {
        @Override
        public Socket createSocket(InetAddress address, int port, InetAddress localAddress, int localPort) throws IOException {
            return null;
        }

        @Override
        public Socket createSocket(String host, int port, InetAddress localHost, int localPort) throws IOException, UnknownHostException {
            return null;
        }

        @Override
        public Socket createSocket(InetAddress host, int port) throws IOException {
            return null;
        }

        @Override
        public Socket createSocket(String host, int port) throws IOException, UnknownHostException {
            return null;
        }

        public Socket createSocket(Socket s, String host, int port, boolean autoClose) throws IOException {
            return null;
        }
    }
}

