/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.sdk.server.integrations;

import com.launchdarkly.logging.LDLogAdapter;
import com.launchdarkly.logging.LDLogLevel;
import com.launchdarkly.logging.LDLogger;
import com.launchdarkly.logging.LogCapture;
import com.launchdarkly.logging.Logs;
import com.launchdarkly.sdk.server.Components;
import com.launchdarkly.sdk.server.integrations.LoggingConfigurationBuilder;
import com.launchdarkly.sdk.server.subsystems.ClientContext;
import com.launchdarkly.sdk.server.subsystems.LoggingConfiguration;
import java.time.Duration;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;

public class LoggingConfigurationBuilderTest {
    private static final String SDK_KEY = "sdk-key";
    private static final ClientContext BASIC_CONTEXT = new ClientContext("sdk-key");

    @Test
    public void testDefaults() {
        LoggingConfiguration c = (LoggingConfiguration)Components.logging().build(BASIC_CONTEXT);
        Assert.assertEquals((Object)LoggingConfigurationBuilder.DEFAULT_LOG_DATA_SOURCE_OUTAGE_AS_ERROR_AFTER, (Object)c.getLogDataSourceOutageAsErrorAfter());
    }

    @Test
    public void logDataSourceOutageAsErrorAfter() {
        LoggingConfiguration c1 = (LoggingConfiguration)Components.logging().logDataSourceOutageAsErrorAfter(Duration.ofMinutes(9L)).build(BASIC_CONTEXT);
        Assert.assertEquals((Object)Duration.ofMinutes(9L), (Object)c1.getLogDataSourceOutageAsErrorAfter());
        LoggingConfiguration c2 = (LoggingConfiguration)Components.logging().logDataSourceOutageAsErrorAfter(null).build(BASIC_CONTEXT);
        Assert.assertNull((Object)c2.getLogDataSourceOutageAsErrorAfter());
    }

    @Test
    public void defaultLogAdapterIsNotSLF4J() {
        LoggingConfiguration c = (LoggingConfiguration)Components.logging().build(BASIC_CONTEXT);
        MatcherAssert.assertThat((Object)c.getLogAdapter().getClass().getCanonicalName(), (Matcher)Matchers.not((Matcher)Matchers.startsWith((String)"com.launchdarkly.logging.LDSLF4J")));
    }

    @Test
    public void canSetLogAdapterAndLevel() {
        LogCapture logSink = Logs.capture();
        LoggingConfiguration c = (LoggingConfiguration)Components.logging().adapter((LDLogAdapter)logSink).level(LDLogLevel.WARN).build(BASIC_CONTEXT);
        LDLogger logger = LDLogger.withAdapter((LDLogAdapter)c.getLogAdapter(), (String)"");
        logger.debug((Object)"message 1");
        logger.info((Object)"message 2");
        logger.warn((Object)"message 3");
        logger.error((Object)"message 4");
        MatcherAssert.assertThat((Object)logSink.getMessageStrings(), (Matcher)Matchers.contains((Object[])new String[]{"WARN:message 3", "ERROR:message 4"}));
    }

    @Test
    public void defaultLevelIsInfo() {
        LogCapture logSink = Logs.capture();
        LoggingConfiguration c = (LoggingConfiguration)Components.logging().adapter((LDLogAdapter)logSink).build(BASIC_CONTEXT);
        LDLogger logger = LDLogger.withAdapter((LDLogAdapter)c.getLogAdapter(), (String)"");
        logger.debug((Object)"message 1");
        logger.info((Object)"message 2");
        logger.warn((Object)"message 3");
        logger.error((Object)"message 4");
        MatcherAssert.assertThat((Object)logSink.getMessageStrings(), (Matcher)Matchers.contains((Object[])new String[]{"INFO:message 2", "WARN:message 3", "ERROR:message 4"}));
    }
}

