/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.sdk.server.integrations;

import com.google.common.collect.ImmutableList;
import com.launchdarkly.sdk.server.DataStoreTestTypes;
import com.launchdarkly.sdk.server.subsystems.DataStoreTypes;
import com.launchdarkly.sdk.server.subsystems.PersistentDataStore;
import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;

public final class MockPersistentDataStore
implements PersistentDataStore {
    public final Map<DataStoreTypes.DataKind, Map<String, DataStoreTypes.SerializedItemDescriptor>> data;
    public final AtomicBoolean inited;
    public final AtomicInteger initedCount = new AtomicInteger(0);
    public volatile int initedQueryCount;
    public volatile int getQueryCount;
    public volatile boolean persistOnlyAsString;
    public volatile boolean unavailable;
    public volatile RuntimeException fakeError;
    public volatile Runnable updateHook;

    public MockPersistentDataStore() {
        this.data = new HashMap<DataStoreTypes.DataKind, Map<String, DataStoreTypes.SerializedItemDescriptor>>();
        this.inited = new AtomicBoolean();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MockPersistentDataStore(MockDatabaseInstance sharedData, String prefix) {
        MockDatabaseInstance mockDatabaseInstance = sharedData;
        synchronized (mockDatabaseInstance) {
            if (sharedData.dataByPrefix.containsKey(prefix)) {
                this.data = sharedData.dataByPrefix.get(prefix);
                this.inited = sharedData.initedByPrefix.get(prefix);
            } else {
                this.data = new HashMap<DataStoreTypes.DataKind, Map<String, DataStoreTypes.SerializedItemDescriptor>>();
                this.inited = new AtomicBoolean();
                sharedData.dataByPrefix.put(prefix, this.data);
                sharedData.initedByPrefix.put(prefix, this.inited);
            }
        }
    }

    public void close() throws IOException {
    }

    public DataStoreTypes.SerializedItemDescriptor get(DataStoreTypes.DataKind kind, String key) {
        DataStoreTypes.SerializedItemDescriptor item;
        ++this.getQueryCount;
        this.maybeThrow();
        if (this.data.containsKey(kind) && (item = this.data.get(kind).get(key)) != null) {
            if (this.persistOnlyAsString) {
                return new DataStoreTypes.SerializedItemDescriptor(0, false, item.getSerializedItem());
            }
            return item;
        }
        return null;
    }

    public DataStoreTypes.KeyedItems<DataStoreTypes.SerializedItemDescriptor> getAll(DataStoreTypes.DataKind kind) {
        this.maybeThrow();
        return this.data.containsKey(kind) ? new DataStoreTypes.KeyedItems((Iterable)ImmutableList.copyOf(this.data.get(kind).entrySet())) : new DataStoreTypes.KeyedItems(null);
    }

    public void init(DataStoreTypes.FullDataSet<DataStoreTypes.SerializedItemDescriptor> allData) {
        this.initedCount.incrementAndGet();
        this.maybeThrow();
        this.data.clear();
        for (Map.Entry entry : allData.getData()) {
            DataStoreTypes.DataKind kind = (DataStoreTypes.DataKind)entry.getKey();
            LinkedHashMap<String, DataStoreTypes.SerializedItemDescriptor> items = new LinkedHashMap<String, DataStoreTypes.SerializedItemDescriptor>();
            for (Map.Entry e : ((DataStoreTypes.KeyedItems)entry.getValue()).getItems()) {
                items.put((String)e.getKey(), this.storableItem(kind, (DataStoreTypes.SerializedItemDescriptor)e.getValue()));
            }
            this.data.put(kind, items);
        }
        this.inited.set(true);
    }

    public boolean upsert(DataStoreTypes.DataKind kind, String key, DataStoreTypes.SerializedItemDescriptor item) {
        Map<String, DataStoreTypes.SerializedItemDescriptor> items;
        DataStoreTypes.SerializedItemDescriptor oldItem;
        this.maybeThrow();
        if (this.updateHook != null) {
            this.updateHook.run();
        }
        if (!this.data.containsKey(kind)) {
            this.data.put(kind, new HashMap());
        }
        if ((oldItem = (items = this.data.get(kind)).get(key)) != null) {
            int oldVersion;
            int n = oldVersion = this.persistOnlyAsString ? kind.deserialize(oldItem.getSerializedItem()).getVersion() : oldItem.getVersion();
            if (oldVersion >= item.getVersion()) {
                return false;
            }
        }
        items.put(key, this.storableItem(kind, item));
        return true;
    }

    public boolean isInitialized() {
        this.maybeThrow();
        ++this.initedQueryCount;
        return this.inited.get();
    }

    public boolean isStoreAvailable() {
        return !this.unavailable;
    }

    public void forceSet(DataStoreTypes.DataKind kind, DataStoreTestTypes.TestItem item) {
        this.forceSet(kind, item.key, item.toSerializedItemDescriptor());
    }

    public void forceSet(DataStoreTypes.DataKind kind, String key, DataStoreTypes.SerializedItemDescriptor item) {
        if (!this.data.containsKey(kind)) {
            this.data.put(kind, new HashMap());
        }
        Map<String, DataStoreTypes.SerializedItemDescriptor> items = this.data.get(kind);
        items.put(key, this.storableItem(kind, item));
    }

    public void forceRemove(DataStoreTypes.DataKind kind, String key) {
        if (this.data.containsKey(kind)) {
            this.data.get(kind).remove(key);
        }
    }

    private DataStoreTypes.SerializedItemDescriptor storableItem(DataStoreTypes.DataKind kind, DataStoreTypes.SerializedItemDescriptor item) {
        if (item.isDeleted() && !this.persistOnlyAsString) {
            return new DataStoreTypes.SerializedItemDescriptor(item.getVersion(), true, null);
        }
        return item;
    }

    private void maybeThrow() {
        if (this.fakeError != null) {
            throw this.fakeError;
        }
    }

    public static final class MockDatabaseInstance {
        Map<String, Map<DataStoreTypes.DataKind, Map<String, DataStoreTypes.SerializedItemDescriptor>>> dataByPrefix = new HashMap<String, Map<DataStoreTypes.DataKind, Map<String, DataStoreTypes.SerializedItemDescriptor>>>();
        Map<String, AtomicBoolean> initedByPrefix = new HashMap<String, AtomicBoolean>();
    }
}

