/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.sdk.server.integrations;

import com.launchdarkly.sdk.server.Components;
import com.launchdarkly.sdk.server.integrations.PersistentDataStoreBuilder;
import com.launchdarkly.sdk.server.subsystems.ComponentConfigurer;
import com.launchdarkly.sdk.server.subsystems.PersistentDataStore;
import java.time.Duration;
import org.junit.Assert;
import org.junit.Test;

public class PersistentDataStoreBuilderTest {
    private static final ComponentConfigurer<PersistentDataStore> factory = context -> null;

    @Test
    public void factory() {
        Assert.assertSame(factory, (Object)Components.persistentDataStore(PersistentDataStoreBuilderTest.factory).persistentDataStoreConfigurer);
    }

    @Test
    public void cacheTime() {
        Assert.assertEquals((Object)PersistentDataStoreBuilder.DEFAULT_CACHE_TTL, (Object)Components.persistentDataStore(PersistentDataStoreBuilderTest.factory).cacheTime);
        Assert.assertEquals((Object)Duration.ofMinutes(3L), (Object)Components.persistentDataStore(PersistentDataStoreBuilderTest.factory).cacheTime((Duration)Duration.ofMinutes((long)3L)).cacheTime);
        Assert.assertEquals((Object)Duration.ofMillis(3L), (Object)Components.persistentDataStore(PersistentDataStoreBuilderTest.factory).cacheMillis((long)3L).cacheTime);
        Assert.assertEquals((Object)Duration.ofSeconds(3L), (Object)Components.persistentDataStore(PersistentDataStoreBuilderTest.factory).cacheSeconds((long)3L).cacheTime);
        Assert.assertEquals((Object)PersistentDataStoreBuilder.DEFAULT_CACHE_TTL, (Object)Components.persistentDataStore(PersistentDataStoreBuilderTest.factory).cacheTime((Duration)Duration.ofMinutes((long)3L)).cacheTime(null).cacheTime);
        Assert.assertEquals((Object)Duration.ZERO, (Object)Components.persistentDataStore(PersistentDataStoreBuilderTest.factory).noCaching().cacheTime);
        Assert.assertEquals((Object)Duration.ofMillis(-1L), (Object)Components.persistentDataStore(PersistentDataStoreBuilderTest.factory).cacheForever().cacheTime);
    }

    @Test
    public void staleValuesPolicy() {
        Assert.assertEquals((Object)PersistentDataStoreBuilder.StaleValuesPolicy.EVICT, (Object)Components.persistentDataStore(PersistentDataStoreBuilderTest.factory).staleValuesPolicy);
        Assert.assertEquals((Object)PersistentDataStoreBuilder.StaleValuesPolicy.REFRESH, (Object)Components.persistentDataStore(PersistentDataStoreBuilderTest.factory).staleValuesPolicy((PersistentDataStoreBuilder.StaleValuesPolicy)PersistentDataStoreBuilder.StaleValuesPolicy.REFRESH).staleValuesPolicy);
        Assert.assertEquals((Object)PersistentDataStoreBuilder.StaleValuesPolicy.EVICT, (Object)Components.persistentDataStore(PersistentDataStoreBuilderTest.factory).staleValuesPolicy((PersistentDataStoreBuilder.StaleValuesPolicy)PersistentDataStoreBuilder.StaleValuesPolicy.REFRESH).staleValuesPolicy(null).staleValuesPolicy);
    }

    @Test
    public void recordCacheStats() {
        Assert.assertFalse((boolean)Components.persistentDataStore(PersistentDataStoreBuilderTest.factory).recordCacheStats);
        Assert.assertTrue((boolean)Components.persistentDataStore(PersistentDataStoreBuilderTest.factory).recordCacheStats((boolean)true).recordCacheStats);
        Assert.assertFalse((boolean)Components.persistentDataStore(PersistentDataStoreBuilderTest.factory).recordCacheStats((boolean)true).recordCacheStats((boolean)false).recordCacheStats);
    }
}

