/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.sdk.server.integrations;

import com.google.common.collect.ImmutableList;
import com.launchdarkly.sdk.server.TestComponents;
import com.launchdarkly.sdk.server.integrations.MockPersistentDataStore;
import com.launchdarkly.sdk.server.integrations.PersistentDataStoreTestBase;
import com.launchdarkly.sdk.server.subsystems.ComponentConfigurer;
import com.launchdarkly.sdk.server.subsystems.PersistentDataStore;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class PersistentDataStoreGenericTest
extends PersistentDataStoreTestBase<MockPersistentDataStore> {
    private final MockPersistentDataStore.MockDatabaseInstance sharedData = new MockPersistentDataStore.MockDatabaseInstance();
    private final TestMode testMode;

    @Parameterized.Parameters(name="{0}")
    public static Iterable<TestMode> data() {
        return ImmutableList.of((Object)new TestMode(false), (Object)new TestMode(true));
    }

    public PersistentDataStoreGenericTest(TestMode testMode) {
        this.testMode = testMode;
    }

    @Override
    protected ComponentConfigurer<PersistentDataStore> buildStore(String prefix) {
        MockPersistentDataStore store = new MockPersistentDataStore(this.sharedData, prefix);
        store.persistOnlyAsString = this.testMode.persistOnlyAsString;
        return TestComponents.specificComponent(store);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void clearAllData() {
        MockPersistentDataStore.MockDatabaseInstance mockDatabaseInstance = this.sharedData;
        synchronized (mockDatabaseInstance) {
            for (String prefix : this.sharedData.dataByPrefix.keySet()) {
                this.sharedData.dataByPrefix.get(prefix).clear();
            }
        }
    }

    @Override
    protected boolean setUpdateHook(MockPersistentDataStore storeUnderTest, Runnable hook) {
        storeUnderTest.updateHook = hook;
        return true;
    }

    static class TestMode {
        final boolean persistOnlyAsString;

        TestMode(boolean persistOnlyAsString) {
            this.persistOnlyAsString = persistOnlyAsString;
        }

        public String toString() {
            return "TestMode(" + (this.persistOnlyAsString ? "persistOnlyAsString" : "persistWithMetadata") + ")";
        }
    }
}

