/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.sdk.server.integrations;

import com.launchdarkly.sdk.server.BaseTest;
import com.launchdarkly.sdk.server.DataStoreTestTypes;
import com.launchdarkly.sdk.server.TestComponents;
import com.launchdarkly.sdk.server.subsystems.ClientContext;
import com.launchdarkly.sdk.server.subsystems.ComponentConfigurer;
import com.launchdarkly.sdk.server.subsystems.DataStoreTypes;
import com.launchdarkly.sdk.server.subsystems.PersistentDataStore;
import java.util.Map;
import org.junit.After;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.Test;

public abstract class PersistentDataStoreTestBase<T extends PersistentDataStore>
extends BaseTest {
    protected T store;
    protected DataStoreTestTypes.TestItem item1 = new DataStoreTestTypes.TestItem("key1", "first", 10);
    protected DataStoreTestTypes.TestItem item2 = new DataStoreTestTypes.TestItem("key2", "second", 10);
    protected DataStoreTestTypes.TestItem otherItem1 = new DataStoreTestTypes.TestItem("key1", "other-first", 11);

    private ClientContext makeClientContext() {
        return TestComponents.clientContext("", this.baseConfig().build());
    }

    private T makeConfiguredStore() {
        return (T)((PersistentDataStore)this.buildStore(null).build(this.makeClientContext()));
    }

    private T makeConfiguredStoreWithPrefix(String prefix) {
        ComponentConfigurer<PersistentDataStore> builder = this.buildStore(prefix);
        if (builder == null) {
            return null;
        }
        return (T)((PersistentDataStore)builder.build(this.makeClientContext()));
    }

    protected ComponentConfigurer<PersistentDataStore> buildStore(String prefix) {
        return null;
    }

    protected abstract void clearAllData();

    protected boolean setUpdateHook(T storeUnderTest, Runnable hook) {
        return false;
    }

    private void assertEqualsSerializedItem(DataStoreTestTypes.TestItem item, DataStoreTypes.SerializedItemDescriptor serializedItemDesc) {
        Assert.assertEquals((Object)item.toSerializedItemDescriptor().getSerializedItem(), (Object)serializedItemDesc.getSerializedItem());
        if (serializedItemDesc.getVersion() != 0) {
            Assert.assertEquals((long)item.version, (long)serializedItemDesc.getVersion());
        }
    }

    private void assertEqualsDeletedItem(DataStoreTypes.SerializedItemDescriptor expected, DataStoreTypes.SerializedItemDescriptor serializedItemDesc) {
        if (serializedItemDesc.getSerializedItem() == null) {
            Assert.assertTrue((boolean)serializedItemDesc.isDeleted());
            Assert.assertEquals((long)expected.getVersion(), (long)serializedItemDesc.getVersion());
        } else {
            DataStoreTypes.ItemDescriptor itemDesc = DataStoreTestTypes.TEST_ITEMS.deserialize(serializedItemDesc.getSerializedItem());
            Assert.assertEquals((Object)DataStoreTypes.ItemDescriptor.deletedItem((int)expected.getVersion()), (Object)itemDesc);
        }
    }

    @Before
    public void setup() {
        this.store = this.makeConfiguredStore();
    }

    @After
    public void teardown() throws Exception {
        if (this.store != null) {
            this.store.close();
        }
    }

    @Test
    public void storeNotInitializedBeforeInit() {
        this.clearAllData();
        Assert.assertFalse((boolean)this.store.isInitialized());
    }

    @Test
    public void storeInitializedAfterInit() {
        this.store.init(new DataStoreTestTypes.DataBuilder().buildSerialized());
        Assert.assertTrue((boolean)this.store.isInitialized());
    }

    @Test
    public void initCompletelyReplacesPreviousData() {
        this.clearAllData();
        DataStoreTypes.FullDataSet<DataStoreTypes.SerializedItemDescriptor> allData = new DataStoreTestTypes.DataBuilder().add(DataStoreTestTypes.TEST_ITEMS, this.item1, this.item2).add(DataStoreTestTypes.OTHER_TEST_ITEMS, this.otherItem1).buildSerialized();
        this.store.init(allData);
        DataStoreTestTypes.TestItem item2v2 = this.item2.withVersion(this.item2.version + 1);
        allData = new DataStoreTestTypes.DataBuilder().add(DataStoreTestTypes.TEST_ITEMS, item2v2).add(DataStoreTestTypes.OTHER_TEST_ITEMS, new DataStoreTestTypes.TestItem[0]).buildSerialized();
        this.store.init(allData);
        Assert.assertNull((Object)this.store.get(DataStoreTestTypes.TEST_ITEMS, this.item1.key));
        this.assertEqualsSerializedItem(item2v2, this.store.get(DataStoreTestTypes.TEST_ITEMS, this.item2.key));
        Assert.assertNull((Object)this.store.get(DataStoreTestTypes.OTHER_TEST_ITEMS, this.otherItem1.key));
    }

    @Test
    public void oneInstanceCanDetectIfAnotherInstanceHasInitializedTheStore() {
        this.clearAllData();
        T store2 = this.makeConfiguredStore();
        Assert.assertFalse((boolean)this.store.isInitialized());
        store2.init(new DataStoreTestTypes.DataBuilder().add(DataStoreTestTypes.TEST_ITEMS, this.item1).buildSerialized());
        Assert.assertTrue((boolean)this.store.isInitialized());
    }

    @Test
    public void oneInstanceCanDetectIfAnotherInstanceHasInitializedTheStoreEvenIfEmpty() {
        this.clearAllData();
        T store2 = this.makeConfiguredStore();
        Assert.assertFalse((boolean)this.store.isInitialized());
        store2.init(new DataStoreTestTypes.DataBuilder().buildSerialized());
        Assert.assertTrue((boolean)this.store.isInitialized());
    }

    @Test
    public void getExistingItem() {
        this.store.init(new DataStoreTestTypes.DataBuilder().add(DataStoreTestTypes.TEST_ITEMS, this.item1, this.item2).buildSerialized());
        this.assertEqualsSerializedItem(this.item1, this.store.get(DataStoreTestTypes.TEST_ITEMS, this.item1.key));
    }

    @Test
    public void getNonexistingItem() {
        this.store.init(new DataStoreTestTypes.DataBuilder().add(DataStoreTestTypes.TEST_ITEMS, this.item1, this.item2).buildSerialized());
        Assert.assertNull((Object)this.store.get(DataStoreTestTypes.TEST_ITEMS, "biz"));
    }

    @Test
    public void getAll() {
        this.store.init(new DataStoreTestTypes.DataBuilder().add(DataStoreTestTypes.TEST_ITEMS, this.item1, this.item2).add(DataStoreTestTypes.OTHER_TEST_ITEMS, this.otherItem1).buildSerialized());
        Map items = DataStoreTestTypes.toItemsMap(this.store.getAll(DataStoreTestTypes.TEST_ITEMS));
        Assert.assertEquals((long)2L, (long)items.size());
        this.assertEqualsSerializedItem(this.item1, (DataStoreTypes.SerializedItemDescriptor)items.get(this.item1.key));
        this.assertEqualsSerializedItem(this.item2, (DataStoreTypes.SerializedItemDescriptor)items.get(this.item2.key));
    }

    @Test
    public void getAllWithDeletedItem() {
        this.store.init(new DataStoreTestTypes.DataBuilder().add(DataStoreTestTypes.TEST_ITEMS, this.item1, this.item2).buildSerialized());
        DataStoreTypes.SerializedItemDescriptor deletedItem = DataStoreTestTypes.toSerialized(DataStoreTestTypes.TEST_ITEMS, DataStoreTypes.ItemDescriptor.deletedItem((int)(this.item1.version + 1)));
        this.store.upsert(DataStoreTestTypes.TEST_ITEMS, this.item1.key, deletedItem);
        Map items = DataStoreTestTypes.toItemsMap(this.store.getAll(DataStoreTestTypes.TEST_ITEMS));
        Assert.assertEquals((long)2L, (long)items.size());
        this.assertEqualsSerializedItem(this.item2, (DataStoreTypes.SerializedItemDescriptor)items.get(this.item2.key));
        this.assertEqualsDeletedItem(deletedItem, (DataStoreTypes.SerializedItemDescriptor)items.get(this.item1.key));
    }

    @Test
    public void upsertWithNewerVersion() {
        this.store.init(new DataStoreTestTypes.DataBuilder().add(DataStoreTestTypes.TEST_ITEMS, this.item1, this.item2).buildSerialized());
        DataStoreTestTypes.TestItem newVer = this.item1.withVersion(this.item1.version + 1).withName("modified");
        this.store.upsert(DataStoreTestTypes.TEST_ITEMS, this.item1.key, newVer.toSerializedItemDescriptor());
        this.assertEqualsSerializedItem(newVer, this.store.get(DataStoreTestTypes.TEST_ITEMS, this.item1.key));
    }

    @Test
    public void upsertWithOlderVersion() {
        this.store.init(new DataStoreTestTypes.DataBuilder().add(DataStoreTestTypes.TEST_ITEMS, this.item1, this.item2).buildSerialized());
        DataStoreTestTypes.TestItem oldVer = this.item1.withVersion(this.item1.version - 1).withName("modified");
        this.store.upsert(DataStoreTestTypes.TEST_ITEMS, this.item1.key, oldVer.toSerializedItemDescriptor());
        this.assertEqualsSerializedItem(this.item1, this.store.get(DataStoreTestTypes.TEST_ITEMS, oldVer.key));
    }

    @Test
    public void upsertNewItem() {
        this.store.init(new DataStoreTestTypes.DataBuilder().add(DataStoreTestTypes.TEST_ITEMS, this.item1, this.item2).buildSerialized());
        DataStoreTestTypes.TestItem newItem = new DataStoreTestTypes.TestItem("new-name", "new-key", 99);
        this.store.upsert(DataStoreTestTypes.TEST_ITEMS, newItem.key, newItem.toSerializedItemDescriptor());
        this.assertEqualsSerializedItem(newItem, this.store.get(DataStoreTestTypes.TEST_ITEMS, newItem.key));
    }

    @Test
    public void deleteWithNewerVersion() {
        this.store.init(new DataStoreTestTypes.DataBuilder().add(DataStoreTestTypes.TEST_ITEMS, this.item1, this.item2).buildSerialized());
        DataStoreTypes.SerializedItemDescriptor deletedItem = DataStoreTestTypes.toSerialized(DataStoreTestTypes.TEST_ITEMS, DataStoreTypes.ItemDescriptor.deletedItem((int)(this.item1.version + 1)));
        this.store.upsert(DataStoreTestTypes.TEST_ITEMS, this.item1.key, deletedItem);
        this.assertEqualsDeletedItem(deletedItem, this.store.get(DataStoreTestTypes.TEST_ITEMS, this.item1.key));
    }

    @Test
    public void deleteWithOlderVersion() {
        this.store.init(new DataStoreTestTypes.DataBuilder().add(DataStoreTestTypes.TEST_ITEMS, this.item1, this.item2).buildSerialized());
        DataStoreTypes.SerializedItemDescriptor deletedItem = DataStoreTestTypes.toSerialized(DataStoreTestTypes.TEST_ITEMS, DataStoreTypes.ItemDescriptor.deletedItem((int)(this.item1.version - 1)));
        this.store.upsert(DataStoreTestTypes.TEST_ITEMS, this.item1.key, deletedItem);
        this.assertEqualsSerializedItem(this.item1, this.store.get(DataStoreTestTypes.TEST_ITEMS, this.item1.key));
    }

    @Test
    public void deleteUnknownItem() {
        this.store.init(new DataStoreTestTypes.DataBuilder().add(DataStoreTestTypes.TEST_ITEMS, this.item1, this.item2).buildSerialized());
        DataStoreTypes.SerializedItemDescriptor deletedItem = DataStoreTestTypes.toSerialized(DataStoreTestTypes.TEST_ITEMS, DataStoreTypes.ItemDescriptor.deletedItem((int)11));
        this.store.upsert(DataStoreTestTypes.TEST_ITEMS, "deleted-key", deletedItem);
        this.assertEqualsDeletedItem(deletedItem, this.store.get(DataStoreTestTypes.TEST_ITEMS, "deleted-key"));
    }

    @Test
    public void upsertOlderVersionAfterDelete() {
        this.store.init(new DataStoreTestTypes.DataBuilder().add(DataStoreTestTypes.TEST_ITEMS, this.item1, this.item2).buildSerialized());
        DataStoreTypes.SerializedItemDescriptor deletedItem = DataStoreTestTypes.toSerialized(DataStoreTestTypes.TEST_ITEMS, DataStoreTypes.ItemDescriptor.deletedItem((int)(this.item1.version + 1)));
        this.store.upsert(DataStoreTestTypes.TEST_ITEMS, this.item1.key, deletedItem);
        this.store.upsert(DataStoreTestTypes.TEST_ITEMS, this.item1.key, this.item1.toSerializedItemDescriptor());
        this.assertEqualsDeletedItem(deletedItem, this.store.get(DataStoreTestTypes.TEST_ITEMS, this.item1.key));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void handlesUpsertRaceConditionAgainstExternalClientWithLowerVersion() throws Exception {
        T store2 = this.makeConfiguredStore();
        int startVersion = 1;
        int store2VersionStart = 2;
        int store2VersionEnd = 4;
        int store1VersionEnd = 10;
        DataStoreTestTypes.TestItem startItem = new DataStoreTestTypes.TestItem("me", "foo", startVersion);
        Runnable concurrentModifier = new Runnable((PersistentDataStore)store2, startItem){
            int versionCounter = 2;
            final /* synthetic */ PersistentDataStore val$store2;
            final /* synthetic */ DataStoreTestTypes.TestItem val$startItem;
            {
                this.val$store2 = persistentDataStore;
                this.val$startItem = testItem;
            }

            @Override
            public void run() {
                if (this.versionCounter <= 4) {
                    this.val$store2.upsert(DataStoreTestTypes.TEST_ITEMS, this.val$startItem.key, this.val$startItem.withVersion(this.versionCounter).toSerializedItemDescriptor());
                    ++this.versionCounter;
                }
            }
        };
        try {
            Assume.assumeTrue((boolean)this.setUpdateHook(this.store, concurrentModifier));
            this.store.init(new DataStoreTestTypes.DataBuilder().add(DataStoreTestTypes.TEST_ITEMS, startItem).buildSerialized());
            DataStoreTestTypes.TestItem store1End = startItem.withVersion(store1VersionEnd);
            this.store.upsert(DataStoreTestTypes.TEST_ITEMS, startItem.key, store1End.toSerializedItemDescriptor());
            DataStoreTypes.SerializedItemDescriptor result = this.store.get(DataStoreTestTypes.TEST_ITEMS, startItem.key);
            this.assertEqualsSerializedItem(startItem.withVersion(store1VersionEnd), result);
        }
        finally {
            store2.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void handlesUpsertRaceConditionAgainstExternalClientWithHigherVersion() throws Exception {
        T store2 = this.makeConfiguredStore();
        int startVersion = 1;
        int store2Version = 3;
        int store1VersionEnd = 2;
        DataStoreTestTypes.TestItem startItem = new DataStoreTestTypes.TestItem("me", "foo", startVersion);
        Runnable concurrentModifier = new Runnable((PersistentDataStore)store2, startItem){
            final /* synthetic */ PersistentDataStore val$store2;
            final /* synthetic */ DataStoreTestTypes.TestItem val$startItem;
            {
                this.val$store2 = persistentDataStore;
                this.val$startItem = testItem;
            }

            @Override
            public void run() {
                this.val$store2.upsert(DataStoreTestTypes.TEST_ITEMS, this.val$startItem.key, this.val$startItem.withVersion(3).toSerializedItemDescriptor());
            }
        };
        try {
            Assume.assumeTrue((boolean)this.setUpdateHook(this.store, concurrentModifier));
            this.store.init(new DataStoreTestTypes.DataBuilder().add(DataStoreTestTypes.TEST_ITEMS, startItem).buildSerialized());
            DataStoreTestTypes.TestItem store1End = startItem.withVersion(store1VersionEnd);
            this.store.upsert(DataStoreTestTypes.TEST_ITEMS, startItem.key, store1End.toSerializedItemDescriptor());
            DataStoreTypes.SerializedItemDescriptor result = this.store.get(DataStoreTestTypes.TEST_ITEMS, startItem.key);
            this.assertEqualsSerializedItem(startItem.withVersion(3), result);
        }
        finally {
            store2.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void storesWithDifferentPrefixAreIndependent() throws Exception {
        T store1 = this.makeConfiguredStoreWithPrefix("aaa");
        Assume.assumeNotNull((Object[])new Object[]{store1});
        T store2 = this.makeConfiguredStoreWithPrefix("bbb");
        this.clearAllData();
        try {
            Assert.assertFalse((boolean)store1.isInitialized());
            Assert.assertFalse((boolean)store2.isInitialized());
            DataStoreTestTypes.TestItem item1a = new DataStoreTestTypes.TestItem("a1", "flag-a", 1);
            DataStoreTestTypes.TestItem item1b = new DataStoreTestTypes.TestItem("b", "flag-b", 1);
            DataStoreTestTypes.TestItem item2a = new DataStoreTestTypes.TestItem("a2", "flag-a", 2);
            DataStoreTestTypes.TestItem item2c = new DataStoreTestTypes.TestItem("c", "flag-c", 2);
            store1.init(new DataStoreTestTypes.DataBuilder().add(DataStoreTestTypes.TEST_ITEMS, item1a, item1b).buildSerialized());
            Assert.assertTrue((boolean)store1.isInitialized());
            Assert.assertFalse((boolean)store2.isInitialized());
            store2.init(new DataStoreTestTypes.DataBuilder().add(DataStoreTestTypes.TEST_ITEMS, item2a, item2c).buildSerialized());
            Assert.assertTrue((boolean)store1.isInitialized());
            Assert.assertTrue((boolean)store2.isInitialized());
            Map items1 = DataStoreTestTypes.toItemsMap(store1.getAll(DataStoreTestTypes.TEST_ITEMS));
            Map items2 = DataStoreTestTypes.toItemsMap(store2.getAll(DataStoreTestTypes.TEST_ITEMS));
            Assert.assertEquals((long)2L, (long)items1.size());
            Assert.assertEquals((long)2L, (long)items2.size());
            this.assertEqualsSerializedItem(item1a, (DataStoreTypes.SerializedItemDescriptor)items1.get(item1a.key));
            this.assertEqualsSerializedItem(item1b, (DataStoreTypes.SerializedItemDescriptor)items1.get(item1b.key));
            this.assertEqualsSerializedItem(item2a, (DataStoreTypes.SerializedItemDescriptor)items2.get(item2a.key));
            this.assertEqualsSerializedItem(item2c, (DataStoreTypes.SerializedItemDescriptor)items2.get(item2c.key));
            this.assertEqualsSerializedItem(item1a, store1.get(DataStoreTestTypes.TEST_ITEMS, item1a.key));
            this.assertEqualsSerializedItem(item1b, store1.get(DataStoreTestTypes.TEST_ITEMS, item1b.key));
            this.assertEqualsSerializedItem(item2a, store2.get(DataStoreTestTypes.TEST_ITEMS, item2a.key));
            this.assertEqualsSerializedItem(item2c, store2.get(DataStoreTestTypes.TEST_ITEMS, item2c.key));
        }
        finally {
            store1.close();
            store2.close();
        }
    }
}

