/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.sdk.server.integrations;

import com.launchdarkly.sdk.LDContext;
import com.launchdarkly.sdk.LDValue;
import com.launchdarkly.sdk.server.Components;
import com.launchdarkly.sdk.server.LDClient;
import com.launchdarkly.sdk.server.LDConfig;
import com.launchdarkly.sdk.server.integrations.TestData;
import com.launchdarkly.sdk.server.interfaces.DataSourceStatusProvider;
import com.launchdarkly.sdk.server.subsystems.ComponentConfigurer;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Test;

public class TestDataWithClientTest {
    private static final String SDK_KEY = "sdk-key";
    private TestData td = TestData.dataSource();
    private LDConfig config = new LDConfig.Builder().dataSource((ComponentConfigurer)this.td).events(Components.noEvents()).build();

    @Test
    public void initializesWithEmptyData() throws Exception {
        try (LDClient client = new LDClient(SDK_KEY, this.config);){
            MatcherAssert.assertThat((Object)client.isInitialized(), (Matcher)Matchers.is((Object)true));
        }
    }

    @Test
    public void initializesWithFlag() throws Exception {
        this.td.update(this.td.flag("flag").on(true));
        try (LDClient client = new LDClient(SDK_KEY, this.config);){
            MatcherAssert.assertThat((Object)client.boolVariation("flag", LDContext.create((String)"user"), false), (Matcher)Matchers.is((Object)true));
        }
    }

    @Test
    public void updatesFlag() throws Exception {
        this.td.update(this.td.flag("flag").on(false));
        try (LDClient client = new LDClient(SDK_KEY, this.config);){
            MatcherAssert.assertThat((Object)client.boolVariation("flag", LDContext.create((String)"user"), false), (Matcher)Matchers.is((Object)false));
            this.td.update(this.td.flag("flag").on(true));
            MatcherAssert.assertThat((Object)client.boolVariation("flag", LDContext.create((String)"user"), false), (Matcher)Matchers.is((Object)true));
        }
    }

    @Test
    public void usesTargets() throws Exception {
        this.td.update(this.td.flag("flag").fallthroughVariation(false).variationForUser("user1", true));
        try (LDClient client = new LDClient(SDK_KEY, this.config);){
            MatcherAssert.assertThat((Object)client.boolVariation("flag", LDContext.create((String)"user1"), false), (Matcher)Matchers.is((Object)true));
            MatcherAssert.assertThat((Object)client.boolVariation("flag", LDContext.create((String)"user2"), false), (Matcher)Matchers.is((Object)false));
        }
    }

    @Test
    public void usesRules() throws Exception {
        this.td.update(this.td.flag("flag").fallthroughVariation(false).ifMatch("name", new LDValue[]{LDValue.of((String)"Lucy")}).thenReturn(true).ifMatch("name", new LDValue[]{LDValue.of((String)"Mina")}).thenReturn(true));
        try (LDClient client = new LDClient(SDK_KEY, this.config);){
            MatcherAssert.assertThat((Object)client.boolVariation("flag", LDContext.builder((String)"user1").name("Lucy").build(), false), (Matcher)Matchers.is((Object)true));
            MatcherAssert.assertThat((Object)client.boolVariation("flag", LDContext.builder((String)"user2").name("Mina").build(), false), (Matcher)Matchers.is((Object)true));
            MatcherAssert.assertThat((Object)client.boolVariation("flag", LDContext.builder((String)"user3").name("Quincy").build(), false), (Matcher)Matchers.is((Object)false));
        }
    }

    @Test
    public void nonBooleanFlags() throws Exception {
        this.td.update(this.td.flag("flag").variations(new LDValue[]{LDValue.of((String)"red"), LDValue.of((String)"green"), LDValue.of((String)"blue")}).offVariation(0).fallthroughVariation(2).variationForUser("user1", 1).ifMatch("name", new LDValue[]{LDValue.of((String)"Mina")}).thenReturn(1));
        try (LDClient client = new LDClient(SDK_KEY, this.config);){
            MatcherAssert.assertThat((Object)client.stringVariation("flag", LDContext.builder((String)"user1").name("Lucy").build(), ""), (Matcher)Matchers.equalTo((Object)"green"));
            MatcherAssert.assertThat((Object)client.stringVariation("flag", LDContext.builder((String)"user2").name("Mina").build(), ""), (Matcher)Matchers.equalTo((Object)"green"));
            MatcherAssert.assertThat((Object)client.stringVariation("flag", LDContext.builder((String)"user3").name("Quincy").build(), ""), (Matcher)Matchers.equalTo((Object)"blue"));
            this.td.update(this.td.flag("flag").on(false));
            MatcherAssert.assertThat((Object)client.stringVariation("flag", LDContext.builder((String)"user1").name("Lucy").build(), ""), (Matcher)Matchers.equalTo((Object)"red"));
        }
    }

    @Test
    public void canUpdateStatus() throws Exception {
        try (LDClient client = new LDClient(SDK_KEY, this.config);){
            MatcherAssert.assertThat((Object)client.getDataSourceStatusProvider().getStatus().getState(), (Matcher)Matchers.equalTo((Object)DataSourceStatusProvider.State.VALID));
            DataSourceStatusProvider.ErrorInfo ei = DataSourceStatusProvider.ErrorInfo.fromHttpError((int)500);
            this.td.updateStatus(DataSourceStatusProvider.State.INTERRUPTED, ei);
            MatcherAssert.assertThat((Object)client.getDataSourceStatusProvider().getStatus().getState(), (Matcher)Matchers.equalTo((Object)DataSourceStatusProvider.State.INTERRUPTED));
            MatcherAssert.assertThat((Object)client.getDataSourceStatusProvider().getStatus().getLastError(), (Matcher)Matchers.equalTo((Object)ei));
        }
    }

    @Test
    public void dataSourcePropagatesToMultipleClients() throws Exception {
        this.td.update(this.td.flag("flag").on(true));
        try (LDClient client1 = new LDClient(SDK_KEY, this.config);
             LDClient client2 = new LDClient(SDK_KEY, this.config);){
            MatcherAssert.assertThat((Object)client1.boolVariation("flag", LDContext.create((String)"user"), false), (Matcher)Matchers.is((Object)true));
            MatcherAssert.assertThat((Object)client2.boolVariation("flag", LDContext.create((String)"user"), false), (Matcher)Matchers.is((Object)true));
            this.td.update(this.td.flag("flag").on(false));
            MatcherAssert.assertThat((Object)client1.boolVariation("flag", LDContext.create((String)"user"), false), (Matcher)Matchers.is((Object)false));
            MatcherAssert.assertThat((Object)client2.boolVariation("flag", LDContext.create((String)"user"), false), (Matcher)Matchers.is((Object)false));
        }
    }
}

