/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.sdk.server.interfaces;

import com.launchdarkly.sdk.server.TestUtil;
import com.launchdarkly.sdk.server.subsystems.BigSegmentStoreTypes;
import java.util.Arrays;
import java.util.Collections;
import org.junit.Assert;
import org.junit.Test;

public class BigSegmentMembershipBuilderTest {
    @Test
    public void empty() {
        BigSegmentStoreTypes.Membership m0 = BigSegmentStoreTypes.createMembershipFromSegmentRefs(null, null);
        BigSegmentStoreTypes.Membership m1 = BigSegmentStoreTypes.createMembershipFromSegmentRefs(Collections.emptyList(), null);
        BigSegmentStoreTypes.Membership m2 = BigSegmentStoreTypes.createMembershipFromSegmentRefs(null, Collections.emptyList());
        Assert.assertSame((Object)m0, (Object)m1);
        Assert.assertSame((Object)m0, (Object)m2);
        TestUtil.assertFullyEqual(m0, m1);
        Assert.assertNull((Object)m0.checkMembership("arbitrary"));
    }

    @Test
    public void singleInclusion() {
        BigSegmentStoreTypes.Membership m0 = BigSegmentStoreTypes.createMembershipFromSegmentRefs(Collections.singleton("key1"), null);
        BigSegmentStoreTypes.Membership m1 = BigSegmentStoreTypes.createMembershipFromSegmentRefs(Collections.singleton("key1"), null);
        Assert.assertNotSame((Object)m0, (Object)m1);
        TestUtil.assertFullyEqual(m0, m1);
        Assert.assertTrue((boolean)m0.checkMembership("key1"));
        Assert.assertNull((Object)m0.checkMembership("key2"));
        TestUtil.assertFullyUnequal(m0, BigSegmentStoreTypes.createMembershipFromSegmentRefs(null, Collections.singleton("key1")));
        TestUtil.assertFullyUnequal(m0, BigSegmentStoreTypes.createMembershipFromSegmentRefs(Collections.singleton("key2"), null));
        TestUtil.assertFullyUnequal(m0, BigSegmentStoreTypes.createMembershipFromSegmentRefs(null, null));
    }

    @Test
    public void multipleInclusions() {
        BigSegmentStoreTypes.Membership m0 = BigSegmentStoreTypes.createMembershipFromSegmentRefs(Arrays.asList("key1", "key2"), null);
        BigSegmentStoreTypes.Membership m1 = BigSegmentStoreTypes.createMembershipFromSegmentRefs(Arrays.asList("key2", "key1"), null);
        Assert.assertNotSame((Object)m0, (Object)m1);
        TestUtil.assertFullyEqual(m0, m1);
        Assert.assertTrue((boolean)m0.checkMembership("key1"));
        Assert.assertTrue((boolean)m0.checkMembership("key2"));
        Assert.assertNull((Object)m0.checkMembership("key3"));
        TestUtil.assertFullyUnequal(m0, BigSegmentStoreTypes.createMembershipFromSegmentRefs(Arrays.asList("key1", "key2"), Collections.singleton("key3")));
        TestUtil.assertFullyUnequal(m0, BigSegmentStoreTypes.createMembershipFromSegmentRefs(Arrays.asList("key1", "key3"), null));
        TestUtil.assertFullyUnequal(m0, BigSegmentStoreTypes.createMembershipFromSegmentRefs(Collections.singleton("key1"), null));
        TestUtil.assertFullyUnequal(m0, BigSegmentStoreTypes.createMembershipFromSegmentRefs(null, null));
    }

    @Test
    public void singleExclusion() {
        BigSegmentStoreTypes.Membership m0 = BigSegmentStoreTypes.createMembershipFromSegmentRefs(null, Collections.singleton("key1"));
        BigSegmentStoreTypes.Membership m1 = BigSegmentStoreTypes.createMembershipFromSegmentRefs(null, Collections.singleton("key1"));
        Assert.assertNotSame((Object)m0, (Object)m1);
        TestUtil.assertFullyEqual(m0, m1);
        Assert.assertFalse((boolean)m0.checkMembership("key1"));
        Assert.assertNull((Object)m0.checkMembership("key2"));
        TestUtil.assertFullyUnequal(m0, BigSegmentStoreTypes.createMembershipFromSegmentRefs(Collections.singleton("key1"), null));
        TestUtil.assertFullyUnequal(m0, BigSegmentStoreTypes.createMembershipFromSegmentRefs(null, Collections.singleton("key2")));
        TestUtil.assertFullyUnequal(m0, BigSegmentStoreTypes.createMembershipFromSegmentRefs(null, null));
    }

    @Test
    public void multipleExclusions() {
        BigSegmentStoreTypes.Membership m0 = BigSegmentStoreTypes.createMembershipFromSegmentRefs(null, Arrays.asList("key1", "key2"));
        BigSegmentStoreTypes.Membership m1 = BigSegmentStoreTypes.createMembershipFromSegmentRefs(null, Arrays.asList("key2", "key1"));
        Assert.assertNotSame((Object)m0, (Object)m1);
        TestUtil.assertFullyEqual(m0, m1);
        Assert.assertFalse((boolean)m0.checkMembership("key1"));
        Assert.assertFalse((boolean)m0.checkMembership("key2"));
        Assert.assertNull((Object)m0.checkMembership("key3"));
        TestUtil.assertFullyUnequal(m0, BigSegmentStoreTypes.createMembershipFromSegmentRefs(Collections.singleton("key3"), Arrays.asList("key1", "key2")));
        TestUtil.assertFullyUnequal(m0, BigSegmentStoreTypes.createMembershipFromSegmentRefs(null, Arrays.asList("key1", "key3")));
        TestUtil.assertFullyUnequal(m0, BigSegmentStoreTypes.createMembershipFromSegmentRefs(null, Collections.singleton("key1")));
        TestUtil.assertFullyUnequal(m0, BigSegmentStoreTypes.createMembershipFromSegmentRefs(null, null));
    }

    @Test
    public void inclusionsAndExclusions() {
        BigSegmentStoreTypes.Membership m0 = BigSegmentStoreTypes.createMembershipFromSegmentRefs(Arrays.asList("key1", "key2"), Arrays.asList("key2", "key3"));
        BigSegmentStoreTypes.Membership m1 = BigSegmentStoreTypes.createMembershipFromSegmentRefs(Arrays.asList("key2", "key1"), Arrays.asList("key3", "key2"));
        Assert.assertNotSame((Object)m0, (Object)m1);
        TestUtil.assertFullyEqual(m0, m1);
        Assert.assertTrue((boolean)m0.checkMembership("key1"));
        Assert.assertTrue((boolean)m0.checkMembership("key2"));
        Assert.assertFalse((boolean)m0.checkMembership("key3"));
        Assert.assertNull((Object)m0.checkMembership("key4"));
        TestUtil.assertFullyUnequal(m0, BigSegmentStoreTypes.createMembershipFromSegmentRefs(Arrays.asList("key1", "key2"), Arrays.asList("key2", "key3", "key4")));
        TestUtil.assertFullyUnequal(m0, BigSegmentStoreTypes.createMembershipFromSegmentRefs(Arrays.asList("key1", "key2", "key3"), Arrays.asList("key2", "key3")));
        TestUtil.assertFullyUnequal(m0, BigSegmentStoreTypes.createMembershipFromSegmentRefs(Collections.singleton("key1"), null));
        TestUtil.assertFullyUnequal(m0, BigSegmentStoreTypes.createMembershipFromSegmentRefs(null, null));
    }
}

