/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.sdk.server.interfaces;

import com.launchdarkly.sdk.server.interfaces.DataSourceStatusProvider;
import com.launchdarkly.testhelpers.TypeBehavior;
import java.time.Instant;
import java.util.ArrayList;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Test;

public class DataSourceStatusProviderTypesTest {
    @Test
    public void statusProperties() {
        Instant time = Instant.ofEpochMilli(10000L);
        DataSourceStatusProvider.ErrorInfo e = DataSourceStatusProvider.ErrorInfo.fromHttpError((int)401);
        DataSourceStatusProvider.Status s = new DataSourceStatusProvider.Status(DataSourceStatusProvider.State.VALID, time, e);
        MatcherAssert.assertThat((Object)s.getState(), (Matcher)Matchers.equalTo((Object)DataSourceStatusProvider.State.VALID));
        MatcherAssert.assertThat((Object)s.getStateSince(), (Matcher)Matchers.equalTo((Object)time));
        MatcherAssert.assertThat((Object)s.getLastError(), (Matcher)Matchers.sameInstance((Object)e));
    }

    @Test
    public void statusEquality() {
        ArrayList<TypeBehavior.ValueFactory> allPermutations = new ArrayList<TypeBehavior.ValueFactory>();
        for (DataSourceStatusProvider.State state : DataSourceStatusProvider.State.values()) {
            for (Instant time : new Instant[]{Instant.ofEpochMilli(1000L), Instant.ofEpochMilli(2000L)}) {
                for (DataSourceStatusProvider.ErrorInfo e : new DataSourceStatusProvider.ErrorInfo[]{null, DataSourceStatusProvider.ErrorInfo.fromHttpError((int)400), DataSourceStatusProvider.ErrorInfo.fromHttpError((int)401)}) {
                    allPermutations.add(() -> new DataSourceStatusProvider.Status(state, time, e));
                }
            }
        }
        TypeBehavior.checkEqualsAndHashCode(allPermutations);
    }

    @Test
    public void statusStringRepresentation() {
        DataSourceStatusProvider.Status s1 = new DataSourceStatusProvider.Status(DataSourceStatusProvider.State.VALID, Instant.now(), null);
        MatcherAssert.assertThat((Object)s1.toString(), (Matcher)Matchers.equalTo((Object)("Status(VALID," + s1.getStateSince() + ",null)")));
        DataSourceStatusProvider.Status s2 = new DataSourceStatusProvider.Status(DataSourceStatusProvider.State.VALID, Instant.now(), DataSourceStatusProvider.ErrorInfo.fromHttpError((int)401));
        MatcherAssert.assertThat((Object)s2.toString(), (Matcher)Matchers.equalTo((Object)("Status(VALID," + s2.getStateSince() + "," + s2.getLastError() + ")")));
    }

    @Test
    public void errorInfoProperties() {
        Instant time = Instant.ofEpochMilli(10000L);
        DataSourceStatusProvider.ErrorInfo e1 = new DataSourceStatusProvider.ErrorInfo(DataSourceStatusProvider.ErrorKind.ERROR_RESPONSE, 401, "nope", time);
        MatcherAssert.assertThat((Object)e1.getKind(), (Matcher)Matchers.equalTo((Object)DataSourceStatusProvider.ErrorKind.ERROR_RESPONSE));
        MatcherAssert.assertThat((Object)e1.getStatusCode(), (Matcher)Matchers.equalTo((Object)401));
        MatcherAssert.assertThat((Object)e1.getMessage(), (Matcher)Matchers.equalTo((Object)"nope"));
        MatcherAssert.assertThat((Object)e1.getTime(), (Matcher)Matchers.equalTo((Object)time));
        DataSourceStatusProvider.ErrorInfo e2 = DataSourceStatusProvider.ErrorInfo.fromHttpError((int)401);
        MatcherAssert.assertThat((Object)e2.getKind(), (Matcher)Matchers.equalTo((Object)DataSourceStatusProvider.ErrorKind.ERROR_RESPONSE));
        MatcherAssert.assertThat((Object)e2.getStatusCode(), (Matcher)Matchers.equalTo((Object)401));
        MatcherAssert.assertThat((Object)e2.getMessage(), (Matcher)Matchers.nullValue());
        MatcherAssert.assertThat((Object)e2.getTime(), (Matcher)Matchers.not((Matcher)Matchers.nullValue()));
        Exception ex = new Exception("sorry");
        DataSourceStatusProvider.ErrorInfo e3 = DataSourceStatusProvider.ErrorInfo.fromException((DataSourceStatusProvider.ErrorKind)DataSourceStatusProvider.ErrorKind.UNKNOWN, (Throwable)ex);
        MatcherAssert.assertThat((Object)e3.getKind(), (Matcher)Matchers.equalTo((Object)DataSourceStatusProvider.ErrorKind.UNKNOWN));
        MatcherAssert.assertThat((Object)e3.getStatusCode(), (Matcher)Matchers.equalTo((Object)0));
        MatcherAssert.assertThat((Object)e3.getMessage(), (Matcher)Matchers.equalTo((Object)ex.toString()));
        MatcherAssert.assertThat((Object)e3.getTime(), (Matcher)Matchers.not((Matcher)Matchers.nullValue()));
    }

    @Test
    public void errorInfoEquality() {
        ArrayList<TypeBehavior.ValueFactory> allPermutations = new ArrayList<TypeBehavior.ValueFactory>();
        for (DataSourceStatusProvider.ErrorKind kind : DataSourceStatusProvider.ErrorKind.values()) {
            for (int statusCode : new int[]{0, 1}) {
                for (String message : new String[]{null, "a", "b"}) {
                    for (Instant time : new Instant[]{Instant.ofEpochMilli(1000L), Instant.ofEpochMilli(2000L)}) {
                        allPermutations.add(() -> new DataSourceStatusProvider.ErrorInfo(kind, statusCode, message, time));
                    }
                }
            }
        }
        TypeBehavior.checkEqualsAndHashCode(allPermutations);
    }

    @Test
    public void errorStringRepresentation() {
        DataSourceStatusProvider.ErrorInfo e1 = new DataSourceStatusProvider.ErrorInfo(DataSourceStatusProvider.ErrorKind.ERROR_RESPONSE, 401, null, Instant.now());
        MatcherAssert.assertThat((Object)e1.toString(), (Matcher)Matchers.equalTo((Object)("ERROR_RESPONSE(401)@" + e1.getTime())));
        DataSourceStatusProvider.ErrorInfo e2 = new DataSourceStatusProvider.ErrorInfo(DataSourceStatusProvider.ErrorKind.ERROR_RESPONSE, 401, "nope", Instant.now());
        MatcherAssert.assertThat((Object)e2.toString(), (Matcher)Matchers.equalTo((Object)("ERROR_RESPONSE(401,nope)@" + e2.getTime())));
        DataSourceStatusProvider.ErrorInfo e3 = new DataSourceStatusProvider.ErrorInfo(DataSourceStatusProvider.ErrorKind.NETWORK_ERROR, 0, "hello", Instant.now());
        MatcherAssert.assertThat((Object)e3.toString(), (Matcher)Matchers.equalTo((Object)("NETWORK_ERROR(hello)@" + e3.getTime())));
        DataSourceStatusProvider.ErrorInfo e4 = new DataSourceStatusProvider.ErrorInfo(DataSourceStatusProvider.ErrorKind.STORE_ERROR, 0, null, Instant.now());
        MatcherAssert.assertThat((Object)e4.toString(), (Matcher)Matchers.equalTo((Object)("STORE_ERROR@" + e4.getTime())));
        DataSourceStatusProvider.ErrorInfo e5 = new DataSourceStatusProvider.ErrorInfo(DataSourceStatusProvider.ErrorKind.UNKNOWN, 0, null, null);
        MatcherAssert.assertThat((Object)e5.toString(), (Matcher)Matchers.equalTo((Object)"UNKNOWN"));
    }
}

