/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.shaded.com.launchdarkly.sdk.internal.events;

import com.launchdarkly.logging.LDLogger;
import com.launchdarkly.logging.LogValues;
import com.launchdarkly.shaded.com.launchdarkly.sdk.internal.events.EventSender;
import com.launchdarkly.shaded.com.launchdarkly.sdk.internal.http.HttpErrors;
import com.launchdarkly.shaded.com.launchdarkly.sdk.internal.http.HttpHelpers;
import com.launchdarkly.shaded.com.launchdarkly.sdk.internal.http.HttpProperties;
import com.launchdarkly.shaded.okhttp3.Headers;
import com.launchdarkly.shaded.okhttp3.MediaType;
import com.launchdarkly.shaded.okhttp3.OkHttpClient;
import com.launchdarkly.shaded.okhttp3.Request;
import com.launchdarkly.shaded.okhttp3.RequestBody;
import com.launchdarkly.shaded.okhttp3.Response;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.URI;
import java.nio.charset.Charset;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.UUID;
import java.util.zip.GZIPOutputStream;

public final class DefaultEventSender
implements EventSender {
    public static final long DEFAULT_RETRY_DELAY_MILLIS = 1000L;
    public static final String DEFAULT_ANALYTICS_REQUEST_PATH = "/bulk";
    public static final String DEFAULT_DIAGNOSTIC_REQUEST_PATH = "/diagnostic";
    private static final String EVENT_SCHEMA_HEADER = "X-LaunchDarkly-Event-Schema";
    private static final String EVENT_SCHEMA_VERSION = "4";
    private static final String EVENT_PAYLOAD_ID_HEADER = "X-LaunchDarkly-Payload-ID";
    private static final MediaType JSON_CONTENT_TYPE = MediaType.parse("application/json; charset=utf-8");
    private static final SimpleDateFormat HTTP_DATE_FORMAT = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss zzz", Locale.US);
    private static final Object HTTP_DATE_FORMAT_LOCK = new Object();
    private final OkHttpClient httpClient;
    private final boolean shouldCloseHttpClient;
    private final Headers baseHeaders;
    private final String analyticsRequestPath;
    private final String diagnosticRequestPath;
    final long retryDelayMillis;
    private final LDLogger logger;
    private final boolean enableGzipCompression;

    public DefaultEventSender(HttpProperties httpProperties, String analyticsRequestPath, String diagnosticRequestPath, long retryDelayMillis, boolean enableGzipCompression, LDLogger logger) {
        if (httpProperties.getSharedHttpClient() == null) {
            this.httpClient = httpProperties.toHttpClientBuilder().build();
            this.shouldCloseHttpClient = true;
        } else {
            this.httpClient = httpProperties.getSharedHttpClient();
            this.shouldCloseHttpClient = false;
        }
        this.logger = logger;
        this.enableGzipCompression = enableGzipCompression;
        this.baseHeaders = httpProperties.toHeadersBuilder().add("Content-Type", "application/json").build();
        this.analyticsRequestPath = analyticsRequestPath == null ? DEFAULT_ANALYTICS_REQUEST_PATH : analyticsRequestPath;
        this.diagnosticRequestPath = diagnosticRequestPath == null ? DEFAULT_DIAGNOSTIC_REQUEST_PATH : diagnosticRequestPath;
        this.retryDelayMillis = retryDelayMillis <= 0L ? 1000L : retryDelayMillis;
    }

    @Override
    public void close() throws IOException {
        if (this.shouldCloseHttpClient) {
            HttpProperties.shutdownHttpClient(this.httpClient);
        }
    }

    @Override
    public EventSender.Result sendAnalyticsEvents(byte[] data, int eventCount, URI eventsBaseUri) {
        return this.sendEventData(false, data, eventCount, eventsBaseUri);
    }

    @Override
    public EventSender.Result sendDiagnosticEvent(byte[] data, URI eventsBaseUri) {
        return this.sendEventData(true, data, 1, eventsBaseUri);
    }

    private CompressionResult<byte[]> compressData(byte[] data) {
        if (!this.enableGzipCompression) {
            return new CompressionResult<byte[]>(data, false);
        }
        try {
            ByteArrayOutputStream byteStream = new ByteArrayOutputStream();
            try (GZIPOutputStream gzipStream = new GZIPOutputStream(byteStream);){
                gzipStream.write(data);
            }
            byte[] compressedData = byteStream.toByteArray();
            return new CompressionResult<byte[]>(compressedData, true);
        }
        catch (IOException e) {
            this.logger.warn("Failed to compress event data, falling back to uncompressed: {}", (Object)e.toString());
            return new CompressionResult<byte[]>(data, false);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private EventSender.Result sendEventData(boolean isDiagnostic, byte[] data, int eventCount, URI eventsBaseUri) {
        String description;
        String path;
        if (data == null) return new EventSender.Result(true, false, null);
        if (data.length == 0) {
            return new EventSender.Result(true, false, null);
        }
        Headers.Builder headersBuilder = this.baseHeaders.newBuilder();
        if (isDiagnostic) {
            path = this.diagnosticRequestPath;
            description = "diagnostic event";
        } else {
            path = this.analyticsRequestPath;
            String eventPayloadId = UUID.randomUUID().toString();
            headersBuilder.add(EVENT_PAYLOAD_ID_HEADER, eventPayloadId);
            headersBuilder.add(EVENT_SCHEMA_HEADER, EVENT_SCHEMA_VERSION);
            description = String.format("%d event(s)", eventCount);
        }
        URI uri = HttpHelpers.concatenateUriPath(eventsBaseUri, path);
        CompressionResult<byte[]> compressionResult = this.compressData(data);
        RequestBody body = RequestBody.create((byte[])compressionResult.data, JSON_CONTENT_TYPE);
        boolean mustShutDown = false;
        if (compressionResult.wasCompressed) {
            headersBuilder.add("Content-Encoding", "gzip");
        }
        Headers headers = headersBuilder.build();
        this.logger.debug("Posting {} to {} with payload: {}", description, uri, LogValues.defer(new LazilyPrintedUtf8Data(data)));
        int attempt = 0;
        while (attempt < 2) {
            if (attempt > 0) {
                this.logger.warn("Will retry posting {} after {}ms", (Object)description, (Object)this.retryDelayMillis);
                try {
                    Thread.sleep(this.retryDelayMillis);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            Request request = new Request.Builder().url(uri.toASCIIString()).post(body).headers(headers).build();
            long startTime = System.currentTimeMillis();
            String nextActionMessage = attempt == 0 ? "will retry" : "some events were dropped";
            String errorContext = "posting " + description;
            try (Response response = this.httpClient.newCall(request).execute();){
                long endTime = System.currentTimeMillis();
                this.logger.debug("{} delivery took {} ms, response status {}", description, endTime - startTime, response.code());
                if (response.isSuccessful()) {
                    EventSender.Result result = new EventSender.Result(true, false, this.parseResponseDate(response));
                    return result;
                }
                String errorDesc = HttpErrors.httpErrorDescription(response.code());
                boolean recoverable = HttpErrors.checkIfErrorIsRecoverableAndLog(this.logger, errorDesc, errorContext, response.code(), nextActionMessage);
                if (!recoverable) {
                    mustShutDown = true;
                    return new EventSender.Result(false, mustShutDown, null);
                }
            }
            catch (IOException e) {
                HttpErrors.checkIfErrorIsRecoverableAndLog(this.logger, e.toString(), errorContext, 0, nextActionMessage);
            }
            ++attempt;
        }
        return new EventSender.Result(false, mustShutDown, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Date parseResponseDate(Response response) {
        String dateStr = response.header("Date");
        if (dateStr != null) {
            try {
                Object object = HTTP_DATE_FORMAT_LOCK;
                synchronized (object) {
                    return HTTP_DATE_FORMAT.parse(dateStr);
                }
            }
            catch (ParseException e) {
                this.logger.warn("Received invalid Date header from events service");
            }
        }
        return null;
    }

    private final class LazilyPrintedUtf8Data
    implements LogValues.StringProvider {
        private final byte[] data;

        LazilyPrintedUtf8Data(byte[] data) {
            this.data = data;
        }

        @Override
        public String get() {
            return this.data == null ? "" : new String(this.data, Charset.forName("UTF-8"));
        }
    }

    private static class CompressionResult<T> {
        final T data;
        final boolean wasCompressed;

        CompressionResult(T data, boolean wasCompressed) {
            this.data = data;
            this.wasCompressed = wasCompressed;
        }
    }
}

