/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.shaded.org.yaml.snakeyaml.util;

import com.launchdarkly.shaded.org.yaml.snakeyaml.nodes.MappingNode;
import com.launchdarkly.shaded.org.yaml.snakeyaml.nodes.Node;
import com.launchdarkly.shaded.org.yaml.snakeyaml.nodes.NodeTuple;
import com.launchdarkly.shaded.org.yaml.snakeyaml.nodes.ScalarNode;
import com.launchdarkly.shaded.org.yaml.snakeyaml.nodes.SequenceNode;
import com.launchdarkly.shaded.org.yaml.snakeyaml.nodes.Tag;
import com.launchdarkly.shaded.org.yaml.snakeyaml.util.Tuple;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public abstract class MergeUtils {
    public abstract MappingNode asMappingNode(Node var1);

    public List<NodeTuple> flatten(MappingNode node) {
        List<NodeTuple> toProcess;
        List<NodeTuple> result = toProcess = node.getValue();
        boolean process = true;
        while (process) {
            process = false;
            ArrayList<NodeTuple> updated = new ArrayList<NodeTuple>(toProcess.size());
            HashSet<String> keys2 = new HashSet<String>(toProcess.size());
            ArrayList<NodeTuple> merges = new ArrayList<NodeTuple>(2);
            for (NodeTuple tuple : toProcess) {
                Node keyNode = tuple.getKeyNode();
                if (keyNode.getTag().equals(Tag.MERGE)) {
                    merges.add(tuple);
                    continue;
                }
                updated.add(tuple);
                if (!(keyNode instanceof ScalarNode)) continue;
                ScalarNode sNode = (ScalarNode)keyNode;
                keys2.add(sNode.getValue());
            }
            for (NodeTuple tuple : merges) {
                Node valueNode = tuple.getValueNode();
                if (valueNode instanceof SequenceNode) {
                    SequenceNode seqNode = (SequenceNode)valueNode;
                    for (Node ref : seqNode.getValue()) {
                        MappingNode mergable = this.asMappingNode(ref);
                        process = process || mergable.isMerged();
                        Tuple<List<NodeTuple>, Set<String>> filtered = this.filter(mergable.getValue(), keys2);
                        updated.addAll((Collection<NodeTuple>)filtered._1());
                        keys2.addAll((Collection<String>)filtered._2());
                    }
                    continue;
                }
                MappingNode mergable = this.asMappingNode(valueNode);
                process = process || mergable.isMerged();
                Tuple<List<NodeTuple>, Set<String>> filtered = this.filter(mergable.getValue(), keys2);
                updated.addAll((Collection<NodeTuple>)filtered._1());
                keys2.addAll((Collection<String>)filtered._2());
            }
            result = updated;
            if (!process) continue;
            toProcess = updated;
        }
        return result;
    }

    private Tuple<List<NodeTuple>, Set<String>> filter(List<NodeTuple> mergables, Set<String> filter) {
        int size = mergables.size();
        HashSet<String> keys2 = new HashSet<String>(size);
        ArrayList<NodeTuple> result = new ArrayList<NodeTuple>(size);
        for (NodeTuple tuple : mergables) {
            Node key = tuple.getKeyNode();
            if (key instanceof ScalarNode) {
                ScalarNode sNode = (ScalarNode)key;
                String nodeValue = sNode.getValue();
                if (filter.contains(nodeValue)) continue;
                result.add(tuple);
                keys2.add(nodeValue);
                continue;
            }
            result.add(tuple);
        }
        return new Tuple<List<NodeTuple>, Set<String>>(result, keys2);
    }
}

