/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.sdk;

import com.launchdarkly.sdk.AttributeRef;
import com.launchdarkly.sdk.ContextKind;
import com.launchdarkly.sdk.LDContext;
import com.launchdarkly.sdk.LDValue;
import com.launchdarkly.sdk.LDValueType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class ContextBuilder {
    private ContextKind kind;
    private String key;
    private String name;
    private Map<String, LDValue> attributes;
    private boolean anonymous;
    private List<AttributeRef> privateAttributes;
    private boolean copyOnWriteAttributes;
    private boolean copyOnWritePrivateAttributes;
    private boolean allowEmptyKey;

    ContextBuilder() {
    }

    ContextBuilder(ContextKind kind, String key) {
        this.kind = kind;
        this.key = key;
    }

    public LDContext build() {
        this.copyOnWriteAttributes = this.attributes != null;
        this.copyOnWritePrivateAttributes = this.privateAttributes != null;
        return LDContext.createSingle(this.kind, this.key, this.name, this.attributes, this.anonymous, this.privateAttributes, this.allowEmptyKey);
    }

    public ContextBuilder kind(ContextKind kind) {
        this.kind = kind;
        return this;
    }

    public ContextBuilder kind(String kindString) {
        return this.kind(ContextKind.of(kindString));
    }

    public ContextBuilder key(String key) {
        this.key = key;
        return this;
    }

    public ContextBuilder name(String name) {
        this.name = name;
        return this;
    }

    public ContextBuilder anonymous(boolean anonymous) {
        this.anonymous = anonymous;
        return this;
    }

    public ContextBuilder set(String attributeName, LDValue value) {
        this.trySet(attributeName, value);
        return this;
    }

    public ContextBuilder set(String attributeName, boolean value) {
        return this.set(attributeName, LDValue.of(value));
    }

    public ContextBuilder set(String attributeName, int value) {
        return this.set(attributeName, LDValue.of(value));
    }

    public ContextBuilder set(String attributeName, double value) {
        return this.set(attributeName, LDValue.of(value));
    }

    public ContextBuilder set(String attributeName, String value) {
        return this.set(attributeName, LDValue.of(value));
    }

    public boolean trySet(String attributeName, LDValue value) {
        if (attributeName == null || attributeName.isEmpty()) {
            return false;
        }
        switch (attributeName) {
            case "kind": {
                if (!value.isString()) {
                    return false;
                }
                this.kind = ContextKind.of(value.stringValue());
                break;
            }
            case "key": {
                if (!value.isString()) {
                    return false;
                }
                this.key = value.stringValue();
                break;
            }
            case "name": {
                if (!value.isString() && !value.isNull()) {
                    return false;
                }
                this.name = value.stringValue();
                break;
            }
            case "anonymous": {
                if (value.getType() != LDValueType.BOOLEAN) {
                    return false;
                }
                this.anonymous = value.booleanValue();
                break;
            }
            case "_meta": {
                return false;
            }
            default: {
                if (this.copyOnWriteAttributes) {
                    this.attributes = new HashMap<String, LDValue>(this.attributes);
                    this.copyOnWriteAttributes = false;
                }
                if (value == null || value.isNull()) {
                    if (this.attributes == null) break;
                    this.attributes.remove(attributeName);
                    break;
                }
                if (this.attributes == null) {
                    this.attributes = new HashMap<String, LDValue>();
                }
                this.attributes.put(attributeName, value);
            }
        }
        return true;
    }

    public ContextBuilder privateAttributes(String ... attributeRefs) {
        if (attributeRefs == null || attributeRefs.length == 0) {
            return this;
        }
        this.prepareToChangePrivate();
        for (String a : attributeRefs) {
            this.privateAttributes.add(AttributeRef.fromPath(a));
        }
        return this;
    }

    public ContextBuilder privateAttributes(AttributeRef ... attributeRefs) {
        if (attributeRefs == null || attributeRefs.length == 0) {
            return this;
        }
        this.prepareToChangePrivate();
        for (AttributeRef a : attributeRefs) {
            this.privateAttributes.add(a);
        }
        return this;
    }

    void setAllowEmptyKey(boolean allowEmptyKey) {
        this.allowEmptyKey = allowEmptyKey;
    }

    ContextBuilder copyFrom(LDContext context) {
        this.kind = context.getKind();
        this.key = context.getKey();
        this.name = context.getName();
        this.anonymous = context.isAnonymous();
        this.attributes = context.attributes;
        this.privateAttributes = context.privateAttributes;
        this.copyOnWriteAttributes = context.attributes != null;
        this.copyOnWritePrivateAttributes = context.privateAttributes != null;
        return this;
    }

    private void prepareToChangePrivate() {
        if (this.copyOnWritePrivateAttributes) {
            this.privateAttributes = new ArrayList<AttributeRef>(this.privateAttributes);
            this.copyOnWritePrivateAttributes = false;
        } else if (this.privateAttributes == null) {
            this.privateAttributes = new ArrayList<AttributeRef>();
        }
    }
}

